package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TransactionConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TransactionConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TransactionConfigBase"})
@Immutable
public final class TransactionConfig extends TransactionConfigBase {
  private final int profilingIntervalMillis;
  private final int slowThresholdMillis;
  private final String defaultDisplayedTransactionType;
  private final ImmutableList<Double> defaultDisplayedPercentiles;
  private final String version;

  private TransactionConfig(TransactionConfig.Builder builder) {
    this.profilingIntervalMillis = builder.profilingIntervalMillisIsSet()
        ? builder.profilingIntervalMillis
        : super.profilingIntervalMillis();
    this.slowThresholdMillis = builder.slowThresholdMillisIsSet()
        ? builder.slowThresholdMillis
        : super.slowThresholdMillis();
    this.defaultDisplayedTransactionType = builder.defaultDisplayedTransactionType != null
        ? builder.defaultDisplayedTransactionType
        : Preconditions.checkNotNull(super.defaultDisplayedTransactionType());
    this.defaultDisplayedPercentiles = builder.defaultDisplayedPercentiles != null
        ? builder.defaultDisplayedPercentiles
        : Preconditions.checkNotNull(super.defaultDisplayedPercentiles());
    this.version = Preconditions.checkNotNull(super.version());
  }

  private TransactionConfig(
      int profilingIntervalMillis,
      int slowThresholdMillis,
      String defaultDisplayedTransactionType,
      ImmutableList<Double> defaultDisplayedPercentiles) {
    this.profilingIntervalMillis = profilingIntervalMillis;
    this.slowThresholdMillis = slowThresholdMillis;
    this.defaultDisplayedTransactionType = defaultDisplayedTransactionType;
    this.defaultDisplayedPercentiles = defaultDisplayedPercentiles;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code profilingIntervalMillis} attribute
   */
  @JsonProperty("profilingIntervalMillis")
  @Override
  public int profilingIntervalMillis() {
    return profilingIntervalMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code slowThresholdMillis} attribute
   */
  @JsonProperty("slowThresholdMillis")
  @Override
  public int slowThresholdMillis() {
    return slowThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultDisplayedTransactionType} attribute
   */
  @JsonProperty("defaultDisplayedTransactionType")
  @Override
  public String defaultDisplayedTransactionType() {
    return defaultDisplayedTransactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultDisplayedPercentiles} attribute
   */
  @JsonProperty("defaultDisplayedPercentiles")
  @Override
  public ImmutableList<Double> defaultDisplayedPercentiles() {
    return defaultDisplayedPercentiles;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionConfigBase#profilingIntervalMillis() profilingIntervalMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for profilingIntervalMillis
   * @return modified copy of the {@code this} object
   */
  public final TransactionConfig withProfilingIntervalMillis(int value) {
    if (this.profilingIntervalMillis == value) {
      return this;
    }
    int newValue = value;
    return new TransactionConfig(
        newValue,
        this.slowThresholdMillis,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionConfigBase#slowThresholdMillis() slowThresholdMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for slowThresholdMillis
   * @return modified copy of the {@code this} object
   */
  public final TransactionConfig withSlowThresholdMillis(int value) {
    if (this.slowThresholdMillis == value) {
      return this;
    }
    int newValue = value;
    return new TransactionConfig(
        this.profilingIntervalMillis,
        newValue,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionConfigBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for defaultDisplayedTransactionType
   * @return modified copy of the {@code this} object
   */
  public final TransactionConfig withDefaultDisplayedTransactionType(String value) {
    if (this.defaultDisplayedTransactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new TransactionConfig(this.profilingIntervalMillis, this.slowThresholdMillis, newValue, this.defaultDisplayedPercentiles);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionConfigBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for defaultDisplayedPercentiles
   * @return modified copy of the {@code this} object
   */
  public final TransactionConfig withDefaultDisplayedPercentiles(ImmutableList<Double> value) {
    if (this.defaultDisplayedPercentiles == value) {
      return this;
    }
    ImmutableList<Double> newValue = Preconditions.checkNotNull(value);
    return new TransactionConfig(
        this.profilingIntervalMillis,
        this.slowThresholdMillis,
        this.defaultDisplayedTransactionType,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TransactionConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TransactionConfig && equalTo((TransactionConfig) another));
  }
  
  private boolean equalTo(TransactionConfig another) {
    return profilingIntervalMillis == another.profilingIntervalMillis
        && slowThresholdMillis == another.slowThresholdMillis
        && defaultDisplayedTransactionType.equals(another.defaultDisplayedTransactionType)
        && defaultDisplayedPercentiles.equals(another.defaultDisplayedPercentiles)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code profilingIntervalMillis}, {@code slowThresholdMillis}, {@code defaultDisplayedTransactionType}, {@code defaultDisplayedPercentiles}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + profilingIntervalMillis;
    h = h * 17 + slowThresholdMillis;
    h = h * 17 + defaultDisplayedTransactionType.hashCode();
    h = h * 17 + defaultDisplayedPercentiles.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code TransactionConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransactionConfig")
        .add("profilingIntervalMillis", profilingIntervalMillis)
        .add("slowThresholdMillis", slowThresholdMillis)
        .add("defaultDisplayedTransactionType", defaultDisplayedTransactionType)
        .add("defaultDisplayedPercentiles", defaultDisplayedPercentiles)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static TransactionConfig fromAllAttributes(
      @JsonProperty("profilingIntervalMillis") @Nullable Integer profilingIntervalMillis,
      @JsonProperty("slowThresholdMillis") @Nullable Integer slowThresholdMillis,
      @JsonProperty("defaultDisplayedTransactionType") @Nullable String defaultDisplayedTransactionType,
      @JsonProperty("defaultDisplayedPercentiles") @Nullable ImmutableList<Double> defaultDisplayedPercentiles) {
    TransactionConfig.Builder builder = TransactionConfig.builder();
    if (profilingIntervalMillis != null) {
      builder.profilingIntervalMillis(profilingIntervalMillis);
    }
    if (slowThresholdMillis != null) {
      builder.slowThresholdMillis(slowThresholdMillis);
    }
    if (defaultDisplayedTransactionType != null) {
      builder.defaultDisplayedTransactionType(defaultDisplayedTransactionType);
    }
    if (defaultDisplayedPercentiles != null) {
      builder.defaultDisplayedPercentiles(defaultDisplayedPercentiles);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link TransactionConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable TransactionConfig instance
   */
  public static TransactionConfig copyOf(TransactionConfigBase instance) {
    if (instance instanceof TransactionConfig) {
      return (TransactionConfig) instance;
    }
    return TransactionConfig.builder()
        .profilingIntervalMillis(instance.profilingIntervalMillis())
        .slowThresholdMillis(instance.slowThresholdMillis())
        .defaultDisplayedTransactionType(instance.defaultDisplayedTransactionType())
        .defaultDisplayedPercentiles(instance.defaultDisplayedPercentiles())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.TransactionConfig}.
   * @return new TransactionConfig builder
   */
  public static TransactionConfig.Builder builder() {
    return new TransactionConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.TransactionConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_PROFILING_INTERVAL_MILLIS = 0x1L;
    private static final long NONDEFAULT_BIT_SLOW_THRESHOLD_MILLIS = 0x2L;
    private static final long NONDEFAULT_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE = 0x4L;
    private static final long NONDEFAULT_BIT_DEFAULT_DISPLAYED_PERCENTILES = 0x8L;
    private long nondefaultBitset;
  
    private int profilingIntervalMillis;
    private int slowThresholdMillis;
    private @Nullable String defaultDisplayedTransactionType;
    private @Nullable ImmutableList<Double> defaultDisplayedPercentiles;
    private Builder() {}
  
    /**
     * Initializes value for {@link TransactionConfigBase#profilingIntervalMillis() profilingIntervalMillis}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link TransactionConfigBase#profilingIntervalMillis() profilingIntervalMillis}.</em>
     * @param profilingIntervalMillis value for profilingIntervalMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
      checkNotIsSet(profilingIntervalMillisIsSet(), "profilingIntervalMillis");
      this.profilingIntervalMillis = profilingIntervalMillis;
      nondefaultBitset |= NONDEFAULT_BIT_PROFILING_INTERVAL_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionConfigBase#slowThresholdMillis() slowThresholdMillis}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link TransactionConfigBase#slowThresholdMillis() slowThresholdMillis}.</em>
     * @param slowThresholdMillis value for slowThresholdMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder slowThresholdMillis(int slowThresholdMillis) {
      checkNotIsSet(slowThresholdMillisIsSet(), "slowThresholdMillis");
      this.slowThresholdMillis = slowThresholdMillis;
      nondefaultBitset |= NONDEFAULT_BIT_SLOW_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionConfigBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link TransactionConfigBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.</em>
     * @param defaultDisplayedTransactionType value for defaultDisplayedTransactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultDisplayedTransactionType(String defaultDisplayedTransactionType) {
      checkNotIsSet(defaultDisplayedTransactionTypeIsSet(), "defaultDisplayedTransactionType");
      this.defaultDisplayedTransactionType = Preconditions.checkNotNull(defaultDisplayedTransactionType);
      nondefaultBitset |= NONDEFAULT_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionConfigBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link TransactionConfigBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.</em>
     * @param defaultDisplayedPercentiles value for defaultDisplayedPercentiles
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultDisplayedPercentiles(ImmutableList<Double> defaultDisplayedPercentiles) {
      checkNotIsSet(defaultDisplayedPercentilesIsSet(), "defaultDisplayedPercentiles");
      this.defaultDisplayedPercentiles = Preconditions.checkNotNull(defaultDisplayedPercentiles);
      nondefaultBitset |= NONDEFAULT_BIT_DEFAULT_DISPLAYED_PERCENTILES;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.TransactionConfig}.
     * @return immutable instance of TransactionConfig
     */
    public TransactionConfig build() {
      return new TransactionConfig(this);
    }
  
    private boolean profilingIntervalMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_PROFILING_INTERVAL_MILLIS) != 0;
    }
  
    private boolean slowThresholdMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_SLOW_THRESHOLD_MILLIS) != 0;
    }
  
    private boolean defaultDisplayedTransactionTypeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE) != 0;
    }
  
    private boolean defaultDisplayedPercentilesIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_DEFAULT_DISPLAYED_PERCENTILES) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of TransactionConfig is strict, attribute is already set: ".concat(name));
      }
    }
  }
}
