package org.glowroot.local.store;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ErrorMessageQueryBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ErrorMessageQuery.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ErrorMessageQueryBase"})
@Immutable
public final class ErrorMessageQuery extends ErrorMessageQueryBase {
  private final String transactionType;
  private final @Nullable String transactionName;
  private final long from;
  private final long to;
  private final ImmutableList<String> includes;
  private final ImmutableList<String> excludes;
  private final int limit;

  private ErrorMessageQuery(
      String transactionType,
      @Nullable String transactionName,
      long from,
      long to,
      ImmutableList<String> includes,
      ImmutableList<String> excludes,
      int limit) {
    this.transactionType = transactionType;
    this.transactionName = transactionName;
    this.from = from;
    this.to = to;
    this.includes = includes;
    this.excludes = excludes;
    this.limit = limit;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionName} attribute
   */
  @JsonProperty("transactionName")
  @Override
  public String transactionName() {
    return transactionName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public long from() {
    return from;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code to} attribute
   */
  @JsonProperty("to")
  @Override
  public long to() {
    return to;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code includes} attribute
   */
  @JsonProperty("includes")
  @Override
  public ImmutableList<String> includes() {
    return includes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code excludes} attribute
   */
  @JsonProperty("excludes")
  @Override
  public ImmutableList<String> excludes() {
    return excludes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code limit} attribute
   */
  @JsonProperty("limit")
  @Override
  public int limit() {
    return limit;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorMessageQueryBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageQuery withTransactionType(String value) {
    if (this.transactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ErrorMessageQuery(newValue, this.transactionName, this.from, this.to, this.includes, this.excludes, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorMessageQueryBase#transactionName() transactionName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageQuery withTransactionName(@Nullable String value) {
    if (this.transactionName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new ErrorMessageQuery(this.transactionType, newValue, this.from, this.to, this.includes, this.excludes, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorMessageQueryBase#from() from}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for from
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageQuery withFrom(long value) {
    if (this.from == value) {
      return this;
    }
    long newValue = value;
    return new ErrorMessageQuery(
        this.transactionType,
        this.transactionName,
        newValue,
        this.to,
        this.includes,
        this.excludes,
        this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorMessageQueryBase#to() to}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for to
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageQuery withTo(long value) {
    if (this.to == value) {
      return this;
    }
    long newValue = value;
    return new ErrorMessageQuery(
        this.transactionType,
        this.transactionName,
        this.from,
        newValue,
        this.includes,
        this.excludes,
        this.limit);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ErrorMessageQueryBase#includes() includes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ErrorMessageQuery withIncludes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, newValue, this.excludes, this.limit);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ErrorMessageQueryBase#includes() includes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of includes elements to set
   * @return modified copy of {@code this} object
   */
  public final ErrorMessageQuery withIncludes(Iterable<String> elements) {
    if (this.includes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, newValue, this.excludes, this.limit);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ErrorMessageQueryBase#excludes() excludes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ErrorMessageQuery withExcludes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, this.includes, newValue, this.limit);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ErrorMessageQueryBase#excludes() excludes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of excludes elements to set
   * @return modified copy of {@code this} object
   */
  public final ErrorMessageQuery withExcludes(Iterable<String> elements) {
    if (this.excludes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ErrorMessageQuery(this.transactionType, this.transactionName, this.from, this.to, this.includes, newValue, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorMessageQueryBase#limit() limit}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for limit
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessageQuery withLimit(int value) {
    if (this.limit == value) {
      return this;
    }
    int newValue = value;
    return new ErrorMessageQuery(
        this.transactionType,
        this.transactionName,
        this.from,
        this.to,
        this.includes,
        this.excludes,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ErrorMessageQuery} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ErrorMessageQuery && equalTo((ErrorMessageQuery) another));
  }
  
  private boolean equalTo(ErrorMessageQuery another) {
    return transactionType.equals(another.transactionType)
        && Objects.equal(transactionName, another.transactionName)
        && from == another.from
        && to == another.to
        && includes.equals(another.includes)
        && excludes.equals(another.excludes)
        && limit == another.limit;
  }
  
  /**
   * Computes hash code from attributes: {@code transactionType}, {@code transactionName}, {@code from}, {@code to}, {@code includes}, {@code excludes}, {@code limit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + Objects.hashCode(transactionName);
    h = h * 17 + Longs.hashCode(from);
    h = h * 17 + Longs.hashCode(to);
    h = h * 17 + includes.hashCode();
    h = h * 17 + excludes.hashCode();
    h = h * 17 + limit;
    return h;
  }
  
  /**
   * Prints immutable value {@code ErrorMessageQuery{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorMessageQuery")
        .add("transactionType", transactionType)
        .add("transactionName", transactionName)
        .add("from", from)
        .add("to", to)
        .add("includes", includes)
        .add("excludes", excludes)
        .add("limit", limit)
        .toString();
  }
  
  @JsonCreator
  public static ErrorMessageQuery fromAllAttributes(
      @JsonProperty("transactionType") @Nullable String transactionType,
      @JsonProperty("transactionName") @Nullable String transactionName,
      @JsonProperty("from") @Nullable Long from,
      @JsonProperty("to") @Nullable Long to,
      @JsonProperty("includes") @Nullable ImmutableList<String> includes,
      @JsonProperty("excludes") @Nullable ImmutableList<String> excludes,
      @JsonProperty("limit") @Nullable Integer limit) {
    ErrorMessageQuery.Builder builder = ErrorMessageQuery.builder();
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (transactionName != null) {
      builder.transactionName(transactionName);
    }
    if (from != null) {
      builder.from(from);
    }
    if (to != null) {
      builder.to(to);
    }
    if (includes != null) {
      builder.addAllIncludes(includes);
    }
    if (excludes != null) {
      builder.addAllExcludes(excludes);
    }
    if (limit != null) {
      builder.limit(limit);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ErrorMessageQueryBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ErrorMessageQuery instance
   */
  public static ErrorMessageQuery copyOf(ErrorMessageQueryBase instance) {
    if (instance instanceof ErrorMessageQuery) {
      return (ErrorMessageQuery) instance;
    }
    return ErrorMessageQuery.builder()
        .transactionType(instance.transactionType())
        .transactionName(instance.transactionName())
        .from(instance.from())
        .to(instance.to())
        .addAllIncludes(instance.includes())
        .addAllExcludes(instance.excludes())
        .limit(instance.limit())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.store.ErrorMessageQuery}.
   * @return new ErrorMessageQuery builder
   */
  public static ErrorMessageQuery.Builder builder() {
    return new ErrorMessageQuery.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.store.ErrorMessageQuery}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 0x1L;
    private static final long INITIALIZED_BIT_FROM = 0x2L;
    private static final long INITIALIZED_BIT_TO = 0x4L;
    private static final long INITIALIZED_BIT_LIMIT = 0x8L;
    private static final long NONDEFAULT_BIT_TRANSACTION_NAME = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String transactionType;
    private @Nullable String transactionName;
    private long from;
    private long to;
    private ImmutableList.Builder<String> includesBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> excludesBuilder = ImmutableList.builder();
    private int limit;
    private Builder() {}
  
    /**
     * Initializes value for {@link ErrorMessageQueryBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      checkNotIsSet(transactionTypeIsSet(), "transactionType");
      this.transactionType = Preconditions.checkNotNull(transactionType);
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorMessageQueryBase#transactionName() transactionName}.
     * @param transactionName value for transactionName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      checkNotIsSet(transactionNameIsSet(), "transactionName");
      this.transactionName = transactionName;
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorMessageQueryBase#from() from}.
     * @param from value for from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(long from) {
      checkNotIsSet(fromIsSet(), "from");
      this.from = from;
      initializedBitset |= INITIALIZED_BIT_FROM;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorMessageQueryBase#to() to}.
     * @param to value for to
     * @return {@code this} builder for chained invocation
     */
    public final Builder to(long to) {
      checkNotIsSet(toIsSet(), "to");
      this.to = to;
      initializedBitset |= INITIALIZED_BIT_TO;
      return this;
    }
  
    /**
     * Adds one element to {@link ErrorMessageQueryBase#includes() includes} list.
     * @param element includes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addIncludes(String element) {
      includesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ErrorMessageQueryBase#includes() includes} list.
     * @param elements array of includes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addIncludes(String... elements) {
      includesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link ErrorMessageQueryBase#includes() includes} list.
     * @param elements iterable of includes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllIncludes(Iterable<String> elements) {
      includesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link ErrorMessageQueryBase#excludes() excludes} list.
     * @param element excludes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExcludes(String element) {
      excludesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ErrorMessageQueryBase#excludes() excludes} list.
     * @param elements array of excludes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExcludes(String... elements) {
      excludesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link ErrorMessageQueryBase#excludes() excludes} list.
     * @param elements iterable of excludes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllExcludes(Iterable<String> elements) {
      excludesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorMessageQueryBase#limit() limit}.
     * @param limit value for limit
     * @return {@code this} builder for chained invocation
     */
    public final Builder limit(int limit) {
      checkNotIsSet(limitIsSet(), "limit");
      this.limit = limit;
      initializedBitset |= INITIALIZED_BIT_LIMIT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.store.ErrorMessageQuery}.
     * @return immutable instance of ErrorMessageQuery
     */
    public ErrorMessageQuery build() {
      checkRequiredAttributes();
      return new ErrorMessageQuery(transactionType, transactionName, from, to, includesBuilder.build(), excludesBuilder.build(), limit);
    }
  
    private boolean transactionNameIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_NAME) != 0;
    }
  
    private boolean transactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean fromIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM) != 0;
    }
  
    private boolean toIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TO) != 0;
    }
  
    private boolean limitIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LIMIT) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ErrorMessageQuery is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!transactionTypeIsSet()) {
        attributes.add("transactionType");
      }
      if (!fromIsSet()) {
        attributes.add("from");
      }
      if (!toIsSet()) {
        attributes.add("to");
      }
      if (!limitIsSet()) {
        attributes.add("limit");
      }
      return "Cannot build ErrorMessageQuery, some of required attributes are not set " + attributes;
    }
  }
}
