package org.glowroot.local.store;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GaugeMetaDao.GaugeMetaBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GaugeMeta.builder()}.
 * Use static factory method to create immutable instances:
 * {@code GaugeMeta.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugeMetaDao.GaugeMetaBase"})
@Immutable
final class GaugeMeta extends GaugeMetaDao.GaugeMetaBase {
  private final long id;
  private final boolean everIncreasing;

  private GaugeMeta(long id, boolean everIncreasing) {
    this.id = id;
    this.everIncreasing = everIncreasing;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public long id() {
    return id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code everIncreasing} attribute
   */
  @JsonProperty("everIncreasing")
  @Override
  public boolean everIncreasing() {
    return everIncreasing;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeMetaDao.GaugeMetaBase#id() id}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final GaugeMeta withId(long value) {
    if (this.id == value) {
      return this;
    }
    long newValue = value;
    return new GaugeMeta(newValue, this.everIncreasing);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeMetaDao.GaugeMetaBase#everIncreasing() everIncreasing}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for everIncreasing
   * @return modified copy of the {@code this} object
   */
  public final GaugeMeta withEverIncreasing(boolean value) {
    if (this.everIncreasing == value) {
      return this;
    }
    boolean newValue = value;
    return new GaugeMeta(this.id, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GaugeMeta} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GaugeMeta && equalTo((GaugeMeta) another));
  }
  
  private boolean equalTo(GaugeMeta another) {
    return id == another.id
        && everIncreasing == another.everIncreasing;
  }
  
  /**
   * Computes hash code from attributes: {@code id}, {@code everIncreasing}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(id);
    h = h * 17 + Booleans.hashCode(everIncreasing);
    return h;
  }
  
  /**
   * Prints immutable value {@code GaugeMeta{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GaugeMeta")
        .add("id", id)
        .add("everIncreasing", everIncreasing)
        .toString();
  }
  
  @JsonCreator
  public static GaugeMeta fromAllAttributes(
      @JsonProperty("id") @Nullable Long id,
      @JsonProperty("everIncreasing") @Nullable Boolean everIncreasing) {
    GaugeMeta.Builder builder = GaugeMeta.builder();
    if (id != null) {
      builder.id(id);
    }
    if (everIncreasing != null) {
      builder.everIncreasing(everIncreasing);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code GaugeMeta} instance.
   * @param id value for {@code id}
   * @param everIncreasing value for {@code everIncreasing}
   * @return immutable GaugeMeta instance
   */
  public static org.glowroot.local.store.GaugeMeta of(long id, boolean everIncreasing) {
    return new GaugeMeta(id, everIncreasing);
  }
  
  /**
   * Creates immutable copy of {@link GaugeMetaDao.GaugeMetaBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable GaugeMeta instance
   */
  static GaugeMeta copyOf(GaugeMetaDao.GaugeMetaBase instance) {
    if (instance instanceof GaugeMeta) {
      return (GaugeMeta) instance;
    }
    return GaugeMeta.builder()
        .id(instance.id())
        .everIncreasing(instance.everIncreasing())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.store.GaugeMeta}.
   * @return new GaugeMeta builder
   */
  static GaugeMeta.Builder builder() {
    return new GaugeMeta.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.store.GaugeMeta}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_ID = 0x1L;
    private static final long INITIALIZED_BIT_EVER_INCREASING = 0x2L;
    private long initializedBitset;
  
    private long id;
    private boolean everIncreasing;
    private Builder() {}
  
    /**
     * Initializes value for {@link GaugeMetaDao.GaugeMetaBase#id() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(long id) {
      checkNotIsSet(idIsSet(), "id");
      this.id = id;
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeMetaDao.GaugeMetaBase#everIncreasing() everIncreasing}.
     * @param everIncreasing value for everIncreasing
     * @return {@code this} builder for chained invocation
     */
    public final Builder everIncreasing(boolean everIncreasing) {
      checkNotIsSet(everIncreasingIsSet(), "everIncreasing");
      this.everIncreasing = everIncreasing;
      initializedBitset |= INITIALIZED_BIT_EVER_INCREASING;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.store.GaugeMeta}.
     * @return immutable instance of GaugeMeta
     */
    public org.glowroot.local.store.GaugeMeta build() {
      checkRequiredAttributes();
      return new GaugeMeta(id, everIncreasing);
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private boolean everIncreasingIsSet() {
      return (initializedBitset & INITIALIZED_BIT_EVER_INCREASING) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of GaugeMeta is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!idIsSet()) {
        attributes.add("id");
      }
      if (!everIncreasingIsSet()) {
        attributes.add("everIncreasing");
      }
      return "Cannot build GaugeMeta, some of required attributes are not set " + attributes;
    }
  }
}
