package org.glowroot.local.store;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.tainting.qual.Untainted;

/**
 * Immutable implementation of {@link Schemas.IndexBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code Index.builder()}.
 * Use static factory method to create immutable instances:
 * {@code Index.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Schemas.IndexBase"})
@Immutable
final class Index extends Schemas.IndexBase {
  private final String name;
  private final ImmutableList<String> columns;

  private Index(String name, Iterable<String> columns) {
    this.name = Preconditions.checkNotNull(name);
    this.columns = ImmutableList.copyOf(columns);
  }

  private Index(
      Index original,
      String name,
      ImmutableList<String> columns) {
    this.name = name;
    this.columns = columns;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @Untainted
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code columns} attribute
   */
  @JsonProperty("columns")
  @Override
  public ImmutableList<String> columns() {
    return columns;
  }
  
  /**
   * Copy current immutable object by setting value for {@link Schemas.IndexBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final Index withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Index(this, newValue, this.columns);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Schemas.IndexBase#columns() columns}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Index withColumns(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Index(this, this.name, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link Schemas.IndexBase#columns() columns}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of columns elements to set
   * @return modified copy of {@code this} object
   */
  public final Index withColumns(Iterable<String> elements) {
    if (this.columns == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Index(this, this.name, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code Index} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof Index && equalTo((Index) another));
  }
  
  private boolean equalTo(Index another) {
    return name.equals(another.name)
        && columns.equals(another.columns);
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code columns}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + columns.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Index{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Index")
        .add("name", name)
        .add("columns", columns)
        .toString();
  }
  
  @JsonCreator
  public static Index fromAllAttributes(
      @Untainted
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("columns") @Nullable ImmutableList<String> columns) {
    Index.Builder builder = Index.builder();
    if (name != null) {
      builder.name(name);
    }
    if (columns != null) {
      builder.addAllColumns(columns);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code Index} instance.
   * @param name value for {@code name}
   * @param columns value for {@code columns}
   * @return immutable Index instance
   */
  public static org.glowroot.local.store.Index of(String name, ImmutableList<String> columns) {
    return of(name, (Iterable<String>) columns);
  }

  /**
   * Construct new immutable {@code Index} instance.
   * @param name value for {@code name}
   * @param columns value for {@code columns}
   * @return immutable Index instance
   */
  public static org.glowroot.local.store.Index of(String name, Iterable<String> columns) {
    return new Index(name, columns);
  }
  
  /**
   * Creates immutable copy of {@link Schemas.IndexBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Index instance
   */
  static Index copyOf(Schemas.IndexBase instance) {
    if (instance instanceof Index) {
      return (Index) instance;
    }
    return Index.builder()
        .name(instance.name())
        .addAllColumns(instance.columns())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.store.Index}.
   * @return new Index builder
   */
  static Index.Builder builder() {
    return new Index.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.store.Index}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private long initializedBitset;
  
    private @Nullable String name;
    private ImmutableList.Builder<String> columnsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link Schemas.IndexBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link Schemas.IndexBase#columns() columns} list.
     * @param element columns element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addColumns(String element) {
      columnsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link Schemas.IndexBase#columns() columns} list.
     * @param elements array of columns elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addColumns(String... elements) {
      columnsBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link Schemas.IndexBase#columns() columns} list.
     * @param elements iterable of columns elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllColumns(Iterable<String> elements) {
      columnsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.store.Index}.
     * @return immutable instance of Index
     */
    public org.glowroot.local.store.Index build() {
      checkRequiredAttributes();
      return new Index(null, name, columnsBuilder.build());
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of Index is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      return "Cannot build Index, some of required attributes are not set " + attributes;
    }
  }
}
