package org.glowroot.local.store;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TraceErrorPointBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TraceErrorPoint.builder()}.
 * Use static factory method to create immutable instances:
 * {@code TraceErrorPoint.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TraceErrorPointBase"})
@Immutable
public final class TraceErrorPoint extends TraceErrorPointBase {
  private final long captureTime;
  private final long errorCount;

  private TraceErrorPoint(long captureTime, long errorCount) {
    this.captureTime = captureTime;
    this.errorCount = errorCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureTime} attribute
   */
  @JsonProperty("captureTime")
  @Override
  public long captureTime() {
    return captureTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code errorCount} attribute
   */
  @JsonProperty("errorCount")
  @Override
  public long errorCount() {
    return errorCount;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TraceErrorPointBase#captureTime() captureTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureTime
   * @return modified copy of the {@code this} object
   */
  public final TraceErrorPoint withCaptureTime(long value) {
    if (this.captureTime == value) {
      return this;
    }
    long newValue = value;
    return new TraceErrorPoint(newValue, this.errorCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TraceErrorPointBase#errorCount() errorCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for errorCount
   * @return modified copy of the {@code this} object
   */
  public final TraceErrorPoint withErrorCount(long value) {
    if (this.errorCount == value) {
      return this;
    }
    long newValue = value;
    return new TraceErrorPoint(this.captureTime, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TraceErrorPoint} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TraceErrorPoint && equalTo((TraceErrorPoint) another));
  }
  
  private boolean equalTo(TraceErrorPoint another) {
    return captureTime == another.captureTime
        && errorCount == another.errorCount;
  }
  
  /**
   * Computes hash code from attributes: {@code captureTime}, {@code errorCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(captureTime);
    h = h * 17 + Longs.hashCode(errorCount);
    return h;
  }
  
  /**
   * Prints immutable value {@code TraceErrorPoint{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TraceErrorPoint")
        .add("captureTime", captureTime)
        .add("errorCount", errorCount)
        .toString();
  }
  
  @JsonCreator
  public static TraceErrorPoint fromAllAttributes(
      @JsonProperty("captureTime") @Nullable Long captureTime,
      @JsonProperty("errorCount") @Nullable Long errorCount) {
    TraceErrorPoint.Builder builder = TraceErrorPoint.builder();
    if (captureTime != null) {
      builder.captureTime(captureTime);
    }
    if (errorCount != null) {
      builder.errorCount(errorCount);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code TraceErrorPoint} instance.
   * @param captureTime value for {@code captureTime}
   * @param errorCount value for {@code errorCount}
   * @return immutable TraceErrorPoint instance
   */
  public static org.glowroot.local.store.TraceErrorPoint of(long captureTime, long errorCount) {
    return new TraceErrorPoint(captureTime, errorCount);
  }
  
  /**
   * Creates immutable copy of {@link TraceErrorPointBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable TraceErrorPoint instance
   */
  public static TraceErrorPoint copyOf(TraceErrorPointBase instance) {
    if (instance instanceof TraceErrorPoint) {
      return (TraceErrorPoint) instance;
    }
    return TraceErrorPoint.builder()
        .captureTime(instance.captureTime())
        .errorCount(instance.errorCount())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.store.TraceErrorPoint}.
   * @return new TraceErrorPoint builder
   */
  public static TraceErrorPoint.Builder builder() {
    return new TraceErrorPoint.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.store.TraceErrorPoint}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_CAPTURE_TIME = 0x1L;
    private static final long INITIALIZED_BIT_ERROR_COUNT = 0x2L;
    private long initializedBitset;
  
    private long captureTime;
    private long errorCount;
    private Builder() {}
  
    /**
     * Initializes value for {@link TraceErrorPointBase#captureTime() captureTime}.
     * @param captureTime value for captureTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureTime(long captureTime) {
      checkNotIsSet(captureTimeIsSet(), "captureTime");
      this.captureTime = captureTime;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link TraceErrorPointBase#errorCount() errorCount}.
     * @param errorCount value for errorCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder errorCount(long errorCount) {
      checkNotIsSet(errorCountIsSet(), "errorCount");
      this.errorCount = errorCount;
      initializedBitset |= INITIALIZED_BIT_ERROR_COUNT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.store.TraceErrorPoint}.
     * @return immutable instance of TraceErrorPoint
     */
    public TraceErrorPoint build() {
      checkRequiredAttributes();
      return new TraceErrorPoint(captureTime, errorCount);
    }
  
    private boolean captureTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_TIME) != 0;
    }
  
    private boolean errorCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ERROR_COUNT) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of TraceErrorPoint is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!captureTimeIsSet()) {
        attributes.add("captureTime");
      }
      if (!errorCountIsSet()) {
        attributes.add("errorCount");
      }
      return "Cannot build TraceErrorPoint, some of required attributes are not set " + attributes;
    }
  }
}
