package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TransactionJsonService.FlameGraphRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code FlameGraphRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TransactionJsonService.FlameGraphRequestBase"})
@Immutable
final class FlameGraphRequest
    extends TransactionJsonService.FlameGraphRequestBase {
  private final long from;
  private final long to;
  private final String transactionType;
  private final @Nullable String transactionName;
  private final ImmutableList<String> include;
  private final ImmutableList<String> exclude;
  private final double truncateLeafPercentage;

  private FlameGraphRequest(
      long from,
      long to,
      String transactionType,
      @Nullable String transactionName,
      ImmutableList<String> include,
      ImmutableList<String> exclude,
      double truncateLeafPercentage) {
    this.from = from;
    this.to = to;
    this.transactionType = transactionType;
    this.transactionName = transactionName;
    this.include = include;
    this.exclude = exclude;
    this.truncateLeafPercentage = truncateLeafPercentage;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public long from() {
    return from;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code to} attribute
   */
  @JsonProperty("to")
  @Override
  public long to() {
    return to;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionName} attribute
   */
  @JsonProperty("transactionName")
  @Override
  public String transactionName() {
    return transactionName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code include} attribute
   */
  @JsonProperty("include")
  @Override
  public ImmutableList<String> include() {
    return include;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code exclude} attribute
   */
  @JsonProperty("exclude")
  @Override
  public ImmutableList<String> exclude() {
    return exclude;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code truncateLeafPercentage} attribute
   */
  @JsonProperty("truncateLeafPercentage")
  @Override
  public double truncateLeafPercentage() {
    return truncateLeafPercentage;
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.FlameGraphRequestBase#from() from}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for from
   * @return modified copy of the {@code this} object
   */
  public final FlameGraphRequest withFrom(long value) {
    if (this.from == value) {
      return this;
    }
    long newValue = value;
    return new FlameGraphRequest(
        newValue,
        this.to,
        this.transactionType,
        this.transactionName,
        this.include,
        this.exclude,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.FlameGraphRequestBase#to() to}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for to
   * @return modified copy of the {@code this} object
   */
  public final FlameGraphRequest withTo(long value) {
    if (this.to == value) {
      return this;
    }
    long newValue = value;
    return new FlameGraphRequest(
        this.from,
        newValue,
        this.transactionType,
        this.transactionName,
        this.include,
        this.exclude,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.FlameGraphRequestBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType
   * @return modified copy of the {@code this} object
   */
  public final FlameGraphRequest withTransactionType(String value) {
    if (this.transactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new FlameGraphRequest(
        this.from,
        this.to,
        newValue,
        this.transactionName,
        this.include,
        this.exclude,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.FlameGraphRequestBase#transactionName() transactionName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final FlameGraphRequest withTransactionName(@Nullable String value) {
    if (this.transactionName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new FlameGraphRequest(
        this.from,
        this.to,
        this.transactionType,
        newValue,
        this.include,
        this.exclude,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link TransactionJsonService.FlameGraphRequestBase#include() include}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final FlameGraphRequest withInclude(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new FlameGraphRequest(
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        newValue,
        this.exclude,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link TransactionJsonService.FlameGraphRequestBase#include() include}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of include elements to set
   * @return modified copy of {@code this} object
   */
  public final FlameGraphRequest withInclude(Iterable<String> elements) {
    if (this.include == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new FlameGraphRequest(
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        newValue,
        this.exclude,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link TransactionJsonService.FlameGraphRequestBase#exclude() exclude}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final FlameGraphRequest withExclude(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new FlameGraphRequest(
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        this.include,
        newValue,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link TransactionJsonService.FlameGraphRequestBase#exclude() exclude}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of exclude elements to set
   * @return modified copy of {@code this} object
   */
  public final FlameGraphRequest withExclude(Iterable<String> elements) {
    if (this.exclude == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new FlameGraphRequest(
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        this.include,
        newValue,
        this.truncateLeafPercentage);
  }
  
  /**
   * Copy current immutable object by setting value for {@link TransactionJsonService.FlameGraphRequestBase#truncateLeafPercentage() truncateLeafPercentage}.
   * @param value new value for truncateLeafPercentage
   * @return modified copy of the {@code this} object
   */
  public final FlameGraphRequest withTruncateLeafPercentage(double value) {
    double newValue = value;
    return new FlameGraphRequest(
        this.from,
        this.to,
        this.transactionType,
        this.transactionName,
        this.include,
        this.exclude,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code FlameGraphRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof FlameGraphRequest && equalTo((FlameGraphRequest) another));
  }
  
  private boolean equalTo(FlameGraphRequest another) {
    return from == another.from
        && to == another.to
        && transactionType.equals(another.transactionType)
        && Objects.equal(transactionName, another.transactionName)
        && include.equals(another.include)
        && exclude.equals(another.exclude)
        && Double.doubleToLongBits(truncateLeafPercentage) == Double.doubleToLongBits(another.truncateLeafPercentage);
  }
  
  /**
   * Computes hash code from attributes: {@code from}, {@code to}, {@code transactionType}, {@code transactionName}, {@code include}, {@code exclude}, {@code truncateLeafPercentage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(from);
    h = h * 17 + Longs.hashCode(to);
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + Objects.hashCode(transactionName);
    h = h * 17 + include.hashCode();
    h = h * 17 + exclude.hashCode();
    h = h * 17 + Doubles.hashCode(truncateLeafPercentage);
    return h;
  }
  
  /**
   * Prints immutable value {@code FlameGraphRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FlameGraphRequest")
        .add("from", from)
        .add("to", to)
        .add("transactionType", transactionType)
        .add("transactionName", transactionName)
        .add("include", include)
        .add("exclude", exclude)
        .add("truncateLeafPercentage", truncateLeafPercentage)
        .toString();
  }
  
  @JsonCreator
  public static FlameGraphRequest fromAllAttributes(
      @JsonProperty("from") @Nullable Long from,
      @JsonProperty("to") @Nullable Long to,
      @JsonProperty("transactionType") @Nullable String transactionType,
      @JsonProperty("transactionName") @Nullable String transactionName,
      @JsonProperty("include") @Nullable ImmutableList<String> include,
      @JsonProperty("exclude") @Nullable ImmutableList<String> exclude,
      @JsonProperty("truncateLeafPercentage") @Nullable java.lang.Double truncateLeafPercentage) {
    FlameGraphRequest.Builder builder = FlameGraphRequest.builder();
    if (from != null) {
      builder.from(from);
    }
    if (to != null) {
      builder.to(to);
    }
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (transactionName != null) {
      builder.transactionName(transactionName);
    }
    if (include != null) {
      builder.addAllInclude(include);
    }
    if (exclude != null) {
      builder.addAllExclude(exclude);
    }
    if (truncateLeafPercentage != null) {
      builder.truncateLeafPercentage(truncateLeafPercentage);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link TransactionJsonService.FlameGraphRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable FlameGraphRequest instance
   */
  static FlameGraphRequest copyOf(TransactionJsonService.FlameGraphRequestBase instance) {
    if (instance instanceof FlameGraphRequest) {
      return (FlameGraphRequest) instance;
    }
    return FlameGraphRequest.builder()
        .from(instance.from())
        .to(instance.to())
        .transactionType(instance.transactionType())
        .transactionName(instance.transactionName())
        .addAllInclude(instance.include())
        .addAllExclude(instance.exclude())
        .truncateLeafPercentage(instance.truncateLeafPercentage())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.FlameGraphRequest}.
   * @return new FlameGraphRequest builder
   */
  static FlameGraphRequest.Builder builder() {
    return new FlameGraphRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.FlameGraphRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_FROM = 0x1L;
    private static final long INITIALIZED_BIT_TO = 0x2L;
    private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 0x4L;
    private static final long INITIALIZED_BIT_TRUNCATE_LEAF_PERCENTAGE = 0x8L;
    private static final long NONDEFAULT_BIT_TRANSACTION_NAME = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private long from;
    private long to;
    private @Nullable String transactionType;
    private @Nullable String transactionName;
    private ImmutableList.Builder<String> includeBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> excludeBuilder = ImmutableList.builder();
    private double truncateLeafPercentage;
    private Builder() {}
  
    /**
     * Initializes value for {@link TransactionJsonService.FlameGraphRequestBase#from() from}.
     * @param from value for from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(long from) {
      checkNotIsSet(fromIsSet(), "from");
      this.from = from;
      initializedBitset |= INITIALIZED_BIT_FROM;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.FlameGraphRequestBase#to() to}.
     * @param to value for to
     * @return {@code this} builder for chained invocation
     */
    public final Builder to(long to) {
      checkNotIsSet(toIsSet(), "to");
      this.to = to;
      initializedBitset |= INITIALIZED_BIT_TO;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.FlameGraphRequestBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      checkNotIsSet(transactionTypeIsSet(), "transactionType");
      this.transactionType = Preconditions.checkNotNull(transactionType);
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.FlameGraphRequestBase#transactionName() transactionName}.
     * @param transactionName value for transactionName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      checkNotIsSet(transactionNameIsSet(), "transactionName");
      this.transactionName = transactionName;
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link TransactionJsonService.FlameGraphRequestBase#include() include} list.
     * @param element include element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInclude(String element) {
      includeBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link TransactionJsonService.FlameGraphRequestBase#include() include} list.
     * @param elements array of include elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInclude(String... elements) {
      includeBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link TransactionJsonService.FlameGraphRequestBase#include() include} list.
     * @param elements iterable of include elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllInclude(Iterable<String> elements) {
      includeBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link TransactionJsonService.FlameGraphRequestBase#exclude() exclude} list.
     * @param element exclude element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExclude(String element) {
      excludeBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link TransactionJsonService.FlameGraphRequestBase#exclude() exclude} list.
     * @param elements array of exclude elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExclude(String... elements) {
      excludeBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link TransactionJsonService.FlameGraphRequestBase#exclude() exclude} list.
     * @param elements iterable of exclude elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllExclude(Iterable<String> elements) {
      excludeBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link TransactionJsonService.FlameGraphRequestBase#truncateLeafPercentage() truncateLeafPercentage}.
     * @param truncateLeafPercentage value for truncateLeafPercentage
     * @return {@code this} builder for chained invocation
     */
    public final Builder truncateLeafPercentage(double truncateLeafPercentage) {
      checkNotIsSet(truncateLeafPercentageIsSet(), "truncateLeafPercentage");
      this.truncateLeafPercentage = truncateLeafPercentage;
      initializedBitset |= INITIALIZED_BIT_TRUNCATE_LEAF_PERCENTAGE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.FlameGraphRequest}.
     * @return immutable instance of FlameGraphRequest
     */
    public org.glowroot.local.ui.FlameGraphRequest build() {
      checkRequiredAttributes();
      return new FlameGraphRequest(
        from,
        to,
        transactionType,
        transactionName,
        includeBuilder.build(),
        excludeBuilder.build(),
        truncateLeafPercentage);
    }
  
    private boolean transactionNameIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_NAME) != 0;
    }
  
    private boolean fromIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM) != 0;
    }
  
    private boolean toIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TO) != 0;
    }
  
    private boolean transactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean truncateLeafPercentageIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRUNCATE_LEAF_PERCENTAGE) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of FlameGraphRequest is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!fromIsSet()) {
        attributes.add("from");
      }
      if (!toIsSet()) {
        attributes.add("to");
      }
      if (!transactionTypeIsSet()) {
        attributes.add("transactionType");
      }
      if (!truncateLeafPercentageIsSet()) {
        attributes.add("truncateLeafPercentage");
      }
      return "Cannot build FlameGraphRequest, some of required attributes are not set " + attributes;
    }
  }
}
