package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link JvmJsonService.GaugeBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code Gauge.builder()}.
 * Use static factory method to create immutable instances:
 * {@code Gauge.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "JvmJsonService.GaugeBase"})
@Immutable
final class Gauge extends JvmJsonService.GaugeBase {
  private final String name;
  private final boolean everIncreasing;
  private final String display;

  private Gauge(String name, boolean everIncreasing, String display) {
    this.name = name;
    this.everIncreasing = everIncreasing;
    this.display = display;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code everIncreasing} attribute
   */
  @JsonProperty("everIncreasing")
  @Override
  public boolean everIncreasing() {
    return everIncreasing;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code display} attribute
   */
  @JsonProperty("display")
  @Override
  public String display() {
    return display;
  }
  
  /**
   * Copy current immutable object by setting value for {@link JvmJsonService.GaugeBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final Gauge withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Gauge(newValue, this.everIncreasing, this.display);
  }
  
  /**
   * Copy current immutable object by setting value for {@link JvmJsonService.GaugeBase#everIncreasing() everIncreasing}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for everIncreasing
   * @return modified copy of the {@code this} object
   */
  public final Gauge withEverIncreasing(boolean value) {
    if (this.everIncreasing == value) {
      return this;
    }
    boolean newValue = value;
    return new Gauge(this.name, newValue, this.display);
  }
  
  /**
   * Copy current immutable object by setting value for {@link JvmJsonService.GaugeBase#display() display}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for display
   * @return modified copy of the {@code this} object
   */
  public final Gauge withDisplay(String value) {
    if (this.display == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Gauge(this.name, this.everIncreasing, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code Gauge} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof Gauge && equalTo((Gauge) another));
  }
  
  private boolean equalTo(Gauge another) {
    return name.equals(another.name)
        && everIncreasing == another.everIncreasing
        && display.equals(another.display);
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code everIncreasing}, {@code display}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Booleans.hashCode(everIncreasing);
    h = h * 17 + display.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Gauge{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Gauge")
        .add("name", name)
        .add("everIncreasing", everIncreasing)
        .add("display", display)
        .toString();
  }
  
  @JsonCreator
  public static Gauge fromAllAttributes(
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("everIncreasing") @Nullable Boolean everIncreasing,
      @JsonProperty("display") @Nullable String display) {
    Gauge.Builder builder = Gauge.builder();
    if (name != null) {
      builder.name(name);
    }
    if (everIncreasing != null) {
      builder.everIncreasing(everIncreasing);
    }
    if (display != null) {
      builder.display(display);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code Gauge} instance.
   * @param name value for {@code name}
   * @param everIncreasing value for {@code everIncreasing}
   * @param display value for {@code display}
   * @return immutable Gauge instance
   */
  public static org.glowroot.local.ui.Gauge of(String name, boolean everIncreasing, String display) {
    return new Gauge(name, everIncreasing, display);
  }
  
  /**
   * Creates immutable copy of {@link JvmJsonService.GaugeBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Gauge instance
   */
  static Gauge copyOf(JvmJsonService.GaugeBase instance) {
    if (instance instanceof Gauge) {
      return (Gauge) instance;
    }
    return Gauge.builder()
        .name(instance.name())
        .everIncreasing(instance.everIncreasing())
        .display(instance.display())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.Gauge}.
   * @return new Gauge builder
   */
  static Gauge.Builder builder() {
    return new Gauge.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.Gauge}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_EVER_INCREASING = 0x2L;
    private static final long INITIALIZED_BIT_DISPLAY = 0x4L;
    private long initializedBitset;
  
    private @Nullable String name;
    private boolean everIncreasing;
    private @Nullable String display;
    private Builder() {}
  
    /**
     * Initializes value for {@link JvmJsonService.GaugeBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link JvmJsonService.GaugeBase#everIncreasing() everIncreasing}.
     * @param everIncreasing value for everIncreasing
     * @return {@code this} builder for chained invocation
     */
    public final Builder everIncreasing(boolean everIncreasing) {
      checkNotIsSet(everIncreasingIsSet(), "everIncreasing");
      this.everIncreasing = everIncreasing;
      initializedBitset |= INITIALIZED_BIT_EVER_INCREASING;
      return this;
    }
  
    /**
     * Initializes value for {@link JvmJsonService.GaugeBase#display() display}.
     * @param display value for display
     * @return {@code this} builder for chained invocation
     */
    public final Builder display(String display) {
      checkNotIsSet(displayIsSet(), "display");
      this.display = Preconditions.checkNotNull(display);
      initializedBitset |= INITIALIZED_BIT_DISPLAY;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.Gauge}.
     * @return immutable instance of Gauge
     */
    public org.glowroot.local.ui.Gauge build() {
      checkRequiredAttributes();
      return new Gauge(name, everIncreasing, display);
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean everIncreasingIsSet() {
      return (initializedBitset & INITIALIZED_BIT_EVER_INCREASING) != 0;
    }
  
    private boolean displayIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DISPLAY) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of Gauge is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!everIncreasingIsSet()) {
        attributes.add("everIncreasing");
      }
      if (!displayIsSet()) {
        attributes.add("display");
      }
      return "Cannot build Gauge, some of required attributes are not set " + attributes;
    }
  }
}
