package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Optional;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.CaptureKind;
import org.glowroot.plugin.api.weaving.MethodModifier;

/**
 * Immutable implementation of {@link InstrumentationJsonService.InstrumentationConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code InstrumentationConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.InstrumentationConfigDtoBase"})
@Immutable
final class InstrumentationConfigDto
    extends InstrumentationJsonService.InstrumentationConfigDtoBase {
  private final String className;
  private final Optional<String> declaringClassName;
  private final String methodName;
  private final ImmutableList<String> methodParameterTypes;
  private final Optional<String> methodReturnType;
  private final ImmutableList<MethodModifier> methodModifiers;
  private final CaptureKind captureKind;
  private final Optional<String> timerName;
  private final Optional<String> traceEntryTemplate;
  private final @Nullable Long traceEntryStackThresholdMillis;
  private final Optional<Boolean> traceEntryCaptureSelfNested;
  private final Optional<String> transactionType;
  private final Optional<String> transactionNameTemplate;
  private final Optional<String> transactionUserTemplate;
  private final ImmutableMap<String, String> transactionCustomAttributeTemplates;
  private final @Nullable Long transactionSlowThresholdMillis;
  private final Optional<String> enabledProperty;
  private final Optional<String> traceEntryEnabledProperty;
  private final @Nullable String version;

  private InstrumentationConfigDto(
      String className,
      Optional<String> declaringClassName,
      String methodName,
      ImmutableList<String> methodParameterTypes,
      Optional<String> methodReturnType,
      ImmutableList<MethodModifier> methodModifiers,
      CaptureKind captureKind,
      Optional<String> timerName,
      Optional<String> traceEntryTemplate,
      @Nullable Long traceEntryStackThresholdMillis,
      Optional<Boolean> traceEntryCaptureSelfNested,
      Optional<String> transactionType,
      Optional<String> transactionNameTemplate,
      Optional<String> transactionUserTemplate,
      ImmutableMap<String, String> transactionCustomAttributeTemplates,
      @Nullable Long transactionSlowThresholdMillis,
      Optional<String> enabledProperty,
      Optional<String> traceEntryEnabledProperty,
      @Nullable String version) {
    this.className = className;
    this.declaringClassName = declaringClassName;
    this.methodName = methodName;
    this.methodParameterTypes = methodParameterTypes;
    this.methodReturnType = methodReturnType;
    this.methodModifiers = methodModifiers;
    this.captureKind = captureKind;
    this.timerName = timerName;
    this.traceEntryTemplate = traceEntryTemplate;
    this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
    this.traceEntryCaptureSelfNested = traceEntryCaptureSelfNested;
    this.transactionType = transactionType;
    this.transactionNameTemplate = transactionNameTemplate;
    this.transactionUserTemplate = transactionUserTemplate;
    this.transactionCustomAttributeTemplates = transactionCustomAttributeTemplates;
    this.transactionSlowThresholdMillis = transactionSlowThresholdMillis;
    this.enabledProperty = enabledProperty;
    this.traceEntryEnabledProperty = traceEntryEnabledProperty;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code className} attribute
   */
  @JsonProperty("className")
  @Override
  public String className() {
    return className;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code declaringClassName} attribute
   */
  @JsonProperty("declaringClassName")
  @Override
  public Optional<String> declaringClassName() {
    return declaringClassName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodName} attribute
   */
  @JsonProperty("methodName")
  @Override
  public String methodName() {
    return methodName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodParameterTypes} attribute
   */
  @JsonProperty("methodParameterTypes")
  @Override
  public ImmutableList<String> methodParameterTypes() {
    return methodParameterTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodReturnType} attribute
   */
  @JsonProperty("methodReturnType")
  @Override
  public Optional<String> methodReturnType() {
    return methodReturnType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodModifiers} attribute
   */
  @JsonProperty("methodModifiers")
  @Override
  public ImmutableList<MethodModifier> methodModifiers() {
    return methodModifiers;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureKind} attribute
   */
  @JsonProperty("captureKind")
  @Override
  public CaptureKind captureKind() {
    return captureKind;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code timerName} attribute
   */
  @JsonProperty("timerName")
  @Override
  public Optional<String> timerName() {
    return timerName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryTemplate} attribute
   */
  @JsonProperty("traceEntryTemplate")
  @Override
  public Optional<String> traceEntryTemplate() {
    return traceEntryTemplate;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryStackThresholdMillis} attribute
   */
  @JsonProperty("traceEntryStackThresholdMillis")
  @Override
  public Long traceEntryStackThresholdMillis() {
    return traceEntryStackThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryCaptureSelfNested} attribute
   */
  @JsonProperty("traceEntryCaptureSelfNested")
  @Override
  public Optional<Boolean> traceEntryCaptureSelfNested() {
    return traceEntryCaptureSelfNested;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public Optional<String> transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionNameTemplate} attribute
   */
  @JsonProperty("transactionNameTemplate")
  @Override
  public Optional<String> transactionNameTemplate() {
    return transactionNameTemplate;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionUserTemplate} attribute
   */
  @JsonProperty("transactionUserTemplate")
  @Override
  public Optional<String> transactionUserTemplate() {
    return transactionUserTemplate;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCustomAttributeTemplates} attribute
   */
  @JsonProperty("transactionCustomAttributeTemplates")
  @Override
  public ImmutableMap<String, String> transactionCustomAttributeTemplates() {
    return transactionCustomAttributeTemplates;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionSlowThresholdMillis} attribute
   */
  @JsonProperty("transactionSlowThresholdMillis")
  @Override
  public Long transactionSlowThresholdMillis() {
    return transactionSlowThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabledProperty} attribute
   */
  @JsonProperty("enabledProperty")
  @Override
  public Optional<String> enabledProperty() {
    return enabledProperty;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceEntryEnabledProperty} attribute
   */
  @JsonProperty("traceEntryEnabledProperty")
  @Override
  public Optional<String> traceEntryEnabledProperty() {
    return traceEntryEnabledProperty;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#className() className}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for className
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withClassName(String value) {
    if (this.className == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfigDto(
        newValue,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#declaringClassName() declaringClassName}.
   * @param value value for declaringClassName
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withDeclaringClassName(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        newValue,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#declaringClassName() declaringClassName}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for declaringClassName
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withDeclaringClassName(Optional<String> optional) {
    if (this.declaringClassName == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        newValue,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodName() methodName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for methodName
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withMethodName(String value) {
    if (this.methodName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        newValue,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodParameterTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        newValue,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of methodParameterTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodParameterTypes(Iterable<String> elements) {
    if (this.methodParameterTypes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        newValue,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodReturnType() methodReturnType}.
   * @param value value for methodReturnType
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodReturnType(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        newValue,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodReturnType() methodReturnType}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for methodReturnType
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodReturnType(Optional<String> optional) {
    if (this.methodReturnType == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        newValue,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodModifiers(MethodModifier... elements) {
    ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        newValue,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of methodModifiers elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withMethodModifiers(Iterable<? extends MethodModifier> elements) {
    if (this.methodModifiers == elements) {
      return this;
    }
    ImmutableList<MethodModifier> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        newValue,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#captureKind() captureKind}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureKind
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withCaptureKind(CaptureKind value) {
    if (this.captureKind == value) {
      return this;
    }
    CaptureKind newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        newValue,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#timerName() timerName}.
   * @param value value for timerName
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTimerName(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        newValue,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#timerName() timerName}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for timerName
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTimerName(Optional<String> optional) {
    if (this.timerName == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        newValue,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryTemplate() traceEntryTemplate}.
   * @param value value for traceEntryTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryTemplate(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        newValue,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryTemplate() traceEntryTemplate}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for traceEntryTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryTemplate(Optional<String> optional) {
    if (this.traceEntryTemplate == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        newValue,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryStackThresholdMillis() traceEntryStackThresholdMillis}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceEntryStackThresholdMillis, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryStackThresholdMillis(@Nullable Long value) {
    if (this.traceEntryStackThresholdMillis == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        newValue,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
   * @param value value for traceEntryCaptureSelfNested
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryCaptureSelfNested(boolean value) {
    Optional<Boolean> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        newValue,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for traceEntryCaptureSelfNested
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryCaptureSelfNested(Optional<Boolean> optional) {
    if (this.traceEntryCaptureSelfNested == optional) {
      return this;
    }
    Optional<Boolean> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        newValue,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionType() transactionType}.
   * @param value value for transactionType
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionType(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        newValue,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionType() transactionType}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for transactionType
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionType(Optional<String> optional) {
    if (this.transactionType == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        newValue,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionNameTemplate() transactionNameTemplate}.
   * @param value value for transactionNameTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionNameTemplate(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        newValue,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionNameTemplate() transactionNameTemplate}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for transactionNameTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionNameTemplate(Optional<String> optional) {
    if (this.transactionNameTemplate == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        newValue,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionUserTemplate() transactionUserTemplate}.
   * @param value value for transactionUserTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionUserTemplate(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        newValue,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionUserTemplate() transactionUserTemplate}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for transactionUserTemplate
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionUserTemplate(Optional<String> optional) {
    if (this.transactionUserTemplate == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        newValue,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by replacing {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to transactionCustomAttributeTemplates map
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
    if (this.transactionCustomAttributeTemplates == entries) {
      return this;
    }
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        newValue,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionSlowThresholdMillis() transactionSlowThresholdMillis}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionSlowThresholdMillis, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withTransactionSlowThresholdMillis(@Nullable Long value) {
    if (this.transactionSlowThresholdMillis == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        newValue,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#enabledProperty() enabledProperty}.
   * @param value value for enabledProperty
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withEnabledProperty(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        newValue,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#enabledProperty() enabledProperty}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for enabledProperty
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withEnabledProperty(Optional<String> optional) {
    if (this.enabledProperty == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        newValue,
        this.traceEntryEnabledProperty,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
   * @param value value for traceEntryEnabledProperty
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryEnabledProperty(String value) {
    Optional<String> newValue = Optional.of(value);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for traceEntryEnabledProperty
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigDto withTraceEntryEnabledProperty(Optional<String> optional) {
    if (this.traceEntryEnabledProperty == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigDto withVersion(@Nullable String value) {
    if (this.version == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new InstrumentationConfigDto(
        this.className,
        this.declaringClassName,
        this.methodName,
        this.methodParameterTypes,
        this.methodReturnType,
        this.methodModifiers,
        this.captureKind,
        this.timerName,
        this.traceEntryTemplate,
        this.traceEntryStackThresholdMillis,
        this.traceEntryCaptureSelfNested,
        this.transactionType,
        this.transactionNameTemplate,
        this.transactionUserTemplate,
        this.transactionCustomAttributeTemplates,
        this.transactionSlowThresholdMillis,
        this.enabledProperty,
        this.traceEntryEnabledProperty,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code InstrumentationConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof InstrumentationConfigDto && equalTo((InstrumentationConfigDto) another));
  }
  
  private boolean equalTo(InstrumentationConfigDto another) {
    return className.equals(another.className)
        && declaringClassName.equals(another.declaringClassName)
        && methodName.equals(another.methodName)
        && methodParameterTypes.equals(another.methodParameterTypes)
        && methodReturnType.equals(another.methodReturnType)
        && methodModifiers.equals(another.methodModifiers)
        && captureKind.equals(another.captureKind)
        && timerName.equals(another.timerName)
        && traceEntryTemplate.equals(another.traceEntryTemplate)
        && Objects.equal(traceEntryStackThresholdMillis, another.traceEntryStackThresholdMillis)
        && traceEntryCaptureSelfNested.equals(another.traceEntryCaptureSelfNested)
        && transactionType.equals(another.transactionType)
        && transactionNameTemplate.equals(another.transactionNameTemplate)
        && transactionUserTemplate.equals(another.transactionUserTemplate)
        && transactionCustomAttributeTemplates.equals(another.transactionCustomAttributeTemplates)
        && Objects.equal(transactionSlowThresholdMillis, another.transactionSlowThresholdMillis)
        && enabledProperty.equals(another.enabledProperty)
        && traceEntryEnabledProperty.equals(another.traceEntryEnabledProperty)
        && Objects.equal(version, another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code className}, {@code declaringClassName}, {@code methodName}, {@code methodParameterTypes}, {@code methodReturnType}, {@code methodModifiers}, {@code captureKind}, {@code timerName}, {@code traceEntryTemplate}, {@code traceEntryStackThresholdMillis}, {@code traceEntryCaptureSelfNested}, {@code transactionType}, {@code transactionNameTemplate}, {@code transactionUserTemplate}, {@code transactionCustomAttributeTemplates}, {@code transactionSlowThresholdMillis}, {@code enabledProperty}, {@code traceEntryEnabledProperty}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + className.hashCode();
    h = h * 17 + declaringClassName.hashCode();
    h = h * 17 + methodName.hashCode();
    h = h * 17 + methodParameterTypes.hashCode();
    h = h * 17 + methodReturnType.hashCode();
    h = h * 17 + methodModifiers.hashCode();
    h = h * 17 + captureKind.hashCode();
    h = h * 17 + timerName.hashCode();
    h = h * 17 + traceEntryTemplate.hashCode();
    h = h * 17 + Objects.hashCode(traceEntryStackThresholdMillis);
    h = h * 17 + traceEntryCaptureSelfNested.hashCode();
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + transactionNameTemplate.hashCode();
    h = h * 17 + transactionUserTemplate.hashCode();
    h = h * 17 + transactionCustomAttributeTemplates.hashCode();
    h = h * 17 + Objects.hashCode(transactionSlowThresholdMillis);
    h = h * 17 + enabledProperty.hashCode();
    h = h * 17 + traceEntryEnabledProperty.hashCode();
    h = h * 17 + Objects.hashCode(version);
    return h;
  }
  
  /**
   * Prints immutable value {@code InstrumentationConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InstrumentationConfigDto")
        .add("className", className)
        .add("declaringClassName", declaringClassName)
        .add("methodName", methodName)
        .add("methodParameterTypes", methodParameterTypes)
        .add("methodReturnType", methodReturnType)
        .add("methodModifiers", methodModifiers)
        .add("captureKind", captureKind)
        .add("timerName", timerName)
        .add("traceEntryTemplate", traceEntryTemplate)
        .add("traceEntryStackThresholdMillis", traceEntryStackThresholdMillis)
        .add("traceEntryCaptureSelfNested", traceEntryCaptureSelfNested)
        .add("transactionType", transactionType)
        .add("transactionNameTemplate", transactionNameTemplate)
        .add("transactionUserTemplate", transactionUserTemplate)
        .add("transactionCustomAttributeTemplates", transactionCustomAttributeTemplates)
        .add("transactionSlowThresholdMillis", transactionSlowThresholdMillis)
        .add("enabledProperty", enabledProperty)
        .add("traceEntryEnabledProperty", traceEntryEnabledProperty)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static InstrumentationConfigDto fromAllAttributes(
      @JsonProperty("className") @Nullable String className,
      @JsonProperty("declaringClassName") @Nullable Optional<String> declaringClassName,
      @JsonProperty("methodName") @Nullable String methodName,
      @JsonProperty("methodParameterTypes") @Nullable ImmutableList<String> methodParameterTypes,
      @JsonProperty("methodReturnType") @Nullable Optional<String> methodReturnType,
      @JsonProperty("methodModifiers") @Nullable ImmutableList<MethodModifier> methodModifiers,
      @JsonProperty("captureKind") @Nullable CaptureKind captureKind,
      @JsonProperty("timerName") @Nullable Optional<String> timerName,
      @JsonProperty("traceEntryTemplate") @Nullable Optional<String> traceEntryTemplate,
      @JsonProperty("traceEntryStackThresholdMillis") @Nullable Long traceEntryStackThresholdMillis,
      @JsonProperty("traceEntryCaptureSelfNested") @Nullable Optional<Boolean> traceEntryCaptureSelfNested,
      @JsonProperty("transactionType") @Nullable Optional<String> transactionType,
      @JsonProperty("transactionNameTemplate") @Nullable Optional<String> transactionNameTemplate,
      @JsonProperty("transactionUserTemplate") @Nullable Optional<String> transactionUserTemplate,
      @JsonProperty("transactionCustomAttributeTemplates") @Nullable Map<String, String> transactionCustomAttributeTemplates,
      @JsonProperty("transactionSlowThresholdMillis") @Nullable Long transactionSlowThresholdMillis,
      @JsonProperty("enabledProperty") @Nullable Optional<String> enabledProperty,
      @JsonProperty("traceEntryEnabledProperty") @Nullable Optional<String> traceEntryEnabledProperty,
      @JsonProperty("version") @Nullable String version) {
    InstrumentationConfigDto.Builder builder = InstrumentationConfigDto.builder();
    if (className != null) {
      builder.className(className);
    }
    if (declaringClassName != null) {
      builder.declaringClassName(declaringClassName);
    }
    if (methodName != null) {
      builder.methodName(methodName);
    }
    if (methodParameterTypes != null) {
      builder.addAllMethodParameterTypes(methodParameterTypes);
    }
    if (methodReturnType != null) {
      builder.methodReturnType(methodReturnType);
    }
    if (methodModifiers != null) {
      builder.addAllMethodModifiers(methodModifiers);
    }
    if (captureKind != null) {
      builder.captureKind(captureKind);
    }
    if (timerName != null) {
      builder.timerName(timerName);
    }
    if (traceEntryTemplate != null) {
      builder.traceEntryTemplate(traceEntryTemplate);
    }
    if (traceEntryStackThresholdMillis != null) {
      builder.traceEntryStackThresholdMillis(traceEntryStackThresholdMillis);
    }
    if (traceEntryCaptureSelfNested != null) {
      builder.traceEntryCaptureSelfNested(traceEntryCaptureSelfNested);
    }
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (transactionNameTemplate != null) {
      builder.transactionNameTemplate(transactionNameTemplate);
    }
    if (transactionUserTemplate != null) {
      builder.transactionUserTemplate(transactionUserTemplate);
    }
    if (transactionCustomAttributeTemplates != null) {
      builder.putAllTransactionCustomAttributeTemplates(transactionCustomAttributeTemplates);
    }
    if (transactionSlowThresholdMillis != null) {
      builder.transactionSlowThresholdMillis(transactionSlowThresholdMillis);
    }
    if (enabledProperty != null) {
      builder.enabledProperty(enabledProperty);
    }
    if (traceEntryEnabledProperty != null) {
      builder.traceEntryEnabledProperty(traceEntryEnabledProperty);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.InstrumentationConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable InstrumentationConfigDto instance
   */
  static InstrumentationConfigDto copyOf(InstrumentationJsonService.InstrumentationConfigDtoBase instance) {
    if (instance instanceof InstrumentationConfigDto) {
      return (InstrumentationConfigDto) instance;
    }
    return InstrumentationConfigDto.builder()
        .className(instance.className())
        .declaringClassName(instance.declaringClassName())
        .methodName(instance.methodName())
        .addAllMethodParameterTypes(instance.methodParameterTypes())
        .methodReturnType(instance.methodReturnType())
        .addAllMethodModifiers(instance.methodModifiers())
        .captureKind(instance.captureKind())
        .timerName(instance.timerName())
        .traceEntryTemplate(instance.traceEntryTemplate())
        .traceEntryStackThresholdMillis(instance.traceEntryStackThresholdMillis())
        .traceEntryCaptureSelfNested(instance.traceEntryCaptureSelfNested())
        .transactionType(instance.transactionType())
        .transactionNameTemplate(instance.transactionNameTemplate())
        .transactionUserTemplate(instance.transactionUserTemplate())
        .putAllTransactionCustomAttributeTemplates(instance.transactionCustomAttributeTemplates())
        .transactionSlowThresholdMillis(instance.transactionSlowThresholdMillis())
        .enabledProperty(instance.enabledProperty())
        .traceEntryEnabledProperty(instance.traceEntryEnabledProperty())
        .version(instance.version())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.InstrumentationConfigDto}.
   * @return new InstrumentationConfigDto builder
   */
  static InstrumentationConfigDto.Builder builder() {
    return new InstrumentationConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.InstrumentationConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_CLASS_NAME = 0x1L;
    private static final long INITIALIZED_BIT_METHOD_NAME = 0x2L;
    private static final long INITIALIZED_BIT_CAPTURE_KIND = 0x4L;
    private static final long NONDEFAULT_BIT_DECLARING_CLASS_NAME = 0x1L;
    private static final long NONDEFAULT_BIT_METHOD_RETURN_TYPE = 0x2L;
    private static final long NONDEFAULT_BIT_TIMER_NAME = 0x4L;
    private static final long NONDEFAULT_BIT_TRACE_ENTRY_TEMPLATE = 0x8L;
    private static final long NONDEFAULT_BIT_TRACE_ENTRY_STACK_THRESHOLD_MILLIS = 0x10L;
    private static final long NONDEFAULT_BIT_TRACE_ENTRY_CAPTURE_SELF_NESTED = 0x20L;
    private static final long NONDEFAULT_BIT_TRANSACTION_TYPE = 0x40L;
    private static final long NONDEFAULT_BIT_TRANSACTION_NAME_TEMPLATE = 0x80L;
    private static final long NONDEFAULT_BIT_TRANSACTION_USER_TEMPLATE = 0x100L;
    private static final long NONDEFAULT_BIT_TRANSACTION_SLOW_THRESHOLD_MILLIS = 0x200L;
    private static final long NONDEFAULT_BIT_ENABLED_PROPERTY = 0x400L;
    private static final long NONDEFAULT_BIT_TRACE_ENTRY_ENABLED_PROPERTY = 0x800L;
    private static final long NONDEFAULT_BIT_VERSION = 0x1000L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String className;
    private Optional<String> declaringClassName = Optional.absent();
    private @Nullable String methodName;
    private ImmutableList.Builder<String> methodParameterTypesBuilder = ImmutableList.builder();
    private Optional<String> methodReturnType = Optional.absent();
    private ImmutableList.Builder<MethodModifier> methodModifiersBuilder = ImmutableList.builder();
    private @Nullable CaptureKind captureKind;
    private Optional<String> timerName = Optional.absent();
    private Optional<String> traceEntryTemplate = Optional.absent();
    private @Nullable Long traceEntryStackThresholdMillis;
    private Optional<Boolean> traceEntryCaptureSelfNested = Optional.absent();
    private Optional<String> transactionType = Optional.absent();
    private Optional<String> transactionNameTemplate = Optional.absent();
    private Optional<String> transactionUserTemplate = Optional.absent();
    private ImmutableMap.Builder<String, String> transactionCustomAttributeTemplatesBuilder = ImmutableMap.builder();
    private @Nullable Long transactionSlowThresholdMillis;
    private Optional<String> enabledProperty = Optional.absent();
    private Optional<String> traceEntryEnabledProperty = Optional.absent();
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#className() className}.
     * @param className value for className
     * @return {@code this} builder for chained invocation
     */
    public final Builder className(String className) {
      checkNotIsSet(classNameIsSet(), "className");
      this.className = Preconditions.checkNotNull(className);
      initializedBitset |= INITIALIZED_BIT_CLASS_NAME;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#declaringClassName() declaringClassName}.
     * @param declaringClassName value for declaringClassName
     * @return {@code this} builder for chained invocation
     */
    public final Builder declaringClassName(String declaringClassName) {
      checkNotIsSet(declaringClassNameIsSet(), "declaringClassName");
      this.declaringClassName = Optional.of(declaringClassName);
      nondefaultBitset |= NONDEFAULT_BIT_DECLARING_CLASS_NAME;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#declaringClassName() declaringClassName}.
     * @param declaringClassName value for declaringClassName
     * @return {@code this} builder for chained invocation
     */
    public final Builder declaringClassName(Optional<String> declaringClassName) {
      checkNotIsSet(declaringClassNameIsSet(), "declaringClassName");
      this.declaringClassName = Preconditions.checkNotNull(declaringClassName);
      nondefaultBitset |= NONDEFAULT_BIT_DECLARING_CLASS_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodName() methodName}.
     * @param methodName value for methodName
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodName(String methodName) {
      checkNotIsSet(methodNameIsSet(), "methodName");
      this.methodName = Preconditions.checkNotNull(methodName);
      initializedBitset |= INITIALIZED_BIT_METHOD_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes} list.
     * @param element methodParameterTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodParameterTypes(String element) {
      methodParameterTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes} list.
     * @param elements array of methodParameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodParameterTypes(String... elements) {
      methodParameterTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodParameterTypes() methodParameterTypes} list.
     * @param elements iterable of methodParameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMethodParameterTypes(Iterable<String> elements) {
      methodParameterTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodReturnType() methodReturnType}.
     * @param methodReturnType value for methodReturnType
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodReturnType(String methodReturnType) {
      checkNotIsSet(methodReturnTypeIsSet(), "methodReturnType");
      this.methodReturnType = Optional.of(methodReturnType);
      nondefaultBitset |= NONDEFAULT_BIT_METHOD_RETURN_TYPE;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodReturnType() methodReturnType}.
     * @param methodReturnType value for methodReturnType
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodReturnType(Optional<String> methodReturnType) {
      checkNotIsSet(methodReturnTypeIsSet(), "methodReturnType");
      this.methodReturnType = Preconditions.checkNotNull(methodReturnType);
      nondefaultBitset |= NONDEFAULT_BIT_METHOD_RETURN_TYPE;
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers} list.
     * @param element methodModifiers element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodModifiers(MethodModifier element) {
      methodModifiersBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers} list.
     * @param elements array of methodModifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodModifiers(MethodModifier... elements) {
      methodModifiersBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#methodModifiers() methodModifiers} list.
     * @param elements iterable of methodModifiers elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMethodModifiers(Iterable<? extends MethodModifier> elements) {
      methodModifiersBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#captureKind() captureKind}.
     * @param captureKind value for captureKind
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureKind(CaptureKind captureKind) {
      checkNotIsSet(captureKindIsSet(), "captureKind");
      this.captureKind = Preconditions.checkNotNull(captureKind);
      initializedBitset |= INITIALIZED_BIT_CAPTURE_KIND;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#timerName() timerName}.
     * @param timerName value for timerName
     * @return {@code this} builder for chained invocation
     */
    public final Builder timerName(String timerName) {
      checkNotIsSet(timerNameIsSet(), "timerName");
      this.timerName = Optional.of(timerName);
      nondefaultBitset |= NONDEFAULT_BIT_TIMER_NAME;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#timerName() timerName}.
     * @param timerName value for timerName
     * @return {@code this} builder for chained invocation
     */
    public final Builder timerName(Optional<String> timerName) {
      checkNotIsSet(timerNameIsSet(), "timerName");
      this.timerName = Preconditions.checkNotNull(timerName);
      nondefaultBitset |= NONDEFAULT_BIT_TIMER_NAME;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryTemplate() traceEntryTemplate}.
     * @param traceEntryTemplate value for traceEntryTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryTemplate(String traceEntryTemplate) {
      checkNotIsSet(traceEntryTemplateIsSet(), "traceEntryTemplate");
      this.traceEntryTemplate = Optional.of(traceEntryTemplate);
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_TEMPLATE;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryTemplate() traceEntryTemplate}.
     * @param traceEntryTemplate value for traceEntryTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryTemplate(Optional<String> traceEntryTemplate) {
      checkNotIsSet(traceEntryTemplateIsSet(), "traceEntryTemplate");
      this.traceEntryTemplate = Preconditions.checkNotNull(traceEntryTemplate);
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_TEMPLATE;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryStackThresholdMillis() traceEntryStackThresholdMillis}.
     * @param traceEntryStackThresholdMillis value for traceEntryStackThresholdMillis, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryStackThresholdMillis(@Nullable Long traceEntryStackThresholdMillis) {
      checkNotIsSet(traceEntryStackThresholdMillisIsSet(), "traceEntryStackThresholdMillis");
      this.traceEntryStackThresholdMillis = traceEntryStackThresholdMillis;
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_STACK_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
     * @param traceEntryCaptureSelfNested value for traceEntryCaptureSelfNested
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryCaptureSelfNested(boolean traceEntryCaptureSelfNested) {
      checkNotIsSet(traceEntryCaptureSelfNestedIsSet(), "traceEntryCaptureSelfNested");
      this.traceEntryCaptureSelfNested = Optional.of(traceEntryCaptureSelfNested);
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_CAPTURE_SELF_NESTED;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryCaptureSelfNested() traceEntryCaptureSelfNested}.
     * @param traceEntryCaptureSelfNested value for traceEntryCaptureSelfNested
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryCaptureSelfNested(Optional<Boolean> traceEntryCaptureSelfNested) {
      checkNotIsSet(traceEntryCaptureSelfNestedIsSet(), "traceEntryCaptureSelfNested");
      this.traceEntryCaptureSelfNested = Preconditions.checkNotNull(traceEntryCaptureSelfNested);
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_CAPTURE_SELF_NESTED;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      checkNotIsSet(transactionTypeIsSet(), "transactionType");
      this.transactionType = Optional.of(transactionType);
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(Optional<String> transactionType) {
      checkNotIsSet(transactionTypeIsSet(), "transactionType");
      this.transactionType = Preconditions.checkNotNull(transactionType);
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionNameTemplate() transactionNameTemplate}.
     * @param transactionNameTemplate value for transactionNameTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionNameTemplate(String transactionNameTemplate) {
      checkNotIsSet(transactionNameTemplateIsSet(), "transactionNameTemplate");
      this.transactionNameTemplate = Optional.of(transactionNameTemplate);
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_NAME_TEMPLATE;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionNameTemplate() transactionNameTemplate}.
     * @param transactionNameTemplate value for transactionNameTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionNameTemplate(Optional<String> transactionNameTemplate) {
      checkNotIsSet(transactionNameTemplateIsSet(), "transactionNameTemplate");
      this.transactionNameTemplate = Preconditions.checkNotNull(transactionNameTemplate);
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_NAME_TEMPLATE;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionUserTemplate() transactionUserTemplate}.
     * @param transactionUserTemplate value for transactionUserTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionUserTemplate(String transactionUserTemplate) {
      checkNotIsSet(transactionUserTemplateIsSet(), "transactionUserTemplate");
      this.transactionUserTemplate = Optional.of(transactionUserTemplate);
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_USER_TEMPLATE;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionUserTemplate() transactionUserTemplate}.
     * @param transactionUserTemplate value for transactionUserTemplate
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionUserTemplate(Optional<String> transactionUserTemplate) {
      checkNotIsSet(transactionUserTemplateIsSet(), "transactionUserTemplate");
      this.transactionUserTemplate = Preconditions.checkNotNull(transactionUserTemplate);
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_USER_TEMPLATE;
      return this;
    }
  
    /**
     * Put one entry to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map.
     * @param key the key in transactionCustomAttributeTemplates map
     * @param value the associated value in transactionCustomAttributeTemplates map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putTransactionCustomAttributeTemplates(String key, String value) {
      transactionCustomAttributeTemplatesBuilder.put(key, value);
      return this;
    }
  
    /**
     * Put one entry to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putTransactionCustomAttributeTemplates(Map.Entry<String, ? extends String> entry) {
      transactionCustomAttributeTemplatesBuilder.put(entry);
      return this;
    }
  
    /**
     * Put all mappings from specified map as entries to {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionCustomAttributeTemplates() transactionCustomAttributeTemplates} map. Nulls are not permitted
     * @param entries to be added to transactionCustomAttributeTemplates map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllTransactionCustomAttributeTemplates(Map<String, ? extends String> entries) {
      transactionCustomAttributeTemplatesBuilder.putAll(entries);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#transactionSlowThresholdMillis() transactionSlowThresholdMillis}.
     * @param transactionSlowThresholdMillis value for transactionSlowThresholdMillis, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionSlowThresholdMillis(@Nullable Long transactionSlowThresholdMillis) {
      checkNotIsSet(transactionSlowThresholdMillisIsSet(), "transactionSlowThresholdMillis");
      this.transactionSlowThresholdMillis = transactionSlowThresholdMillis;
      nondefaultBitset |= NONDEFAULT_BIT_TRANSACTION_SLOW_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#enabledProperty() enabledProperty}.
     * @param enabledProperty value for enabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabledProperty(String enabledProperty) {
      checkNotIsSet(enabledPropertyIsSet(), "enabledProperty");
      this.enabledProperty = Optional.of(enabledProperty);
      nondefaultBitset |= NONDEFAULT_BIT_ENABLED_PROPERTY;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#enabledProperty() enabledProperty}.
     * @param enabledProperty value for enabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabledProperty(Optional<String> enabledProperty) {
      checkNotIsSet(enabledPropertyIsSet(), "enabledProperty");
      this.enabledProperty = Preconditions.checkNotNull(enabledProperty);
      nondefaultBitset |= NONDEFAULT_BIT_ENABLED_PROPERTY;
      return this;
    }
  
    /**
     * Initializes present value for optional {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
     * @param traceEntryEnabledProperty value for traceEntryEnabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryEnabledProperty(String traceEntryEnabledProperty) {
      checkNotIsSet(traceEntryEnabledPropertyIsSet(), "traceEntryEnabledProperty");
      this.traceEntryEnabledProperty = Optional.of(traceEntryEnabledProperty);
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_ENABLED_PROPERTY;
      return this;
    }
  
    /**
     * Initializes optional value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#traceEntryEnabledProperty() traceEntryEnabledProperty}.
     * @param traceEntryEnabledProperty value for traceEntryEnabledProperty
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceEntryEnabledProperty(Optional<String> traceEntryEnabledProperty) {
      checkNotIsSet(traceEntryEnabledPropertyIsSet(), "traceEntryEnabledProperty");
      this.traceEntryEnabledProperty = Preconditions.checkNotNull(traceEntryEnabledProperty);
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_ENTRY_ENABLED_PROPERTY;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigDtoBase#version() version}.
     * @param version value for version, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(@Nullable String version) {
      checkNotIsSet(versionIsSet(), "version");
      this.version = version;
      nondefaultBitset |= NONDEFAULT_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.InstrumentationConfigDto}.
     * @return immutable instance of InstrumentationConfigDto
     */
    public org.glowroot.local.ui.InstrumentationConfigDto build() {
      checkRequiredAttributes();
      return new InstrumentationConfigDto(
        className,
        declaringClassName,
        methodName,
        methodParameterTypesBuilder.build(),
        methodReturnType,
        methodModifiersBuilder.build(),
        captureKind,
        timerName,
        traceEntryTemplate,
        traceEntryStackThresholdMillis,
        traceEntryCaptureSelfNested,
        transactionType,
        transactionNameTemplate,
        transactionUserTemplate,
        transactionCustomAttributeTemplatesBuilder.build(),
        transactionSlowThresholdMillis,
        enabledProperty,
        traceEntryEnabledProperty,
        version);
    }
  
    private boolean declaringClassNameIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_DECLARING_CLASS_NAME) != 0;
    }
  
    private boolean methodReturnTypeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_METHOD_RETURN_TYPE) != 0;
    }
  
    private boolean timerNameIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TIMER_NAME) != 0;
    }
  
    private boolean traceEntryTemplateIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_ENTRY_TEMPLATE) != 0;
    }
  
    private boolean traceEntryStackThresholdMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_ENTRY_STACK_THRESHOLD_MILLIS) != 0;
    }
  
    private boolean traceEntryCaptureSelfNestedIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_ENTRY_CAPTURE_SELF_NESTED) != 0;
    }
  
    private boolean transactionTypeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean transactionNameTemplateIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_NAME_TEMPLATE) != 0;
    }
  
    private boolean transactionUserTemplateIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_USER_TEMPLATE) != 0;
    }
  
    private boolean transactionSlowThresholdMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRANSACTION_SLOW_THRESHOLD_MILLIS) != 0;
    }
  
    private boolean enabledPropertyIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ENABLED_PROPERTY) != 0;
    }
  
    private boolean traceEntryEnabledPropertyIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_ENTRY_ENABLED_PROPERTY) != 0;
    }
  
    private boolean versionIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_VERSION) != 0;
    }
  
    private boolean classNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CLASS_NAME) != 0;
    }
  
    private boolean methodNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_METHOD_NAME) != 0;
    }
  
    private boolean captureKindIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_KIND) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of InstrumentationConfigDto is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!classNameIsSet()) {
        attributes.add("className");
      }
      if (!methodNameIsSet()) {
        attributes.add("methodName");
      }
      if (!captureKindIsSet()) {
        attributes.add("captureKind");
      }
      return "Cannot build InstrumentationConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
