package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstrumentationJsonService.InstrumentationConfigResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code InstrumentationConfigResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.InstrumentationConfigResponseBase"})
@Immutable
final class InstrumentationConfigResponse
    extends InstrumentationJsonService.InstrumentationConfigResponseBase {
  private final InstrumentationConfigDto config;
  private final ImmutableList<MethodSignature> methodSignatures;

  private InstrumentationConfigResponse(
      InstrumentationConfigDto config,
      ImmutableList<MethodSignature> methodSignatures) {
    this.config = config;
    this.methodSignatures = methodSignatures;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code config} attribute
   */
  @JsonProperty("config")
  @Override
  public InstrumentationConfigDto config() {
    return config;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodSignatures} attribute
   */
  @JsonProperty("methodSignatures")
  @Override
  public ImmutableList<MethodSignature> methodSignatures() {
    return methodSignatures;
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationConfigResponseBase#config() config}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for config
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationConfigResponse withConfig(InstrumentationConfigDto value) {
    if (this.config == value) {
      return this;
    }
    InstrumentationConfigDto newValue = Preconditions.checkNotNull(value);
    return new InstrumentationConfigResponse(newValue, this.methodSignatures);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigResponse withMethodSignatures(MethodSignature... elements) {
    ImmutableList<MethodSignature> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigResponse(this.config, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of methodSignatures elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationConfigResponse withMethodSignatures(Iterable<? extends MethodSignature> elements) {
    if (this.methodSignatures == elements) {
      return this;
    }
    ImmutableList<MethodSignature> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationConfigResponse(this.config, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code InstrumentationConfigResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof InstrumentationConfigResponse && equalTo((InstrumentationConfigResponse) another));
  }
  
  private boolean equalTo(InstrumentationConfigResponse another) {
    return config.equals(another.config)
        && methodSignatures.equals(another.methodSignatures);
  }
  
  /**
   * Computes hash code from attributes: {@code config}, {@code methodSignatures}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + config.hashCode();
    h = h * 17 + methodSignatures.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code InstrumentationConfigResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InstrumentationConfigResponse")
        .add("config", config)
        .add("methodSignatures", methodSignatures)
        .toString();
  }
  
  @JsonCreator
  public static InstrumentationConfigResponse fromAllAttributes(
      @JsonProperty("config") @Nullable InstrumentationConfigDto config,
      @JsonProperty("methodSignatures") @Nullable ImmutableList<MethodSignature> methodSignatures) {
    InstrumentationConfigResponse.Builder builder = InstrumentationConfigResponse.builder();
    if (config != null) {
      builder.config(config);
    }
    if (methodSignatures != null) {
      builder.addAllMethodSignatures(methodSignatures);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.InstrumentationConfigResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable InstrumentationConfigResponse instance
   */
  static InstrumentationConfigResponse copyOf(InstrumentationJsonService.InstrumentationConfigResponseBase instance) {
    if (instance instanceof InstrumentationConfigResponse) {
      return (InstrumentationConfigResponse) instance;
    }
    return InstrumentationConfigResponse.builder()
        .config(instance.config())
        .addAllMethodSignatures(instance.methodSignatures())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.InstrumentationConfigResponse}.
   * @return new InstrumentationConfigResponse builder
   */
  static InstrumentationConfigResponse.Builder builder() {
    return new InstrumentationConfigResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.InstrumentationConfigResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_CONFIG = 0x1L;
    private long initializedBitset;
  
    private @Nullable InstrumentationConfigDto config;
    private ImmutableList.Builder<MethodSignature> methodSignaturesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationConfigResponseBase#config() config}.
     * @param config value for config
     * @return {@code this} builder for chained invocation
     */
    public final Builder config(InstrumentationConfigDto config) {
      checkNotIsSet(configIsSet(), "config");
      this.config = Preconditions.checkNotNull(config);
      initializedBitset |= INITIALIZED_BIT_CONFIG;
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures} list.
     * @param element methodSignatures element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodSignatures(MethodSignature element) {
      methodSignaturesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures} list.
     * @param elements array of methodSignatures elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMethodSignatures(MethodSignature... elements) {
      methodSignaturesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationConfigResponseBase#methodSignatures() methodSignatures} list.
     * @param elements iterable of methodSignatures elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMethodSignatures(Iterable<? extends MethodSignature> elements) {
      methodSignaturesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.InstrumentationConfigResponse}.
     * @return immutable instance of InstrumentationConfigResponse
     */
    public org.glowroot.local.ui.InstrumentationConfigResponse build() {
      checkRequiredAttributes();
      return new InstrumentationConfigResponse(config, methodSignaturesBuilder.build());
    }
  
    private boolean configIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CONFIG) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of InstrumentationConfigResponse is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!configIsSet()) {
        attributes.add("config");
      }
      return "Cannot build InstrumentationConfigResponse, some of required attributes are not set " + attributes;
    }
  }
}
