package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstrumentationJsonService.InstrumentationListResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code InstrumentationListResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.InstrumentationListResponseBase"})
@Immutable
final class InstrumentationListResponse
    extends InstrumentationJsonService.InstrumentationListResponseBase {
  private final ImmutableList<InstrumentationConfigDto> configs;
  private final boolean jvmOutOfSync;
  private final boolean jvmRetransformClassesSupported;

  private InstrumentationListResponse(
      ImmutableList<InstrumentationConfigDto> configs,
      boolean jvmOutOfSync,
      boolean jvmRetransformClassesSupported) {
    this.configs = configs;
    this.jvmOutOfSync = jvmOutOfSync;
    this.jvmRetransformClassesSupported = jvmRetransformClassesSupported;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code configs} attribute
   */
  @JsonProperty("configs")
  @Override
  public ImmutableList<InstrumentationConfigDto> configs() {
    return configs;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code jvmOutOfSync} attribute
   */
  @JsonProperty("jvmOutOfSync")
  @Override
  public boolean jvmOutOfSync() {
    return jvmOutOfSync;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code jvmRetransformClassesSupported} attribute
   */
  @JsonProperty("jvmRetransformClassesSupported")
  @Override
  public boolean jvmRetransformClassesSupported() {
    return jvmRetransformClassesSupported;
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationListResponseBase#configs() configs}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationListResponse withConfigs(InstrumentationConfigDto... elements) {
    ImmutableList<InstrumentationConfigDto> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationListResponse(newValue, this.jvmOutOfSync, this.jvmRetransformClassesSupported);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationListResponseBase#configs() configs}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of configs elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationListResponse withConfigs(Iterable<? extends InstrumentationConfigDto> elements) {
    if (this.configs == elements) {
      return this;
    }
    ImmutableList<InstrumentationConfigDto> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationListResponse(newValue, this.jvmOutOfSync, this.jvmRetransformClassesSupported);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationListResponseBase#jvmOutOfSync() jvmOutOfSync}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for jvmOutOfSync
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationListResponse withJvmOutOfSync(boolean value) {
    if (this.jvmOutOfSync == value) {
      return this;
    }
    boolean newValue = value;
    return new InstrumentationListResponse(this.configs, newValue, this.jvmRetransformClassesSupported);
  }
  
  /**
   * Copy current immutable object by setting value for {@link InstrumentationJsonService.InstrumentationListResponseBase#jvmRetransformClassesSupported() jvmRetransformClassesSupported}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for jvmRetransformClassesSupported
   * @return modified copy of the {@code this} object
   */
  public final InstrumentationListResponse withJvmRetransformClassesSupported(boolean value) {
    if (this.jvmRetransformClassesSupported == value) {
      return this;
    }
    boolean newValue = value;
    return new InstrumentationListResponse(this.configs, this.jvmOutOfSync, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code InstrumentationListResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof InstrumentationListResponse && equalTo((InstrumentationListResponse) another));
  }
  
  private boolean equalTo(InstrumentationListResponse another) {
    return configs.equals(another.configs)
        && jvmOutOfSync == another.jvmOutOfSync
        && jvmRetransformClassesSupported == another.jvmRetransformClassesSupported;
  }
  
  /**
   * Computes hash code from attributes: {@code configs}, {@code jvmOutOfSync}, {@code jvmRetransformClassesSupported}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + configs.hashCode();
    h = h * 17 + Booleans.hashCode(jvmOutOfSync);
    h = h * 17 + Booleans.hashCode(jvmRetransformClassesSupported);
    return h;
  }
  
  /**
   * Prints immutable value {@code InstrumentationListResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InstrumentationListResponse")
        .add("configs", configs)
        .add("jvmOutOfSync", jvmOutOfSync)
        .add("jvmRetransformClassesSupported", jvmRetransformClassesSupported)
        .toString();
  }
  
  @JsonCreator
  public static InstrumentationListResponse fromAllAttributes(
      @JsonProperty("configs") @Nullable ImmutableList<InstrumentationConfigDto> configs,
      @JsonProperty("jvmOutOfSync") @Nullable Boolean jvmOutOfSync,
      @JsonProperty("jvmRetransformClassesSupported") @Nullable Boolean jvmRetransformClassesSupported) {
    InstrumentationListResponse.Builder builder = InstrumentationListResponse.builder();
    if (configs != null) {
      builder.addAllConfigs(configs);
    }
    if (jvmOutOfSync != null) {
      builder.jvmOutOfSync(jvmOutOfSync);
    }
    if (jvmRetransformClassesSupported != null) {
      builder.jvmRetransformClassesSupported(jvmRetransformClassesSupported);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.InstrumentationListResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable InstrumentationListResponse instance
   */
  static InstrumentationListResponse copyOf(InstrumentationJsonService.InstrumentationListResponseBase instance) {
    if (instance instanceof InstrumentationListResponse) {
      return (InstrumentationListResponse) instance;
    }
    return InstrumentationListResponse.builder()
        .addAllConfigs(instance.configs())
        .jvmOutOfSync(instance.jvmOutOfSync())
        .jvmRetransformClassesSupported(instance.jvmRetransformClassesSupported())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.InstrumentationListResponse}.
   * @return new InstrumentationListResponse builder
   */
  static InstrumentationListResponse.Builder builder() {
    return new InstrumentationListResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.InstrumentationListResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_JVM_OUT_OF_SYNC = 0x1L;
    private static final long INITIALIZED_BIT_JVM_RETRANSFORM_CLASSES_SUPPORTED = 0x2L;
    private long initializedBitset;
  
    private ImmutableList.Builder<InstrumentationConfigDto> configsBuilder = ImmutableList.builder();
    private boolean jvmOutOfSync;
    private boolean jvmRetransformClassesSupported;
    private Builder() {}
  
    /**
     * Adds one element to {@link InstrumentationJsonService.InstrumentationListResponseBase#configs() configs} list.
     * @param element configs element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addConfigs(InstrumentationConfigDto element) {
      configsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationListResponseBase#configs() configs} list.
     * @param elements array of configs elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addConfigs(InstrumentationConfigDto... elements) {
      configsBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationListResponseBase#configs() configs} list.
     * @param elements iterable of configs elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllConfigs(Iterable<? extends InstrumentationConfigDto> elements) {
      configsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationListResponseBase#jvmOutOfSync() jvmOutOfSync}.
     * @param jvmOutOfSync value for jvmOutOfSync
     * @return {@code this} builder for chained invocation
     */
    public final Builder jvmOutOfSync(boolean jvmOutOfSync) {
      checkNotIsSet(jvmOutOfSyncIsSet(), "jvmOutOfSync");
      this.jvmOutOfSync = jvmOutOfSync;
      initializedBitset |= INITIALIZED_BIT_JVM_OUT_OF_SYNC;
      return this;
    }
  
    /**
     * Initializes value for {@link InstrumentationJsonService.InstrumentationListResponseBase#jvmRetransformClassesSupported() jvmRetransformClassesSupported}.
     * @param jvmRetransformClassesSupported value for jvmRetransformClassesSupported
     * @return {@code this} builder for chained invocation
     */
    public final Builder jvmRetransformClassesSupported(boolean jvmRetransformClassesSupported) {
      checkNotIsSet(jvmRetransformClassesSupportedIsSet(), "jvmRetransformClassesSupported");
      this.jvmRetransformClassesSupported = jvmRetransformClassesSupported;
      initializedBitset |= INITIALIZED_BIT_JVM_RETRANSFORM_CLASSES_SUPPORTED;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.InstrumentationListResponse}.
     * @return immutable instance of InstrumentationListResponse
     */
    public org.glowroot.local.ui.InstrumentationListResponse build() {
      checkRequiredAttributes();
      return new InstrumentationListResponse(configsBuilder.build(), jvmOutOfSync, jvmRetransformClassesSupported);
    }
  
    private boolean jvmOutOfSyncIsSet() {
      return (initializedBitset & INITIALIZED_BIT_JVM_OUT_OF_SYNC) != 0;
    }
  
    private boolean jvmRetransformClassesSupportedIsSet() {
      return (initializedBitset & INITIALIZED_BIT_JVM_RETRANSFORM_CLASSES_SUPPORTED) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of InstrumentationListResponse is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!jvmOutOfSyncIsSet()) {
        attributes.add("jvmOutOfSync");
      }
      if (!jvmRetransformClassesSupportedIsSet()) {
        attributes.add("jvmRetransformClassesSupported");
      }
      return "Cannot build InstrumentationListResponse, some of required attributes are not set " + attributes;
    }
  }
}
