package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AnonymousAccess;
import org.glowroot.config.RollupConfig;

/**
 * Immutable implementation of {@link LayoutBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code Layout.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "LayoutBase"})
@Immutable
final class Layout extends LayoutBase {
  private final boolean jvmHeapDump;
  private final String footerMessage;
  private final boolean adminPasswordEnabled;
  private final boolean readOnlyPasswordEnabled;
  private final AnonymousAccess anonymousAccess;
  private final ImmutableList<String> transactionTypes;
  private final String defaultTransactionType;
  private final ImmutableList<Double> defaultPercentiles;
  private final ImmutableList<String> transactionCustomAttributes;
  private final ImmutableList<RollupConfig> rollupConfigs;
  private final ImmutableList<Long> rollupExpirationMillis;
  private final long gaugeCollectionIntervalMillis;
  private final String version;

  private Layout(
      boolean jvmHeapDump,
      String footerMessage,
      boolean adminPasswordEnabled,
      boolean readOnlyPasswordEnabled,
      AnonymousAccess anonymousAccess,
      ImmutableList<String> transactionTypes,
      String defaultTransactionType,
      ImmutableList<Double> defaultPercentiles,
      ImmutableList<String> transactionCustomAttributes,
      ImmutableList<RollupConfig> rollupConfigs,
      ImmutableList<Long> rollupExpirationMillis,
      long gaugeCollectionIntervalMillis) {
    this.jvmHeapDump = jvmHeapDump;
    this.footerMessage = footerMessage;
    this.adminPasswordEnabled = adminPasswordEnabled;
    this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
    this.anonymousAccess = anonymousAccess;
    this.transactionTypes = transactionTypes;
    this.defaultTransactionType = defaultTransactionType;
    this.defaultPercentiles = defaultPercentiles;
    this.transactionCustomAttributes = transactionCustomAttributes;
    this.rollupConfigs = rollupConfigs;
    this.rollupExpirationMillis = rollupExpirationMillis;
    this.gaugeCollectionIntervalMillis = gaugeCollectionIntervalMillis;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code jvmHeapDump} attribute
   */
  @JsonProperty("jvmHeapDump")
  @Override
  public boolean jvmHeapDump() {
    return jvmHeapDump;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code footerMessage} attribute
   */
  @JsonProperty("footerMessage")
  @Override
  public String footerMessage() {
    return footerMessage;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code adminPasswordEnabled} attribute
   */
  @JsonProperty("adminPasswordEnabled")
  @Override
  public boolean adminPasswordEnabled() {
    return adminPasswordEnabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code readOnlyPasswordEnabled} attribute
   */
  @JsonProperty("readOnlyPasswordEnabled")
  @Override
  public boolean readOnlyPasswordEnabled() {
    return readOnlyPasswordEnabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code anonymousAccess} attribute
   */
  @JsonProperty("anonymousAccess")
  @Override
  public AnonymousAccess anonymousAccess() {
    return anonymousAccess;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionTypes} attribute
   */
  @JsonProperty("transactionTypes")
  @Override
  public ImmutableList<String> transactionTypes() {
    return transactionTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultTransactionType} attribute
   */
  @JsonProperty("defaultTransactionType")
  @Override
  public String defaultTransactionType() {
    return defaultTransactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultPercentiles} attribute
   */
  @JsonProperty("defaultPercentiles")
  @Override
  public ImmutableList<Double> defaultPercentiles() {
    return defaultPercentiles;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCustomAttributes} attribute
   */
  @JsonProperty("transactionCustomAttributes")
  @Override
  public ImmutableList<String> transactionCustomAttributes() {
    return transactionCustomAttributes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rollupConfigs} attribute
   */
  @JsonProperty("rollupConfigs")
  @Override
  public ImmutableList<RollupConfig> rollupConfigs() {
    return rollupConfigs;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rollupExpirationMillis} attribute
   */
  @JsonProperty("rollupExpirationMillis")
  @Override
  public ImmutableList<Long> rollupExpirationMillis() {
    return rollupExpirationMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code gaugeCollectionIntervalMillis} attribute
   */
  @JsonProperty("gaugeCollectionIntervalMillis")
  @Override
  public long gaugeCollectionIntervalMillis() {
    return gaugeCollectionIntervalMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#jvmHeapDump() jvmHeapDump}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for jvmHeapDump
   * @return modified copy of the {@code this} object
   */
  public final Layout withJvmHeapDump(boolean value) {
    if (this.jvmHeapDump == value) {
      return this;
    }
    boolean newValue = value;
    return new Layout(
        newValue,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#footerMessage() footerMessage}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for footerMessage
   * @return modified copy of the {@code this} object
   */
  public final Layout withFooterMessage(String value) {
    if (this.footerMessage == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Layout(
        this.jvmHeapDump,
        newValue,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#adminPasswordEnabled() adminPasswordEnabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for adminPasswordEnabled
   * @return modified copy of the {@code this} object
   */
  public final Layout withAdminPasswordEnabled(boolean value) {
    if (this.adminPasswordEnabled == value) {
      return this;
    }
    boolean newValue = value;
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        newValue,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#readOnlyPasswordEnabled() readOnlyPasswordEnabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for readOnlyPasswordEnabled
   * @return modified copy of the {@code this} object
   */
  public final Layout withReadOnlyPasswordEnabled(boolean value) {
    if (this.readOnlyPasswordEnabled == value) {
      return this;
    }
    boolean newValue = value;
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        newValue,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#anonymousAccess() anonymousAccess}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for anonymousAccess
   * @return modified copy of the {@code this} object
   */
  public final Layout withAnonymousAccess(AnonymousAccess value) {
    if (this.anonymousAccess == value) {
      return this;
    }
    AnonymousAccess newValue = Preconditions.checkNotNull(value);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        newValue,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#transactionTypes() transactionTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withTransactionTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        newValue,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#transactionTypes() transactionTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of transactionTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withTransactionTypes(Iterable<String> elements) {
    if (this.transactionTypes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        newValue,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#defaultTransactionType() defaultTransactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for defaultTransactionType
   * @return modified copy of the {@code this} object
   */
  public final Layout withDefaultTransactionType(String value) {
    if (this.defaultTransactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        newValue,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#defaultPercentiles() defaultPercentiles}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withDefaultPercentiles(double... elements) {
    ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        newValue,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#defaultPercentiles() defaultPercentiles}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of defaultPercentiles elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withDefaultPercentiles(Iterable<Double> elements) {
    if (this.defaultPercentiles == elements) {
      return this;
    }
    ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        newValue,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withTransactionCustomAttributes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        newValue,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of transactionCustomAttributes elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withTransactionCustomAttributes(Iterable<String> elements) {
    if (this.transactionCustomAttributes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        newValue,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#rollupConfigs() rollupConfigs}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withRollupConfigs(RollupConfig... elements) {
    ImmutableList<RollupConfig> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        newValue,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#rollupConfigs() rollupConfigs}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of rollupConfigs elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withRollupConfigs(Iterable<? extends RollupConfig> elements) {
    if (this.rollupConfigs == elements) {
      return this;
    }
    ImmutableList<RollupConfig> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        newValue,
        this.rollupExpirationMillis,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#rollupExpirationMillis() rollupExpirationMillis}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withRollupExpirationMillis(long... elements) {
    ImmutableList<Long> newValue = ImmutableList.copyOf(Longs.asList(elements));
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        newValue,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LayoutBase#rollupExpirationMillis() rollupExpirationMillis}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of rollupExpirationMillis elements to set
   * @return modified copy of {@code this} object
   */
  public final Layout withRollupExpirationMillis(Iterable<Long> elements) {
    if (this.rollupExpirationMillis == elements) {
      return this;
    }
    ImmutableList<Long> newValue = ImmutableList.copyOf(elements);
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        newValue,
        this.gaugeCollectionIntervalMillis);
  }
  
  /**
   * Copy current immutable object by setting value for {@link LayoutBase#gaugeCollectionIntervalMillis() gaugeCollectionIntervalMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for gaugeCollectionIntervalMillis
   * @return modified copy of the {@code this} object
   */
  public final Layout withGaugeCollectionIntervalMillis(long value) {
    if (this.gaugeCollectionIntervalMillis == value) {
      return this;
    }
    long newValue = value;
    return new Layout(
        this.jvmHeapDump,
        this.footerMessage,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.transactionTypes,
        this.defaultTransactionType,
        this.defaultPercentiles,
        this.transactionCustomAttributes,
        this.rollupConfigs,
        this.rollupExpirationMillis,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code Layout} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof Layout && equalTo((Layout) another));
  }
  
  private boolean equalTo(Layout another) {
    return jvmHeapDump == another.jvmHeapDump
        && footerMessage.equals(another.footerMessage)
        && adminPasswordEnabled == another.adminPasswordEnabled
        && readOnlyPasswordEnabled == another.readOnlyPasswordEnabled
        && anonymousAccess.equals(another.anonymousAccess)
        && transactionTypes.equals(another.transactionTypes)
        && defaultTransactionType.equals(another.defaultTransactionType)
        && defaultPercentiles.equals(another.defaultPercentiles)
        && transactionCustomAttributes.equals(another.transactionCustomAttributes)
        && rollupConfigs.equals(another.rollupConfigs)
        && rollupExpirationMillis.equals(another.rollupExpirationMillis)
        && gaugeCollectionIntervalMillis == another.gaugeCollectionIntervalMillis
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code jvmHeapDump}, {@code footerMessage}, {@code adminPasswordEnabled}, {@code readOnlyPasswordEnabled}, {@code anonymousAccess}, {@code transactionTypes}, {@code defaultTransactionType}, {@code defaultPercentiles}, {@code transactionCustomAttributes}, {@code rollupConfigs}, {@code rollupExpirationMillis}, {@code gaugeCollectionIntervalMillis}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(jvmHeapDump);
    h = h * 17 + footerMessage.hashCode();
    h = h * 17 + Booleans.hashCode(adminPasswordEnabled);
    h = h * 17 + Booleans.hashCode(readOnlyPasswordEnabled);
    h = h * 17 + anonymousAccess.hashCode();
    h = h * 17 + transactionTypes.hashCode();
    h = h * 17 + defaultTransactionType.hashCode();
    h = h * 17 + defaultPercentiles.hashCode();
    h = h * 17 + transactionCustomAttributes.hashCode();
    h = h * 17 + rollupConfigs.hashCode();
    h = h * 17 + rollupExpirationMillis.hashCode();
    h = h * 17 + Longs.hashCode(gaugeCollectionIntervalMillis);
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Layout{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Layout")
        .add("jvmHeapDump", jvmHeapDump)
        .add("footerMessage", footerMessage)
        .add("adminPasswordEnabled", adminPasswordEnabled)
        .add("readOnlyPasswordEnabled", readOnlyPasswordEnabled)
        .add("anonymousAccess", anonymousAccess)
        .add("transactionTypes", transactionTypes)
        .add("defaultTransactionType", defaultTransactionType)
        .add("defaultPercentiles", defaultPercentiles)
        .add("transactionCustomAttributes", transactionCustomAttributes)
        .add("rollupConfigs", rollupConfigs)
        .add("rollupExpirationMillis", rollupExpirationMillis)
        .add("gaugeCollectionIntervalMillis", gaugeCollectionIntervalMillis)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static Layout fromAllAttributes(
      @JsonProperty("jvmHeapDump") @Nullable Boolean jvmHeapDump,
      @JsonProperty("footerMessage") @Nullable String footerMessage,
      @JsonProperty("adminPasswordEnabled") @Nullable Boolean adminPasswordEnabled,
      @JsonProperty("readOnlyPasswordEnabled") @Nullable Boolean readOnlyPasswordEnabled,
      @JsonProperty("anonymousAccess") @Nullable AnonymousAccess anonymousAccess,
      @JsonProperty("transactionTypes") @Nullable ImmutableList<String> transactionTypes,
      @JsonProperty("defaultTransactionType") @Nullable String defaultTransactionType,
      @JsonProperty("defaultPercentiles") @Nullable ImmutableList<Double> defaultPercentiles,
      @JsonProperty("transactionCustomAttributes") @Nullable ImmutableList<String> transactionCustomAttributes,
      @JsonProperty("rollupConfigs") @Nullable ImmutableList<RollupConfig> rollupConfigs,
      @JsonProperty("rollupExpirationMillis") @Nullable ImmutableList<Long> rollupExpirationMillis,
      @JsonProperty("gaugeCollectionIntervalMillis") @Nullable Long gaugeCollectionIntervalMillis) {
    Layout.Builder builder = Layout.builder();
    if (jvmHeapDump != null) {
      builder.jvmHeapDump(jvmHeapDump);
    }
    if (footerMessage != null) {
      builder.footerMessage(footerMessage);
    }
    if (adminPasswordEnabled != null) {
      builder.adminPasswordEnabled(adminPasswordEnabled);
    }
    if (readOnlyPasswordEnabled != null) {
      builder.readOnlyPasswordEnabled(readOnlyPasswordEnabled);
    }
    if (anonymousAccess != null) {
      builder.anonymousAccess(anonymousAccess);
    }
    if (transactionTypes != null) {
      builder.addAllTransactionTypes(transactionTypes);
    }
    if (defaultTransactionType != null) {
      builder.defaultTransactionType(defaultTransactionType);
    }
    if (defaultPercentiles != null) {
      builder.addAllDefaultPercentiles(defaultPercentiles);
    }
    if (transactionCustomAttributes != null) {
      builder.addAllTransactionCustomAttributes(transactionCustomAttributes);
    }
    if (rollupConfigs != null) {
      builder.addAllRollupConfigs(rollupConfigs);
    }
    if (rollupExpirationMillis != null) {
      builder.addAllRollupExpirationMillis(rollupExpirationMillis);
    }
    if (gaugeCollectionIntervalMillis != null) {
      builder.gaugeCollectionIntervalMillis(gaugeCollectionIntervalMillis);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link LayoutBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Layout instance
   */
  static Layout copyOf(LayoutBase instance) {
    if (instance instanceof Layout) {
      return (Layout) instance;
    }
    return Layout.builder()
        .jvmHeapDump(instance.jvmHeapDump())
        .footerMessage(instance.footerMessage())
        .adminPasswordEnabled(instance.adminPasswordEnabled())
        .readOnlyPasswordEnabled(instance.readOnlyPasswordEnabled())
        .anonymousAccess(instance.anonymousAccess())
        .addAllTransactionTypes(instance.transactionTypes())
        .defaultTransactionType(instance.defaultTransactionType())
        .addAllDefaultPercentiles(instance.defaultPercentiles())
        .addAllTransactionCustomAttributes(instance.transactionCustomAttributes())
        .addAllRollupConfigs(instance.rollupConfigs())
        .addAllRollupExpirationMillis(instance.rollupExpirationMillis())
        .gaugeCollectionIntervalMillis(instance.gaugeCollectionIntervalMillis())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.Layout}.
   * @return new Layout builder
   */
  static Layout.Builder builder() {
    return new Layout.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.Layout}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7f;
    private static final long INITIALIZED_BIT_JVM_HEAP_DUMP = 0x1L;
    private static final long INITIALIZED_BIT_FOOTER_MESSAGE = 0x2L;
    private static final long INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED = 0x4L;
    private static final long INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED = 0x8L;
    private static final long INITIALIZED_BIT_ANONYMOUS_ACCESS = 0x10L;
    private static final long INITIALIZED_BIT_DEFAULT_TRANSACTION_TYPE = 0x20L;
    private static final long INITIALIZED_BIT_GAUGE_COLLECTION_INTERVAL_MILLIS = 0x40L;
    private long initializedBitset;
  
    private boolean jvmHeapDump;
    private @Nullable String footerMessage;
    private boolean adminPasswordEnabled;
    private boolean readOnlyPasswordEnabled;
    private @Nullable AnonymousAccess anonymousAccess;
    private ImmutableList.Builder<String> transactionTypesBuilder = ImmutableList.builder();
    private @Nullable String defaultTransactionType;
    private ImmutableList.Builder<Double> defaultPercentilesBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> transactionCustomAttributesBuilder = ImmutableList.builder();
    private ImmutableList.Builder<RollupConfig> rollupConfigsBuilder = ImmutableList.builder();
    private ImmutableList.Builder<Long> rollupExpirationMillisBuilder = ImmutableList.builder();
    private long gaugeCollectionIntervalMillis;
    private Builder() {}
  
    /**
     * Initializes value for {@link LayoutBase#jvmHeapDump() jvmHeapDump}.
     * @param jvmHeapDump value for jvmHeapDump
     * @return {@code this} builder for chained invocation
     */
    public final Builder jvmHeapDump(boolean jvmHeapDump) {
      checkNotIsSet(jvmHeapDumpIsSet(), "jvmHeapDump");
      this.jvmHeapDump = jvmHeapDump;
      initializedBitset |= INITIALIZED_BIT_JVM_HEAP_DUMP;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#footerMessage() footerMessage}.
     * @param footerMessage value for footerMessage
     * @return {@code this} builder for chained invocation
     */
    public final Builder footerMessage(String footerMessage) {
      checkNotIsSet(footerMessageIsSet(), "footerMessage");
      this.footerMessage = Preconditions.checkNotNull(footerMessage);
      initializedBitset |= INITIALIZED_BIT_FOOTER_MESSAGE;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#adminPasswordEnabled() adminPasswordEnabled}.
     * @param adminPasswordEnabled value for adminPasswordEnabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder adminPasswordEnabled(boolean adminPasswordEnabled) {
      checkNotIsSet(adminPasswordEnabledIsSet(), "adminPasswordEnabled");
      this.adminPasswordEnabled = adminPasswordEnabled;
      initializedBitset |= INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#readOnlyPasswordEnabled() readOnlyPasswordEnabled}.
     * @param readOnlyPasswordEnabled value for readOnlyPasswordEnabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder readOnlyPasswordEnabled(boolean readOnlyPasswordEnabled) {
      checkNotIsSet(readOnlyPasswordEnabledIsSet(), "readOnlyPasswordEnabled");
      this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
      initializedBitset |= INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#anonymousAccess() anonymousAccess}.
     * @param anonymousAccess value for anonymousAccess
     * @return {@code this} builder for chained invocation
     */
    public final Builder anonymousAccess(AnonymousAccess anonymousAccess) {
      checkNotIsSet(anonymousAccessIsSet(), "anonymousAccess");
      this.anonymousAccess = Preconditions.checkNotNull(anonymousAccess);
      initializedBitset |= INITIALIZED_BIT_ANONYMOUS_ACCESS;
      return this;
    }
  
    /**
     * Adds one element to {@link LayoutBase#transactionTypes() transactionTypes} list.
     * @param element transactionTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionTypes(String element) {
      transactionTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#transactionTypes() transactionTypes} list.
     * @param elements array of transactionTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionTypes(String... elements) {
      transactionTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#transactionTypes() transactionTypes} list.
     * @param elements iterable of transactionTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTransactionTypes(Iterable<String> elements) {
      transactionTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#defaultTransactionType() defaultTransactionType}.
     * @param defaultTransactionType value for defaultTransactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultTransactionType(String defaultTransactionType) {
      checkNotIsSet(defaultTransactionTypeIsSet(), "defaultTransactionType");
      this.defaultTransactionType = Preconditions.checkNotNull(defaultTransactionType);
      initializedBitset |= INITIALIZED_BIT_DEFAULT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Adds one element to {@link LayoutBase#defaultPercentiles() defaultPercentiles} list.
     * @param element defaultPercentiles element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDefaultPercentiles(double element) {
      defaultPercentilesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#defaultPercentiles() defaultPercentiles} list.
     * @param elements array of defaultPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDefaultPercentiles(double... elements) {
      defaultPercentilesBuilder.addAll(Doubles.asList(elements));
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#defaultPercentiles() defaultPercentiles} list.
     * @param elements iterable of defaultPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllDefaultPercentiles(Iterable<Double> elements) {
      defaultPercentilesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param element transactionCustomAttributes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionCustomAttributes(String element) {
      transactionCustomAttributesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param elements array of transactionCustomAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionCustomAttributes(String... elements) {
      transactionCustomAttributesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param elements iterable of transactionCustomAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTransactionCustomAttributes(Iterable<String> elements) {
      transactionCustomAttributesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link LayoutBase#rollupConfigs() rollupConfigs} list.
     * @param element rollupConfigs element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addRollupConfigs(RollupConfig element) {
      rollupConfigsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#rollupConfigs() rollupConfigs} list.
     * @param elements array of rollupConfigs elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addRollupConfigs(RollupConfig... elements) {
      rollupConfigsBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#rollupConfigs() rollupConfigs} list.
     * @param elements iterable of rollupConfigs elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllRollupConfigs(Iterable<? extends RollupConfig> elements) {
      rollupConfigsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link LayoutBase#rollupExpirationMillis() rollupExpirationMillis} list.
     * @param element rollupExpirationMillis element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addRollupExpirationMillis(long element) {
      rollupExpirationMillisBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#rollupExpirationMillis() rollupExpirationMillis} list.
     * @param elements array of rollupExpirationMillis elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addRollupExpirationMillis(long... elements) {
      rollupExpirationMillisBuilder.addAll(Longs.asList(elements));
      return this;
    }
  
    /**
     * Adds elements to {@link LayoutBase#rollupExpirationMillis() rollupExpirationMillis} list.
     * @param elements iterable of rollupExpirationMillis elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllRollupExpirationMillis(Iterable<Long> elements) {
      rollupExpirationMillisBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link LayoutBase#gaugeCollectionIntervalMillis() gaugeCollectionIntervalMillis}.
     * @param gaugeCollectionIntervalMillis value for gaugeCollectionIntervalMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder gaugeCollectionIntervalMillis(long gaugeCollectionIntervalMillis) {
      checkNotIsSet(gaugeCollectionIntervalMillisIsSet(), "gaugeCollectionIntervalMillis");
      this.gaugeCollectionIntervalMillis = gaugeCollectionIntervalMillis;
      initializedBitset |= INITIALIZED_BIT_GAUGE_COLLECTION_INTERVAL_MILLIS;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.Layout}.
     * @return immutable instance of Layout
     */
    public org.glowroot.local.ui.Layout build() {
      checkRequiredAttributes();
      return new Layout(
        jvmHeapDump,
        footerMessage,
        adminPasswordEnabled,
        readOnlyPasswordEnabled,
        anonymousAccess,
        transactionTypesBuilder.build(),
        defaultTransactionType,
        defaultPercentilesBuilder.build(),
        transactionCustomAttributesBuilder.build(),
        rollupConfigsBuilder.build(),
        rollupExpirationMillisBuilder.build(),
        gaugeCollectionIntervalMillis);
    }
  
    private boolean jvmHeapDumpIsSet() {
      return (initializedBitset & INITIALIZED_BIT_JVM_HEAP_DUMP) != 0;
    }
  
    private boolean footerMessageIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FOOTER_MESSAGE) != 0;
    }
  
    private boolean adminPasswordEnabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED) != 0;
    }
  
    private boolean readOnlyPasswordEnabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED) != 0;
    }
  
    private boolean anonymousAccessIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ANONYMOUS_ACCESS) != 0;
    }
  
    private boolean defaultTransactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DEFAULT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean gaugeCollectionIntervalMillisIsSet() {
      return (initializedBitset & INITIALIZED_BIT_GAUGE_COLLECTION_INTERVAL_MILLIS) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of Layout is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!jvmHeapDumpIsSet()) {
        attributes.add("jvmHeapDump");
      }
      if (!footerMessageIsSet()) {
        attributes.add("footerMessage");
      }
      if (!adminPasswordEnabledIsSet()) {
        attributes.add("adminPasswordEnabled");
      }
      if (!readOnlyPasswordEnabledIsSet()) {
        attributes.add("readOnlyPasswordEnabled");
      }
      if (!anonymousAccessIsSet()) {
        attributes.add("anonymousAccess");
      }
      if (!defaultTransactionTypeIsSet()) {
        attributes.add("defaultTransactionType");
      }
      if (!gaugeCollectionIntervalMillisIsSet()) {
        attributes.add("gaugeCollectionIntervalMillis");
      }
      return "Cannot build Layout, some of required attributes are not set " + attributes;
    }
  }
}
