package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GaugeJsonService.MBeanAttributeNamesRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MBeanAttributeNamesRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugeJsonService.MBeanAttributeNamesRequestBase"})
@Immutable
final class MBeanAttributeNamesRequest
    extends GaugeJsonService.MBeanAttributeNamesRequestBase {
  private final String mbeanObjectName;
  private final @Nullable String gaugeVersion;

  private MBeanAttributeNamesRequest(String mbeanObjectName, @Nullable String gaugeVersion) {
    this.mbeanObjectName = mbeanObjectName;
    this.gaugeVersion = gaugeVersion;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanObjectName} attribute
   */
  @JsonProperty("mbeanObjectName")
  @Override
  public String mbeanObjectName() {
    return mbeanObjectName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code gaugeVersion} attribute
   */
  @JsonProperty("gaugeVersion")
  @Override
  public String gaugeVersion() {
    return gaugeVersion;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.MBeanAttributeNamesRequestBase#mbeanObjectName() mbeanObjectName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for mbeanObjectName
   * @return modified copy of the {@code this} object
   */
  public final MBeanAttributeNamesRequest withMbeanObjectName(String value) {
    if (this.mbeanObjectName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MBeanAttributeNamesRequest(newValue, this.gaugeVersion);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.MBeanAttributeNamesRequestBase#gaugeVersion() gaugeVersion}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for gaugeVersion, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final MBeanAttributeNamesRequest withGaugeVersion(@Nullable String value) {
    if (this.gaugeVersion == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new MBeanAttributeNamesRequest(this.mbeanObjectName, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MBeanAttributeNamesRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MBeanAttributeNamesRequest && equalTo((MBeanAttributeNamesRequest) another));
  }
  
  private boolean equalTo(MBeanAttributeNamesRequest another) {
    return mbeanObjectName.equals(another.mbeanObjectName)
        && Objects.equal(gaugeVersion, another.gaugeVersion);
  }
  
  /**
   * Computes hash code from attributes: {@code mbeanObjectName}, {@code gaugeVersion}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + mbeanObjectName.hashCode();
    h = h * 17 + Objects.hashCode(gaugeVersion);
    return h;
  }
  
  /**
   * Prints immutable value {@code MBeanAttributeNamesRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MBeanAttributeNamesRequest")
        .add("mbeanObjectName", mbeanObjectName)
        .add("gaugeVersion", gaugeVersion)
        .toString();
  }
  
  @JsonCreator
  public static MBeanAttributeNamesRequest fromAllAttributes(
      @JsonProperty("mbeanObjectName") @Nullable String mbeanObjectName,
      @JsonProperty("gaugeVersion") @Nullable String gaugeVersion) {
    MBeanAttributeNamesRequest.Builder builder = MBeanAttributeNamesRequest.builder();
    if (mbeanObjectName != null) {
      builder.mbeanObjectName(mbeanObjectName);
    }
    if (gaugeVersion != null) {
      builder.gaugeVersion(gaugeVersion);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link GaugeJsonService.MBeanAttributeNamesRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MBeanAttributeNamesRequest instance
   */
  static MBeanAttributeNamesRequest copyOf(GaugeJsonService.MBeanAttributeNamesRequestBase instance) {
    if (instance instanceof MBeanAttributeNamesRequest) {
      return (MBeanAttributeNamesRequest) instance;
    }
    return MBeanAttributeNamesRequest.builder()
        .mbeanObjectName(instance.mbeanObjectName())
        .gaugeVersion(instance.gaugeVersion())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.MBeanAttributeNamesRequest}.
   * @return new MBeanAttributeNamesRequest builder
   */
  static MBeanAttributeNamesRequest.Builder builder() {
    return new MBeanAttributeNamesRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.MBeanAttributeNamesRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_MBEAN_OBJECT_NAME = 0x1L;
    private static final long NONDEFAULT_BIT_GAUGE_VERSION = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String mbeanObjectName;
    private @Nullable String gaugeVersion;
    private Builder() {}
  
    /**
     * Initializes value for {@link GaugeJsonService.MBeanAttributeNamesRequestBase#mbeanObjectName() mbeanObjectName}.
     * @param mbeanObjectName value for mbeanObjectName
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanObjectName(String mbeanObjectName) {
      checkNotIsSet(mbeanObjectNameIsSet(), "mbeanObjectName");
      this.mbeanObjectName = Preconditions.checkNotNull(mbeanObjectName);
      initializedBitset |= INITIALIZED_BIT_MBEAN_OBJECT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.MBeanAttributeNamesRequestBase#gaugeVersion() gaugeVersion}.
     * @param gaugeVersion value for gaugeVersion, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder gaugeVersion(@Nullable String gaugeVersion) {
      checkNotIsSet(gaugeVersionIsSet(), "gaugeVersion");
      this.gaugeVersion = gaugeVersion;
      nondefaultBitset |= NONDEFAULT_BIT_GAUGE_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.MBeanAttributeNamesRequest}.
     * @return immutable instance of MBeanAttributeNamesRequest
     */
    public org.glowroot.local.ui.MBeanAttributeNamesRequest build() {
      checkRequiredAttributes();
      return new MBeanAttributeNamesRequest(mbeanObjectName, gaugeVersion);
    }
  
    private boolean gaugeVersionIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_GAUGE_VERSION) != 0;
    }
  
    private boolean mbeanObjectNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MBEAN_OBJECT_NAME) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of MBeanAttributeNamesRequest is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!mbeanObjectNameIsSet()) {
        attributes.add("mbeanObjectName");
      }
      return "Cannot build MBeanAttributeNamesRequest, some of required attributes are not set " + attributes;
    }
  }
}
