package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Ints;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.StorageConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code StorageConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.StorageConfigDtoBase"})
@Immutable
final class StorageConfigDto extends ConfigJsonService.StorageConfigDtoBase {
  private final ImmutableList<Integer> rollupExpirationHours;
  private final int traceExpirationHours;
  private final ImmutableList<Integer> rollupCappedDatabaseSizesMb;
  private final int traceCappedDatabaseSizeMb;
  private final String version;

  private StorageConfigDto(
      ImmutableList<Integer> rollupExpirationHours,
      int traceExpirationHours,
      ImmutableList<Integer> rollupCappedDatabaseSizesMb,
      int traceCappedDatabaseSizeMb,
      String version) {
    this.rollupExpirationHours = rollupExpirationHours;
    this.traceExpirationHours = traceExpirationHours;
    this.rollupCappedDatabaseSizesMb = rollupCappedDatabaseSizesMb;
    this.traceCappedDatabaseSizeMb = traceCappedDatabaseSizeMb;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rollupExpirationHours} attribute
   */
  @JsonProperty("rollupExpirationHours")
  @Override
  public ImmutableList<Integer> rollupExpirationHours() {
    return rollupExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceExpirationHours} attribute
   */
  @JsonProperty("traceExpirationHours")
  @Override
  public int traceExpirationHours() {
    return traceExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code rollupCappedDatabaseSizesMb} attribute
   */
  @JsonProperty("rollupCappedDatabaseSizesMb")
  @Override
  public ImmutableList<Integer> rollupCappedDatabaseSizesMb() {
    return rollupCappedDatabaseSizesMb;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceCappedDatabaseSizeMb} attribute
   */
  @JsonProperty("traceCappedDatabaseSizeMb")
  @Override
  public int traceCappedDatabaseSizeMb() {
    return traceCappedDatabaseSizeMb;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.StorageConfigDtoBase#rollupExpirationHours() rollupExpirationHours}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final StorageConfigDto withRollupExpirationHours(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new StorageConfigDto(
        newValue,
        this.traceExpirationHours,
        this.rollupCappedDatabaseSizesMb,
        this.traceCappedDatabaseSizeMb,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.StorageConfigDtoBase#rollupExpirationHours() rollupExpirationHours}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of rollupExpirationHours elements to set
   * @return modified copy of {@code this} object
   */
  public final StorageConfigDto withRollupExpirationHours(Iterable<Integer> elements) {
    if (this.rollupExpirationHours == elements) {
      return this;
    }
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new StorageConfigDto(
        newValue,
        this.traceExpirationHours,
        this.rollupCappedDatabaseSizesMb,
        this.traceCappedDatabaseSizeMb,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.StorageConfigDtoBase#traceExpirationHours() traceExpirationHours}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceExpirationHours
   * @return modified copy of the {@code this} object
   */
  public final StorageConfigDto withTraceExpirationHours(int value) {
    if (this.traceExpirationHours == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfigDto(
        this.rollupExpirationHours,
        newValue,
        this.rollupCappedDatabaseSizesMb,
        this.traceCappedDatabaseSizeMb,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.StorageConfigDtoBase#rollupCappedDatabaseSizesMb() rollupCappedDatabaseSizesMb}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final StorageConfigDto withRollupCappedDatabaseSizesMb(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new StorageConfigDto(
        this.rollupExpirationHours,
        this.traceExpirationHours,
        newValue,
        this.traceCappedDatabaseSizeMb,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.StorageConfigDtoBase#rollupCappedDatabaseSizesMb() rollupCappedDatabaseSizesMb}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of rollupCappedDatabaseSizesMb elements to set
   * @return modified copy of {@code this} object
   */
  public final StorageConfigDto withRollupCappedDatabaseSizesMb(Iterable<Integer> elements) {
    if (this.rollupCappedDatabaseSizesMb == elements) {
      return this;
    }
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new StorageConfigDto(
        this.rollupExpirationHours,
        this.traceExpirationHours,
        newValue,
        this.traceCappedDatabaseSizeMb,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.StorageConfigDtoBase#traceCappedDatabaseSizeMb() traceCappedDatabaseSizeMb}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceCappedDatabaseSizeMb
   * @return modified copy of the {@code this} object
   */
  public final StorageConfigDto withTraceCappedDatabaseSizeMb(int value) {
    if (this.traceCappedDatabaseSizeMb == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfigDto(
        this.rollupExpirationHours,
        this.traceExpirationHours,
        this.rollupCappedDatabaseSizesMb,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.StorageConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final StorageConfigDto withVersion(String value) {
    if (this.version == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new StorageConfigDto(
        this.rollupExpirationHours,
        this.traceExpirationHours,
        this.rollupCappedDatabaseSizesMb,
        this.traceCappedDatabaseSizeMb,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code StorageConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof StorageConfigDto && equalTo((StorageConfigDto) another));
  }
  
  private boolean equalTo(StorageConfigDto another) {
    return rollupExpirationHours.equals(another.rollupExpirationHours)
        && traceExpirationHours == another.traceExpirationHours
        && rollupCappedDatabaseSizesMb.equals(another.rollupCappedDatabaseSizesMb)
        && traceCappedDatabaseSizeMb == another.traceCappedDatabaseSizeMb
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code rollupExpirationHours}, {@code traceExpirationHours}, {@code rollupCappedDatabaseSizesMb}, {@code traceCappedDatabaseSizeMb}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + rollupExpirationHours.hashCode();
    h = h * 17 + traceExpirationHours;
    h = h * 17 + rollupCappedDatabaseSizesMb.hashCode();
    h = h * 17 + traceCappedDatabaseSizeMb;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code StorageConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StorageConfigDto")
        .add("rollupExpirationHours", rollupExpirationHours)
        .add("traceExpirationHours", traceExpirationHours)
        .add("rollupCappedDatabaseSizesMb", rollupCappedDatabaseSizesMb)
        .add("traceCappedDatabaseSizeMb", traceCappedDatabaseSizeMb)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static StorageConfigDto fromAllAttributes(
      @JsonProperty("rollupExpirationHours") @Nullable ImmutableList<Integer> rollupExpirationHours,
      @JsonProperty("traceExpirationHours") @Nullable Integer traceExpirationHours,
      @JsonProperty("rollupCappedDatabaseSizesMb") @Nullable ImmutableList<Integer> rollupCappedDatabaseSizesMb,
      @JsonProperty("traceCappedDatabaseSizeMb") @Nullable Integer traceCappedDatabaseSizeMb,
      @JsonProperty("version") @Nullable String version) {
    StorageConfigDto.Builder builder = StorageConfigDto.builder();
    if (rollupExpirationHours != null) {
      builder.addAllRollupExpirationHours(rollupExpirationHours);
    }
    if (traceExpirationHours != null) {
      builder.traceExpirationHours(traceExpirationHours);
    }
    if (rollupCappedDatabaseSizesMb != null) {
      builder.addAllRollupCappedDatabaseSizesMb(rollupCappedDatabaseSizesMb);
    }
    if (traceCappedDatabaseSizeMb != null) {
      builder.traceCappedDatabaseSizeMb(traceCappedDatabaseSizeMb);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.StorageConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable StorageConfigDto instance
   */
  static StorageConfigDto copyOf(ConfigJsonService.StorageConfigDtoBase instance) {
    if (instance instanceof StorageConfigDto) {
      return (StorageConfigDto) instance;
    }
    return StorageConfigDto.builder()
        .addAllRollupExpirationHours(instance.rollupExpirationHours())
        .traceExpirationHours(instance.traceExpirationHours())
        .addAllRollupCappedDatabaseSizesMb(instance.rollupCappedDatabaseSizesMb())
        .traceCappedDatabaseSizeMb(instance.traceCappedDatabaseSizeMb())
        .version(instance.version())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.StorageConfigDto}.
   * @return new StorageConfigDto builder
   */
  static StorageConfigDto.Builder builder() {
    return new StorageConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.StorageConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_TRACE_EXPIRATION_HOURS = 0x1L;
    private static final long INITIALIZED_BIT_TRACE_CAPPED_DATABASE_SIZE_MB = 0x2L;
    private static final long INITIALIZED_BIT_VERSION = 0x4L;
    private long initializedBitset;
  
    private ImmutableList.Builder<Integer> rollupExpirationHoursBuilder = ImmutableList.builder();
    private int traceExpirationHours;
    private ImmutableList.Builder<Integer> rollupCappedDatabaseSizesMbBuilder = ImmutableList.builder();
    private int traceCappedDatabaseSizeMb;
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Adds one element to {@link ConfigJsonService.StorageConfigDtoBase#rollupExpirationHours() rollupExpirationHours} list.
     * @param element rollupExpirationHours element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addRollupExpirationHours(int element) {
      rollupExpirationHoursBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.StorageConfigDtoBase#rollupExpirationHours() rollupExpirationHours} list.
     * @param elements array of rollupExpirationHours elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addRollupExpirationHours(int... elements) {
      rollupExpirationHoursBuilder.addAll(Ints.asList(elements));
      return this;
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.StorageConfigDtoBase#rollupExpirationHours() rollupExpirationHours} list.
     * @param elements iterable of rollupExpirationHours elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllRollupExpirationHours(Iterable<Integer> elements) {
      rollupExpirationHoursBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.StorageConfigDtoBase#traceExpirationHours() traceExpirationHours}.
     * @param traceExpirationHours value for traceExpirationHours
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceExpirationHours(int traceExpirationHours) {
      checkNotIsSet(traceExpirationHoursIsSet(), "traceExpirationHours");
      this.traceExpirationHours = traceExpirationHours;
      initializedBitset |= INITIALIZED_BIT_TRACE_EXPIRATION_HOURS;
      return this;
    }
  
    /**
     * Adds one element to {@link ConfigJsonService.StorageConfigDtoBase#rollupCappedDatabaseSizesMb() rollupCappedDatabaseSizesMb} list.
     * @param element rollupCappedDatabaseSizesMb element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addRollupCappedDatabaseSizesMb(int element) {
      rollupCappedDatabaseSizesMbBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.StorageConfigDtoBase#rollupCappedDatabaseSizesMb() rollupCappedDatabaseSizesMb} list.
     * @param elements array of rollupCappedDatabaseSizesMb elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addRollupCappedDatabaseSizesMb(int... elements) {
      rollupCappedDatabaseSizesMbBuilder.addAll(Ints.asList(elements));
      return this;
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.StorageConfigDtoBase#rollupCappedDatabaseSizesMb() rollupCappedDatabaseSizesMb} list.
     * @param elements iterable of rollupCappedDatabaseSizesMb elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllRollupCappedDatabaseSizesMb(Iterable<Integer> elements) {
      rollupCappedDatabaseSizesMbBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.StorageConfigDtoBase#traceCappedDatabaseSizeMb() traceCappedDatabaseSizeMb}.
     * @param traceCappedDatabaseSizeMb value for traceCappedDatabaseSizeMb
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceCappedDatabaseSizeMb(int traceCappedDatabaseSizeMb) {
      checkNotIsSet(traceCappedDatabaseSizeMbIsSet(), "traceCappedDatabaseSizeMb");
      this.traceCappedDatabaseSizeMb = traceCappedDatabaseSizeMb;
      initializedBitset |= INITIALIZED_BIT_TRACE_CAPPED_DATABASE_SIZE_MB;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.StorageConfigDtoBase#version() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(String version) {
      checkNotIsSet(versionIsSet(), "version");
      this.version = Preconditions.checkNotNull(version);
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.StorageConfigDto}.
     * @return immutable instance of StorageConfigDto
     */
    public org.glowroot.local.ui.StorageConfigDto build() {
      checkRequiredAttributes();
      return new StorageConfigDto(
        rollupExpirationHoursBuilder.build(),
        traceExpirationHours,
        rollupCappedDatabaseSizesMbBuilder.build(),
        traceCappedDatabaseSizeMb,
        version);
    }
  
    private boolean traceExpirationHoursIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRACE_EXPIRATION_HOURS) != 0;
    }
  
    private boolean traceCappedDatabaseSizeMbIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRACE_CAPPED_DATABASE_SIZE_MB) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of StorageConfigDto is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!traceExpirationHoursIsSet()) {
        attributes.add("traceExpirationHours");
      }
      if (!traceCappedDatabaseSizeMbIsSet()) {
        attributes.add("traceCappedDatabaseSizeMb");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      return "Cannot build StorageConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
