package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AggregateMerging.ThreadInfoAggregateBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ThreadInfoAggregate.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AggregateMerging.ThreadInfoAggregateBase"})
@Immutable
public final class ThreadInfoAggregate extends AggregateMerging.ThreadInfoAggregateBase {
  private final @Nullable Long totalCpuMicros;
  private final @Nullable Long totalBlockedMicros;
  private final @Nullable Long totalWaitedMicros;
  private final @Nullable Long totalAllocatedKBytes;

  private ThreadInfoAggregate(
      @Nullable Long totalCpuMicros,
      @Nullable Long totalBlockedMicros,
      @Nullable Long totalWaitedMicros,
      @Nullable Long totalAllocatedKBytes) {
    this.totalCpuMicros = totalCpuMicros;
    this.totalBlockedMicros = totalBlockedMicros;
    this.totalWaitedMicros = totalWaitedMicros;
    this.totalAllocatedKBytes = totalAllocatedKBytes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalCpuMicros} attribute
   */
  @JsonProperty("totalCpuMicros")
  @Override
  public Long totalCpuMicros() {
    return totalCpuMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalBlockedMicros} attribute
   */
  @JsonProperty("totalBlockedMicros")
  @Override
  public Long totalBlockedMicros() {
    return totalBlockedMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalWaitedMicros} attribute
   */
  @JsonProperty("totalWaitedMicros")
  @Override
  public Long totalWaitedMicros() {
    return totalWaitedMicros;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code totalAllocatedKBytes} attribute
   */
  @JsonProperty("totalAllocatedKBytes")
  @Override
  public Long totalAllocatedKBytes() {
    return totalAllocatedKBytes;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.ThreadInfoAggregateBase#totalCpuMicros() totalCpuMicros}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalCpuMicros, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoAggregate withTotalCpuMicros(@Nullable Long value) {
    if (this.totalCpuMicros == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoAggregate(newValue, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.ThreadInfoAggregateBase#totalBlockedMicros() totalBlockedMicros}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalBlockedMicros, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoAggregate withTotalBlockedMicros(@Nullable Long value) {
    if (this.totalBlockedMicros == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoAggregate(this.totalCpuMicros, newValue, this.totalWaitedMicros, this.totalAllocatedKBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.ThreadInfoAggregateBase#totalWaitedMicros() totalWaitedMicros}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalWaitedMicros, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoAggregate withTotalWaitedMicros(@Nullable Long value) {
    if (this.totalWaitedMicros == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoAggregate(this.totalCpuMicros, this.totalBlockedMicros, newValue, this.totalAllocatedKBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AggregateMerging.ThreadInfoAggregateBase#totalAllocatedKBytes() totalAllocatedKBytes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for totalAllocatedKBytes, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoAggregate withTotalAllocatedKBytes(@Nullable Long value) {
    if (this.totalAllocatedKBytes == value) {
      return this;
    }
    @Nullable Long newValue = value;
    return new ThreadInfoAggregate(this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ThreadInfoAggregate} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ThreadInfoAggregate && equalTo((ThreadInfoAggregate) another));
  }
  
  private boolean equalTo(ThreadInfoAggregate another) {
    return Objects.equal(totalCpuMicros, another.totalCpuMicros)
        && Objects.equal(totalBlockedMicros, another.totalBlockedMicros)
        && Objects.equal(totalWaitedMicros, another.totalWaitedMicros)
        && Objects.equal(totalAllocatedKBytes, another.totalAllocatedKBytes);
  }
  
  /**
   * Computes hash code from attributes: {@code totalCpuMicros}, {@code totalBlockedMicros}, {@code totalWaitedMicros}, {@code totalAllocatedKBytes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(totalCpuMicros);
    h = h * 17 + Objects.hashCode(totalBlockedMicros);
    h = h * 17 + Objects.hashCode(totalWaitedMicros);
    h = h * 17 + Objects.hashCode(totalAllocatedKBytes);
    return h;
  }
  
  /**
   * Prints immutable value {@code ThreadInfoAggregate{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThreadInfoAggregate")
        .add("totalCpuMicros", totalCpuMicros)
        .add("totalBlockedMicros", totalBlockedMicros)
        .add("totalWaitedMicros", totalWaitedMicros)
        .add("totalAllocatedKBytes", totalAllocatedKBytes)
        .toString();
  }
  
  @JsonCreator
  public static ThreadInfoAggregate fromAllAttributes(
      @JsonProperty("totalCpuMicros") @Nullable Long totalCpuMicros,
      @JsonProperty("totalBlockedMicros") @Nullable Long totalBlockedMicros,
      @JsonProperty("totalWaitedMicros") @Nullable Long totalWaitedMicros,
      @JsonProperty("totalAllocatedKBytes") @Nullable Long totalAllocatedKBytes) {
    ThreadInfoAggregate.Builder builder = ThreadInfoAggregate.builder();
    if (totalCpuMicros != null) {
      builder.totalCpuMicros(totalCpuMicros);
    }
    if (totalBlockedMicros != null) {
      builder.totalBlockedMicros(totalBlockedMicros);
    }
    if (totalWaitedMicros != null) {
      builder.totalWaitedMicros(totalWaitedMicros);
    }
    if (totalAllocatedKBytes != null) {
      builder.totalAllocatedKBytes(totalAllocatedKBytes);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link AggregateMerging.ThreadInfoAggregateBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ThreadInfoAggregate instance
   */
  public static ThreadInfoAggregate copyOf(AggregateMerging.ThreadInfoAggregateBase instance) {
    if (instance instanceof ThreadInfoAggregate) {
      return (ThreadInfoAggregate) instance;
    }
    return ThreadInfoAggregate.builder()
        .totalCpuMicros(instance.totalCpuMicros())
        .totalBlockedMicros(instance.totalBlockedMicros())
        .totalWaitedMicros(instance.totalWaitedMicros())
        .totalAllocatedKBytes(instance.totalAllocatedKBytes())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.ThreadInfoAggregate}.
   * @return new ThreadInfoAggregate builder
   */
  public static ThreadInfoAggregate.Builder builder() {
    return new ThreadInfoAggregate.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.ThreadInfoAggregate}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_TOTAL_CPU_MICROS = 0x1L;
    private static final long NONDEFAULT_BIT_TOTAL_BLOCKED_MICROS = 0x2L;
    private static final long NONDEFAULT_BIT_TOTAL_WAITED_MICROS = 0x4L;
    private static final long NONDEFAULT_BIT_TOTAL_ALLOCATED_K_BYTES = 0x8L;
    private long nondefaultBitset;
  
    private @Nullable Long totalCpuMicros;
    private @Nullable Long totalBlockedMicros;
    private @Nullable Long totalWaitedMicros;
    private @Nullable Long totalAllocatedKBytes;
    private Builder() {}
  
    /**
     * Initializes value for {@link AggregateMerging.ThreadInfoAggregateBase#totalCpuMicros() totalCpuMicros}.
     * @param totalCpuMicros value for totalCpuMicros, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalCpuMicros(@Nullable Long totalCpuMicros) {
      checkNotIsSet(totalCpuMicrosIsSet(), "totalCpuMicros");
      this.totalCpuMicros = totalCpuMicros;
      nondefaultBitset |= NONDEFAULT_BIT_TOTAL_CPU_MICROS;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.ThreadInfoAggregateBase#totalBlockedMicros() totalBlockedMicros}.
     * @param totalBlockedMicros value for totalBlockedMicros, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalBlockedMicros(@Nullable Long totalBlockedMicros) {
      checkNotIsSet(totalBlockedMicrosIsSet(), "totalBlockedMicros");
      this.totalBlockedMicros = totalBlockedMicros;
      nondefaultBitset |= NONDEFAULT_BIT_TOTAL_BLOCKED_MICROS;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.ThreadInfoAggregateBase#totalWaitedMicros() totalWaitedMicros}.
     * @param totalWaitedMicros value for totalWaitedMicros, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalWaitedMicros(@Nullable Long totalWaitedMicros) {
      checkNotIsSet(totalWaitedMicrosIsSet(), "totalWaitedMicros");
      this.totalWaitedMicros = totalWaitedMicros;
      nondefaultBitset |= NONDEFAULT_BIT_TOTAL_WAITED_MICROS;
      return this;
    }
  
    /**
     * Initializes value for {@link AggregateMerging.ThreadInfoAggregateBase#totalAllocatedKBytes() totalAllocatedKBytes}.
     * @param totalAllocatedKBytes value for totalAllocatedKBytes, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder totalAllocatedKBytes(@Nullable Long totalAllocatedKBytes) {
      checkNotIsSet(totalAllocatedKBytesIsSet(), "totalAllocatedKBytes");
      this.totalAllocatedKBytes = totalAllocatedKBytes;
      nondefaultBitset |= NONDEFAULT_BIT_TOTAL_ALLOCATED_K_BYTES;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.ThreadInfoAggregate}.
     * @return immutable instance of ThreadInfoAggregate
     */
    public ThreadInfoAggregate build() {
      return new ThreadInfoAggregate(totalCpuMicros, totalBlockedMicros, totalWaitedMicros, totalAllocatedKBytes);
    }
  
    private boolean totalCpuMicrosIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TOTAL_CPU_MICROS) != 0;
    }
  
    private boolean totalBlockedMicrosIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TOTAL_BLOCKED_MICROS) != 0;
    }
  
    private boolean totalWaitedMicrosIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TOTAL_WAITED_MICROS) != 0;
    }
  
    private boolean totalAllocatedKBytesIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TOTAL_ALLOCATED_K_BYTES) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ThreadInfoAggregate is strict, attribute is already set: ".concat(name));
      }
    }
  }
}
