package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConfigJsonService.TransactionConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code TransactionConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.TransactionConfigDtoBase"})
@Immutable
final class TransactionConfigDto
    extends ConfigJsonService.TransactionConfigDtoBase {
  private final int slowThresholdMillis;
  private final int profilingIntervalMillis;
  private final String defaultDisplayedTransactionType;
  private final ImmutableList<Double> defaultDisplayedPercentiles;
  private final String version;

  private TransactionConfigDto(
      int slowThresholdMillis,
      int profilingIntervalMillis,
      String defaultDisplayedTransactionType,
      ImmutableList<Double> defaultDisplayedPercentiles,
      String version) {
    this.slowThresholdMillis = slowThresholdMillis;
    this.profilingIntervalMillis = profilingIntervalMillis;
    this.defaultDisplayedTransactionType = defaultDisplayedTransactionType;
    this.defaultDisplayedPercentiles = defaultDisplayedPercentiles;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code slowThresholdMillis} attribute
   */
  @JsonProperty("slowThresholdMillis")
  @Override
  public int slowThresholdMillis() {
    return slowThresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code profilingIntervalMillis} attribute
   */
  @JsonProperty("profilingIntervalMillis")
  @Override
  public int profilingIntervalMillis() {
    return profilingIntervalMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultDisplayedTransactionType} attribute
   */
  @JsonProperty("defaultDisplayedTransactionType")
  @Override
  public String defaultDisplayedTransactionType() {
    return defaultDisplayedTransactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultDisplayedPercentiles} attribute
   */
  @JsonProperty("defaultDisplayedPercentiles")
  @Override
  public ImmutableList<Double> defaultDisplayedPercentiles() {
    return defaultDisplayedPercentiles;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.TransactionConfigDtoBase#slowThresholdMillis() slowThresholdMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for slowThresholdMillis
   * @return modified copy of the {@code this} object
   */
  public final TransactionConfigDto withSlowThresholdMillis(int value) {
    if (this.slowThresholdMillis == value) {
      return this;
    }
    int newValue = value;
    return new TransactionConfigDto(
        newValue,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.TransactionConfigDtoBase#profilingIntervalMillis() profilingIntervalMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for profilingIntervalMillis
   * @return modified copy of the {@code this} object
   */
  public final TransactionConfigDto withProfilingIntervalMillis(int value) {
    if (this.profilingIntervalMillis == value) {
      return this;
    }
    int newValue = value;
    return new TransactionConfigDto(
        this.slowThresholdMillis,
        newValue,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.TransactionConfigDtoBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for defaultDisplayedTransactionType
   * @return modified copy of the {@code this} object
   */
  public final TransactionConfigDto withDefaultDisplayedTransactionType(String value) {
    if (this.defaultDisplayedTransactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new TransactionConfigDto(
        this.slowThresholdMillis,
        this.profilingIntervalMillis,
        newValue,
        this.defaultDisplayedPercentiles,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.TransactionConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final TransactionConfigDto withDefaultDisplayedPercentiles(double... elements) {
    ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
    return new TransactionConfigDto(
        this.slowThresholdMillis,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ConfigJsonService.TransactionConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of defaultDisplayedPercentiles elements to set
   * @return modified copy of {@code this} object
   */
  public final TransactionConfigDto withDefaultDisplayedPercentiles(Iterable<Double> elements) {
    if (this.defaultDisplayedPercentiles == elements) {
      return this;
    }
    ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
    return new TransactionConfigDto(
        this.slowThresholdMillis,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.TransactionConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final TransactionConfigDto withVersion(String value) {
    if (this.version == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new TransactionConfigDto(
        this.slowThresholdMillis,
        this.profilingIntervalMillis,
        this.defaultDisplayedTransactionType,
        this.defaultDisplayedPercentiles,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code TransactionConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof TransactionConfigDto && equalTo((TransactionConfigDto) another));
  }
  
  private boolean equalTo(TransactionConfigDto another) {
    return slowThresholdMillis == another.slowThresholdMillis
        && profilingIntervalMillis == another.profilingIntervalMillis
        && defaultDisplayedTransactionType.equals(another.defaultDisplayedTransactionType)
        && defaultDisplayedPercentiles.equals(another.defaultDisplayedPercentiles)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code slowThresholdMillis}, {@code profilingIntervalMillis}, {@code defaultDisplayedTransactionType}, {@code defaultDisplayedPercentiles}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + slowThresholdMillis;
    h = h * 17 + profilingIntervalMillis;
    h = h * 17 + defaultDisplayedTransactionType.hashCode();
    h = h * 17 + defaultDisplayedPercentiles.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code TransactionConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransactionConfigDto")
        .add("slowThresholdMillis", slowThresholdMillis)
        .add("profilingIntervalMillis", profilingIntervalMillis)
        .add("defaultDisplayedTransactionType", defaultDisplayedTransactionType)
        .add("defaultDisplayedPercentiles", defaultDisplayedPercentiles)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static TransactionConfigDto fromAllAttributes(
      @JsonProperty("slowThresholdMillis") @Nullable Integer slowThresholdMillis,
      @JsonProperty("profilingIntervalMillis") @Nullable Integer profilingIntervalMillis,
      @JsonProperty("defaultDisplayedTransactionType") @Nullable String defaultDisplayedTransactionType,
      @JsonProperty("defaultDisplayedPercentiles") @Nullable ImmutableList<Double> defaultDisplayedPercentiles,
      @JsonProperty("version") @Nullable String version) {
    TransactionConfigDto.Builder builder = TransactionConfigDto.builder();
    if (slowThresholdMillis != null) {
      builder.slowThresholdMillis(slowThresholdMillis);
    }
    if (profilingIntervalMillis != null) {
      builder.profilingIntervalMillis(profilingIntervalMillis);
    }
    if (defaultDisplayedTransactionType != null) {
      builder.defaultDisplayedTransactionType(defaultDisplayedTransactionType);
    }
    if (defaultDisplayedPercentiles != null) {
      builder.addAllDefaultDisplayedPercentiles(defaultDisplayedPercentiles);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.TransactionConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable TransactionConfigDto instance
   */
  static TransactionConfigDto copyOf(ConfigJsonService.TransactionConfigDtoBase instance) {
    if (instance instanceof TransactionConfigDto) {
      return (TransactionConfigDto) instance;
    }
    return TransactionConfigDto.builder()
        .slowThresholdMillis(instance.slowThresholdMillis())
        .profilingIntervalMillis(instance.profilingIntervalMillis())
        .defaultDisplayedTransactionType(instance.defaultDisplayedTransactionType())
        .addAllDefaultDisplayedPercentiles(instance.defaultDisplayedPercentiles())
        .version(instance.version())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.TransactionConfigDto}.
   * @return new TransactionConfigDto builder
   */
  static TransactionConfigDto.Builder builder() {
    return new TransactionConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.TransactionConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_SLOW_THRESHOLD_MILLIS = 0x1L;
    private static final long INITIALIZED_BIT_PROFILING_INTERVAL_MILLIS = 0x2L;
    private static final long INITIALIZED_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE = 0x4L;
    private static final long INITIALIZED_BIT_VERSION = 0x8L;
    private long initializedBitset;
  
    private int slowThresholdMillis;
    private int profilingIntervalMillis;
    private @Nullable String defaultDisplayedTransactionType;
    private ImmutableList.Builder<Double> defaultDisplayedPercentilesBuilder = ImmutableList.builder();
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Initializes value for {@link ConfigJsonService.TransactionConfigDtoBase#slowThresholdMillis() slowThresholdMillis}.
     * @param slowThresholdMillis value for slowThresholdMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder slowThresholdMillis(int slowThresholdMillis) {
      checkNotIsSet(slowThresholdMillisIsSet(), "slowThresholdMillis");
      this.slowThresholdMillis = slowThresholdMillis;
      initializedBitset |= INITIALIZED_BIT_SLOW_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.TransactionConfigDtoBase#profilingIntervalMillis() profilingIntervalMillis}.
     * @param profilingIntervalMillis value for profilingIntervalMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
      checkNotIsSet(profilingIntervalMillisIsSet(), "profilingIntervalMillis");
      this.profilingIntervalMillis = profilingIntervalMillis;
      initializedBitset |= INITIALIZED_BIT_PROFILING_INTERVAL_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.TransactionConfigDtoBase#defaultDisplayedTransactionType() defaultDisplayedTransactionType}.
     * @param defaultDisplayedTransactionType value for defaultDisplayedTransactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultDisplayedTransactionType(String defaultDisplayedTransactionType) {
      checkNotIsSet(defaultDisplayedTransactionTypeIsSet(), "defaultDisplayedTransactionType");
      this.defaultDisplayedTransactionType = Preconditions.checkNotNull(defaultDisplayedTransactionType);
      initializedBitset |= INITIALIZED_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Adds one element to {@link ConfigJsonService.TransactionConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles} list.
     * @param element defaultDisplayedPercentiles element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDefaultDisplayedPercentiles(double element) {
      defaultDisplayedPercentilesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.TransactionConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles} list.
     * @param elements array of defaultDisplayedPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDefaultDisplayedPercentiles(double... elements) {
      defaultDisplayedPercentilesBuilder.addAll(Doubles.asList(elements));
      return this;
    }
  
    /**
     * Adds elements to {@link ConfigJsonService.TransactionConfigDtoBase#defaultDisplayedPercentiles() defaultDisplayedPercentiles} list.
     * @param elements iterable of defaultDisplayedPercentiles elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllDefaultDisplayedPercentiles(Iterable<Double> elements) {
      defaultDisplayedPercentilesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.TransactionConfigDtoBase#version() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(String version) {
      checkNotIsSet(versionIsSet(), "version");
      this.version = Preconditions.checkNotNull(version);
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.TransactionConfigDto}.
     * @return immutable instance of TransactionConfigDto
     */
    public org.glowroot.local.ui.TransactionConfigDto build() {
      checkRequiredAttributes();
      return new TransactionConfigDto(
        slowThresholdMillis,
        profilingIntervalMillis,
        defaultDisplayedTransactionType,
        defaultDisplayedPercentilesBuilder.build(),
        version);
    }
  
    private boolean slowThresholdMillisIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SLOW_THRESHOLD_MILLIS) != 0;
    }
  
    private boolean profilingIntervalMillisIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PROFILING_INTERVAL_MILLIS) != 0;
    }
  
    private boolean defaultDisplayedTransactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of TransactionConfigDto is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!slowThresholdMillisIsSet()) {
        attributes.add("slowThresholdMillis");
      }
      if (!profilingIntervalMillisIsSet()) {
        attributes.add("profilingIntervalMillis");
      }
      if (!defaultDisplayedTransactionTypeIsSet()) {
        attributes.add("defaultDisplayedTransactionType");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      return "Cannot build TransactionConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
