package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AnonymousAccess;

/**
 * Immutable implementation of {@link ConfigJsonService.UserInterfaceConfigDtoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code UserInterfaceConfigDto.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConfigJsonService.UserInterfaceConfigDtoBase"})
@Immutable
final class UserInterfaceConfigDto
    extends ConfigJsonService.UserInterfaceConfigDtoBase {
  private final int port;
  private final boolean adminPasswordEnabled;
  private final boolean readOnlyPasswordEnabled;
  private final AnonymousAccess anonymousAccess;
  private final String currentAdminPassword;
  private final String newAdminPassword;
  private final String newReadOnlyPassword;
  private final int sessionTimeoutMinutes;
  private final String version;

  private UserInterfaceConfigDto(UserInterfaceConfigDto.Builder builder) {
    this.port = builder.port;
    this.adminPasswordEnabled = builder.adminPasswordEnabled;
    this.readOnlyPasswordEnabled = builder.readOnlyPasswordEnabled;
    this.anonymousAccess = builder.anonymousAccess;
    this.sessionTimeoutMinutes = builder.sessionTimeoutMinutes;
    this.version = builder.version;
    this.currentAdminPassword = builder.currentAdminPassword != null
        ? builder.currentAdminPassword
        : Preconditions.checkNotNull(super.currentAdminPassword());
    this.newAdminPassword = builder.newAdminPassword != null
        ? builder.newAdminPassword
        : Preconditions.checkNotNull(super.newAdminPassword());
    this.newReadOnlyPassword = builder.newReadOnlyPassword != null
        ? builder.newReadOnlyPassword
        : Preconditions.checkNotNull(super.newReadOnlyPassword());
  }

  private UserInterfaceConfigDto(
      int port,
      boolean adminPasswordEnabled,
      boolean readOnlyPasswordEnabled,
      AnonymousAccess anonymousAccess,
      String currentAdminPassword,
      String newAdminPassword,
      String newReadOnlyPassword,
      int sessionTimeoutMinutes,
      String version) {
    this.port = port;
    this.adminPasswordEnabled = adminPasswordEnabled;
    this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
    this.anonymousAccess = anonymousAccess;
    this.currentAdminPassword = currentAdminPassword;
    this.newAdminPassword = newAdminPassword;
    this.newReadOnlyPassword = newReadOnlyPassword;
    this.sessionTimeoutMinutes = sessionTimeoutMinutes;
    this.version = version;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code port} attribute
   */
  @JsonProperty("port")
  @Override
  public int port() {
    return port;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code adminPasswordEnabled} attribute
   */
  @JsonProperty("adminPasswordEnabled")
  @Override
  public boolean adminPasswordEnabled() {
    return adminPasswordEnabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code readOnlyPasswordEnabled} attribute
   */
  @JsonProperty("readOnlyPasswordEnabled")
  @Override
  public boolean readOnlyPasswordEnabled() {
    return readOnlyPasswordEnabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code anonymousAccess} attribute
   */
  @JsonProperty("anonymousAccess")
  @Override
  public AnonymousAccess anonymousAccess() {
    return anonymousAccess;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code currentAdminPassword} attribute
   */
  @JsonProperty("currentAdminPassword")
  @Override
  public String currentAdminPassword() {
    return currentAdminPassword;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code newAdminPassword} attribute
   */
  @JsonProperty("newAdminPassword")
  @Override
  public String newAdminPassword() {
    return newAdminPassword;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code newReadOnlyPassword} attribute
   */
  @JsonProperty("newReadOnlyPassword")
  @Override
  public String newReadOnlyPassword() {
    return newReadOnlyPassword;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code sessionTimeoutMinutes} attribute
   */
  @JsonProperty("sessionTimeoutMinutes")
  @Override
  public int sessionTimeoutMinutes() {
    return sessionTimeoutMinutes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#port() port}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for port
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigDto withPort(int value) {
    if (this.port == value) {
      return this;
    }
    int newValue = value;
    return new UserInterfaceConfigDto(
        newValue,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.currentAdminPassword,
        this.newAdminPassword,
        this.newReadOnlyPassword,
        this.sessionTimeoutMinutes,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#adminPasswordEnabled() adminPasswordEnabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for adminPasswordEnabled
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigDto withAdminPasswordEnabled(boolean value) {
    if (this.adminPasswordEnabled == value) {
      return this;
    }
    boolean newValue = value;
    return new UserInterfaceConfigDto(
        this.port,
        newValue,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.currentAdminPassword,
        this.newAdminPassword,
        this.newReadOnlyPassword,
        this.sessionTimeoutMinutes,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#readOnlyPasswordEnabled() readOnlyPasswordEnabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for readOnlyPasswordEnabled
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigDto withReadOnlyPasswordEnabled(boolean value) {
    if (this.readOnlyPasswordEnabled == value) {
      return this;
    }
    boolean newValue = value;
    return new UserInterfaceConfigDto(
        this.port,
        this.adminPasswordEnabled,
        newValue,
        this.anonymousAccess,
        this.currentAdminPassword,
        this.newAdminPassword,
        this.newReadOnlyPassword,
        this.sessionTimeoutMinutes,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#anonymousAccess() anonymousAccess}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for anonymousAccess
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigDto withAnonymousAccess(AnonymousAccess value) {
    if (this.anonymousAccess == value) {
      return this;
    }
    AnonymousAccess newValue = Preconditions.checkNotNull(value);
    return new UserInterfaceConfigDto(
        this.port,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        newValue,
        this.currentAdminPassword,
        this.newAdminPassword,
        this.newReadOnlyPassword,
        this.sessionTimeoutMinutes,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#currentAdminPassword() currentAdminPassword}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for currentAdminPassword
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigDto withCurrentAdminPassword(String value) {
    if (this.currentAdminPassword == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new UserInterfaceConfigDto(
        this.port,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        newValue,
        this.newAdminPassword,
        this.newReadOnlyPassword,
        this.sessionTimeoutMinutes,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#newAdminPassword() newAdminPassword}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for newAdminPassword
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigDto withNewAdminPassword(String value) {
    if (this.newAdminPassword == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new UserInterfaceConfigDto(
        this.port,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.currentAdminPassword,
        newValue,
        this.newReadOnlyPassword,
        this.sessionTimeoutMinutes,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#newReadOnlyPassword() newReadOnlyPassword}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for newReadOnlyPassword
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigDto withNewReadOnlyPassword(String value) {
    if (this.newReadOnlyPassword == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new UserInterfaceConfigDto(
        this.port,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.currentAdminPassword,
        this.newAdminPassword,
        newValue,
        this.sessionTimeoutMinutes,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#sessionTimeoutMinutes() sessionTimeoutMinutes}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for sessionTimeoutMinutes
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigDto withSessionTimeoutMinutes(int value) {
    if (this.sessionTimeoutMinutes == value) {
      return this;
    }
    int newValue = value;
    return new UserInterfaceConfigDto(
        this.port,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.currentAdminPassword,
        this.newAdminPassword,
        this.newReadOnlyPassword,
        newValue,
        this.version);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#version() version}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for version
   * @return modified copy of the {@code this} object
   */
  public final UserInterfaceConfigDto withVersion(String value) {
    if (this.version == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new UserInterfaceConfigDto(
        this.port,
        this.adminPasswordEnabled,
        this.readOnlyPasswordEnabled,
        this.anonymousAccess,
        this.currentAdminPassword,
        this.newAdminPassword,
        this.newReadOnlyPassword,
        this.sessionTimeoutMinutes,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code UserInterfaceConfigDto} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof UserInterfaceConfigDto && equalTo((UserInterfaceConfigDto) another));
  }
  
  private boolean equalTo(UserInterfaceConfigDto another) {
    return port == another.port
        && adminPasswordEnabled == another.adminPasswordEnabled
        && readOnlyPasswordEnabled == another.readOnlyPasswordEnabled
        && anonymousAccess.equals(another.anonymousAccess)
        && currentAdminPassword.equals(another.currentAdminPassword)
        && newAdminPassword.equals(another.newAdminPassword)
        && newReadOnlyPassword.equals(another.newReadOnlyPassword)
        && sessionTimeoutMinutes == another.sessionTimeoutMinutes
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code port}, {@code adminPasswordEnabled}, {@code readOnlyPasswordEnabled}, {@code anonymousAccess}, {@code currentAdminPassword}, {@code newAdminPassword}, {@code newReadOnlyPassword}, {@code sessionTimeoutMinutes}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + port;
    h = h * 17 + Booleans.hashCode(adminPasswordEnabled);
    h = h * 17 + Booleans.hashCode(readOnlyPasswordEnabled);
    h = h * 17 + anonymousAccess.hashCode();
    h = h * 17 + currentAdminPassword.hashCode();
    h = h * 17 + newAdminPassword.hashCode();
    h = h * 17 + newReadOnlyPassword.hashCode();
    h = h * 17 + sessionTimeoutMinutes;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code UserInterfaceConfigDto{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UserInterfaceConfigDto")
        .add("port", port)
        .add("adminPasswordEnabled", adminPasswordEnabled)
        .add("readOnlyPasswordEnabled", readOnlyPasswordEnabled)
        .add("anonymousAccess", anonymousAccess)
        .add("currentAdminPassword", currentAdminPassword)
        .add("newAdminPassword", newAdminPassword)
        .add("newReadOnlyPassword", newReadOnlyPassword)
        .add("sessionTimeoutMinutes", sessionTimeoutMinutes)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static UserInterfaceConfigDto fromAllAttributes(
      @JsonProperty("port") @Nullable Integer port,
      @JsonProperty("adminPasswordEnabled") @Nullable Boolean adminPasswordEnabled,
      @JsonProperty("readOnlyPasswordEnabled") @Nullable Boolean readOnlyPasswordEnabled,
      @JsonProperty("anonymousAccess") @Nullable AnonymousAccess anonymousAccess,
      @JsonProperty("currentAdminPassword") @Nullable String currentAdminPassword,
      @JsonProperty("newAdminPassword") @Nullable String newAdminPassword,
      @JsonProperty("newReadOnlyPassword") @Nullable String newReadOnlyPassword,
      @JsonProperty("sessionTimeoutMinutes") @Nullable Integer sessionTimeoutMinutes,
      @JsonProperty("version") @Nullable String version) {
    UserInterfaceConfigDto.Builder builder = UserInterfaceConfigDto.builder();
    if (port != null) {
      builder.port(port);
    }
    if (adminPasswordEnabled != null) {
      builder.adminPasswordEnabled(adminPasswordEnabled);
    }
    if (readOnlyPasswordEnabled != null) {
      builder.readOnlyPasswordEnabled(readOnlyPasswordEnabled);
    }
    if (anonymousAccess != null) {
      builder.anonymousAccess(anonymousAccess);
    }
    if (currentAdminPassword != null) {
      builder.currentAdminPassword(currentAdminPassword);
    }
    if (newAdminPassword != null) {
      builder.newAdminPassword(newAdminPassword);
    }
    if (newReadOnlyPassword != null) {
      builder.newReadOnlyPassword(newReadOnlyPassword);
    }
    if (sessionTimeoutMinutes != null) {
      builder.sessionTimeoutMinutes(sessionTimeoutMinutes);
    }
    if (version != null) {
      builder.version(version);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ConfigJsonService.UserInterfaceConfigDtoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable UserInterfaceConfigDto instance
   */
  static UserInterfaceConfigDto copyOf(ConfigJsonService.UserInterfaceConfigDtoBase instance) {
    if (instance instanceof UserInterfaceConfigDto) {
      return (UserInterfaceConfigDto) instance;
    }
    return UserInterfaceConfigDto.builder()
        .port(instance.port())
        .adminPasswordEnabled(instance.adminPasswordEnabled())
        .readOnlyPasswordEnabled(instance.readOnlyPasswordEnabled())
        .anonymousAccess(instance.anonymousAccess())
        .currentAdminPassword(instance.currentAdminPassword())
        .newAdminPassword(instance.newAdminPassword())
        .newReadOnlyPassword(instance.newReadOnlyPassword())
        .sessionTimeoutMinutes(instance.sessionTimeoutMinutes())
        .version(instance.version())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.UserInterfaceConfigDto}.
   * @return new UserInterfaceConfigDto builder
   */
  static UserInterfaceConfigDto.Builder builder() {
    return new UserInterfaceConfigDto.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.UserInterfaceConfigDto}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3f;
    private static final long INITIALIZED_BIT_PORT = 0x1L;
    private static final long INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED = 0x2L;
    private static final long INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED = 0x4L;
    private static final long INITIALIZED_BIT_ANONYMOUS_ACCESS = 0x8L;
    private static final long INITIALIZED_BIT_SESSION_TIMEOUT_MINUTES = 0x10L;
    private static final long INITIALIZED_BIT_VERSION = 0x20L;
    private static final long NONDEFAULT_BIT_CURRENT_ADMIN_PASSWORD = 0x1L;
    private static final long NONDEFAULT_BIT_NEW_ADMIN_PASSWORD = 0x2L;
    private static final long NONDEFAULT_BIT_NEW_READ_ONLY_PASSWORD = 0x4L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private int port;
    private boolean adminPasswordEnabled;
    private boolean readOnlyPasswordEnabled;
    private @Nullable AnonymousAccess anonymousAccess;
    private @Nullable String currentAdminPassword;
    private @Nullable String newAdminPassword;
    private @Nullable String newReadOnlyPassword;
    private int sessionTimeoutMinutes;
    private @Nullable String version;
    private Builder() {}
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#port() port}.
     * @param port value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      checkNotIsSet(portIsSet(), "port");
      this.port = port;
      initializedBitset |= INITIALIZED_BIT_PORT;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#adminPasswordEnabled() adminPasswordEnabled}.
     * @param adminPasswordEnabled value for adminPasswordEnabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder adminPasswordEnabled(boolean adminPasswordEnabled) {
      checkNotIsSet(adminPasswordEnabledIsSet(), "adminPasswordEnabled");
      this.adminPasswordEnabled = adminPasswordEnabled;
      initializedBitset |= INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#readOnlyPasswordEnabled() readOnlyPasswordEnabled}.
     * @param readOnlyPasswordEnabled value for readOnlyPasswordEnabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder readOnlyPasswordEnabled(boolean readOnlyPasswordEnabled) {
      checkNotIsSet(readOnlyPasswordEnabledIsSet(), "readOnlyPasswordEnabled");
      this.readOnlyPasswordEnabled = readOnlyPasswordEnabled;
      initializedBitset |= INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#anonymousAccess() anonymousAccess}.
     * @param anonymousAccess value for anonymousAccess
     * @return {@code this} builder for chained invocation
     */
    public final Builder anonymousAccess(AnonymousAccess anonymousAccess) {
      checkNotIsSet(anonymousAccessIsSet(), "anonymousAccess");
      this.anonymousAccess = Preconditions.checkNotNull(anonymousAccess);
      initializedBitset |= INITIALIZED_BIT_ANONYMOUS_ACCESS;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#currentAdminPassword() currentAdminPassword}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link ConfigJsonService.UserInterfaceConfigDtoBase#currentAdminPassword() currentAdminPassword}.</em>
     * @param currentAdminPassword value for currentAdminPassword
     * @return {@code this} builder for chained invocation
     */
    public final Builder currentAdminPassword(String currentAdminPassword) {
      checkNotIsSet(currentAdminPasswordIsSet(), "currentAdminPassword");
      this.currentAdminPassword = Preconditions.checkNotNull(currentAdminPassword);
      nondefaultBitset |= NONDEFAULT_BIT_CURRENT_ADMIN_PASSWORD;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#newAdminPassword() newAdminPassword}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link ConfigJsonService.UserInterfaceConfigDtoBase#newAdminPassword() newAdminPassword}.</em>
     * @param newAdminPassword value for newAdminPassword
     * @return {@code this} builder for chained invocation
     */
    public final Builder newAdminPassword(String newAdminPassword) {
      checkNotIsSet(newAdminPasswordIsSet(), "newAdminPassword");
      this.newAdminPassword = Preconditions.checkNotNull(newAdminPassword);
      nondefaultBitset |= NONDEFAULT_BIT_NEW_ADMIN_PASSWORD;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#newReadOnlyPassword() newReadOnlyPassword}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link ConfigJsonService.UserInterfaceConfigDtoBase#newReadOnlyPassword() newReadOnlyPassword}.</em>
     * @param newReadOnlyPassword value for newReadOnlyPassword
     * @return {@code this} builder for chained invocation
     */
    public final Builder newReadOnlyPassword(String newReadOnlyPassword) {
      checkNotIsSet(newReadOnlyPasswordIsSet(), "newReadOnlyPassword");
      this.newReadOnlyPassword = Preconditions.checkNotNull(newReadOnlyPassword);
      nondefaultBitset |= NONDEFAULT_BIT_NEW_READ_ONLY_PASSWORD;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#sessionTimeoutMinutes() sessionTimeoutMinutes}.
     * @param sessionTimeoutMinutes value for sessionTimeoutMinutes
     * @return {@code this} builder for chained invocation
     */
    public final Builder sessionTimeoutMinutes(int sessionTimeoutMinutes) {
      checkNotIsSet(sessionTimeoutMinutesIsSet(), "sessionTimeoutMinutes");
      this.sessionTimeoutMinutes = sessionTimeoutMinutes;
      initializedBitset |= INITIALIZED_BIT_SESSION_TIMEOUT_MINUTES;
      return this;
    }
  
    /**
     * Initializes value for {@link ConfigJsonService.UserInterfaceConfigDtoBase#version() version}.
     * @param version value for version
     * @return {@code this} builder for chained invocation
     */
    public final Builder version(String version) {
      checkNotIsSet(versionIsSet(), "version");
      this.version = Preconditions.checkNotNull(version);
      initializedBitset |= INITIALIZED_BIT_VERSION;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.UserInterfaceConfigDto}.
     * @return immutable instance of UserInterfaceConfigDto
     */
    public org.glowroot.local.ui.UserInterfaceConfigDto build() {
      checkRequiredAttributes();
      return new UserInterfaceConfigDto(this);
    }
  
    private boolean currentAdminPasswordIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_CURRENT_ADMIN_PASSWORD) != 0;
    }
  
    private boolean newAdminPasswordIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_NEW_ADMIN_PASSWORD) != 0;
    }
  
    private boolean newReadOnlyPasswordIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_NEW_READ_ONLY_PASSWORD) != 0;
    }
  
    private boolean portIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PORT) != 0;
    }
  
    private boolean adminPasswordEnabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ADMIN_PASSWORD_ENABLED) != 0;
    }
  
    private boolean readOnlyPasswordEnabledIsSet() {
      return (initializedBitset & INITIALIZED_BIT_READ_ONLY_PASSWORD_ENABLED) != 0;
    }
  
    private boolean anonymousAccessIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ANONYMOUS_ACCESS) != 0;
    }
  
    private boolean sessionTimeoutMinutesIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SESSION_TIMEOUT_MINUTES) != 0;
    }
  
    private boolean versionIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VERSION) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of UserInterfaceConfigDto is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!portIsSet()) {
        attributes.add("port");
      }
      if (!adminPasswordEnabledIsSet()) {
        attributes.add("adminPasswordEnabled");
      }
      if (!readOnlyPasswordEnabledIsSet()) {
        attributes.add("readOnlyPasswordEnabled");
      }
      if (!anonymousAccessIsSet()) {
        attributes.add("anonymousAccess");
      }
      if (!sessionTimeoutMinutesIsSet()) {
        attributes.add("sessionTimeoutMinutes");
      }
      if (!versionIsSet()) {
        attributes.add("version");
      }
      return "Cannot build UserInterfaceConfigDto, some of required attributes are not set " + attributes;
    }
  }
}
