package org.glowroot.transaction;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ErrorMessageBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ErrorMessage.builder()}.
 * Use static factory method to create immutable instances:
 * {@code ErrorMessage.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ErrorMessageBase"})
@Immutable
public final class ErrorMessage extends ErrorMessageBase {
  private final String message;
  private final @Nullable ThrowableInfo throwable;

  private ErrorMessage(String message, @Nullable ThrowableInfo throwable) {
    this.message = message;
    this.throwable = throwable;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public String message() {
    return message;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code throwable} attribute
   */
  @JsonProperty("throwable")
  @Override
  public ThrowableInfo throwable() {
    return throwable;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorMessageBase#message() message}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for message
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessage withMessage(String value) {
    if (this.message == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ErrorMessage(newValue, this.throwable);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorMessageBase#throwable() throwable}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for throwable, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ErrorMessage withThrowable(@Nullable ThrowableInfo value) {
    if (this.throwable == value) {
      return this;
    }
    @Nullable ThrowableInfo newValue = value;
    return new ErrorMessage(this.message, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ErrorMessage} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ErrorMessage && equalTo((ErrorMessage) another));
  }
  
  private boolean equalTo(ErrorMessage another) {
    return message.equals(another.message)
        && Objects.equal(throwable, another.throwable);
  }
  
  /**
   * Computes hash code from attributes: {@code message}, {@code throwable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + message.hashCode();
    h = h * 17 + Objects.hashCode(throwable);
    return h;
  }
  
  /**
   * Prints immutable value {@code ErrorMessage{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorMessage")
        .add("message", message)
        .add("throwable", throwable)
        .toString();
  }
  
  @JsonCreator
  public static ErrorMessage fromAllAttributes(
      @JsonProperty("message") @Nullable String message,
      @JsonProperty("throwable") @Nullable ThrowableInfo throwable) {
    ErrorMessage.Builder builder = ErrorMessage.builder();
    if (message != null) {
      builder.message(message);
    }
    if (throwable != null) {
      builder.throwable(throwable);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code ErrorMessage} instance.
   * @param message value for {@code message}
   * @param throwable value for {@code throwable}
   * @return immutable ErrorMessage instance
   */
  public static org.glowroot.transaction.ErrorMessage of(String message, @Nullable ThrowableInfo throwable) {
    return new ErrorMessage(message, throwable);
  }
  
  /**
   * Creates immutable copy of {@link ErrorMessageBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ErrorMessage instance
   */
  public static ErrorMessage copyOf(ErrorMessageBase instance) {
    if (instance instanceof ErrorMessage) {
      return (ErrorMessage) instance;
    }
    return ErrorMessage.builder()
        .message(instance.message())
        .throwable(instance.throwable())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.ErrorMessage}.
   * @return new ErrorMessage builder
   */
  public static ErrorMessage.Builder builder() {
    return new ErrorMessage.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.ErrorMessage}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_MESSAGE = 0x1L;
    private static final long NONDEFAULT_BIT_THROWABLE = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String message;
    private @Nullable ThrowableInfo throwable;
    private Builder() {}
  
    /**
     * Initializes value for {@link ErrorMessageBase#message() message}.
     * @param message value for message
     * @return {@code this} builder for chained invocation
     */
    public final Builder message(String message) {
      checkNotIsSet(messageIsSet(), "message");
      this.message = Preconditions.checkNotNull(message);
      initializedBitset |= INITIALIZED_BIT_MESSAGE;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorMessageBase#throwable() throwable}.
     * @param throwable value for throwable, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder throwable(@Nullable ThrowableInfo throwable) {
      checkNotIsSet(throwableIsSet(), "throwable");
      this.throwable = throwable;
      nondefaultBitset |= NONDEFAULT_BIT_THROWABLE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.ErrorMessage}.
     * @return immutable instance of ErrorMessage
     */
    public ErrorMessage build() {
      checkRequiredAttributes();
      return new ErrorMessage(message, throwable);
    }
  
    private boolean throwableIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_THROWABLE) != 0;
    }
  
    private boolean messageIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MESSAGE) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ErrorMessage is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!messageIsSet()) {
        attributes.add("message");
      }
      return "Cannot build ErrorMessage, some of required attributes are not set " + attributes;
    }
  }
}
