package org.glowroot.transaction;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ThrowableInfoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ThrowableInfo.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ThrowableInfoBase"})
@Immutable
public final class ThrowableInfo extends ThrowableInfoBase {
  private final String display;
  private final ImmutableList<StackTraceElement> stackTrace;
  private final int framesInCommonWithCaused;
  private final @Nullable ThrowableInfo cause;

  private ThrowableInfo(
      String display,
      ImmutableList<StackTraceElement> stackTrace,
      int framesInCommonWithCaused,
      @Nullable ThrowableInfo cause) {
    this.display = display;
    this.stackTrace = stackTrace;
    this.framesInCommonWithCaused = framesInCommonWithCaused;
    this.cause = cause;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code display} attribute
   */
  @JsonProperty("display")
  @Override
  public String display() {
    return display;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code stackTrace} attribute
   */
  @JsonProperty("stackTrace")
  @Override
  public ImmutableList<StackTraceElement> stackTrace() {
    return stackTrace;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code framesInCommonWithCaused} attribute
   */
  @JsonProperty("framesInCommonWithCaused")
  @Override
  public int framesInCommonWithCaused() {
    return framesInCommonWithCaused;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code cause} attribute
   */
  @JsonProperty("cause")
  @Override
  public ThrowableInfo cause() {
    return cause;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThrowableInfoBase#display() display}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for display
   * @return modified copy of the {@code this} object
   */
  public final ThrowableInfo withDisplay(String value) {
    if (this.display == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ThrowableInfo(newValue, this.stackTrace, this.framesInCommonWithCaused, this.cause);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ThrowableInfoBase#stackTrace() stackTrace}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ThrowableInfo withStackTrace(StackTraceElement... elements) {
    ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
    return new ThrowableInfo(this.display, newValue, this.framesInCommonWithCaused, this.cause);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ThrowableInfoBase#stackTrace() stackTrace}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of stackTrace elements to set
   * @return modified copy of {@code this} object
   */
  public final ThrowableInfo withStackTrace(Iterable<? extends StackTraceElement> elements) {
    if (this.stackTrace == elements) {
      return this;
    }
    ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
    return new ThrowableInfo(this.display, newValue, this.framesInCommonWithCaused, this.cause);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThrowableInfoBase#framesInCommonWithCaused() framesInCommonWithCaused}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for framesInCommonWithCaused
   * @return modified copy of the {@code this} object
   */
  public final ThrowableInfo withFramesInCommonWithCaused(int value) {
    if (this.framesInCommonWithCaused == value) {
      return this;
    }
    int newValue = value;
    return new ThrowableInfo(this.display, this.stackTrace, newValue, this.cause);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThrowableInfoBase#cause() cause}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for cause, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ThrowableInfo withCause(@Nullable ThrowableInfo value) {
    if (this.cause == value) {
      return this;
    }
    @Nullable ThrowableInfo newValue = value;
    return new ThrowableInfo(this.display, this.stackTrace, this.framesInCommonWithCaused, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ThrowableInfo} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ThrowableInfo && equalTo((ThrowableInfo) another));
  }
  
  private boolean equalTo(ThrowableInfo another) {
    return display.equals(another.display)
        && stackTrace.equals(another.stackTrace)
        && framesInCommonWithCaused == another.framesInCommonWithCaused
        && Objects.equal(cause, another.cause);
  }
  
  /**
   * Computes hash code from attributes: {@code display}, {@code stackTrace}, {@code framesInCommonWithCaused}, {@code cause}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + display.hashCode();
    h = h * 17 + stackTrace.hashCode();
    h = h * 17 + framesInCommonWithCaused;
    h = h * 17 + Objects.hashCode(cause);
    return h;
  }
  
  /**
   * Prints immutable value {@code ThrowableInfo{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThrowableInfo")
        .add("display", display)
        .add("stackTrace", stackTrace)
        .add("framesInCommonWithCaused", framesInCommonWithCaused)
        .add("cause", cause)
        .toString();
  }
  
  @JsonCreator
  public static ThrowableInfo fromAllAttributes(
      @JsonProperty("display") @Nullable String display,
      @JsonProperty("stackTrace") @Nullable List<StackTraceElement> stackTrace,
      @JsonProperty("framesInCommonWithCaused") @Nullable Integer framesInCommonWithCaused,
      @JsonProperty("cause") @Nullable ThrowableInfo cause) {
    ThrowableInfo.Builder builder = ThrowableInfo.builder();
    if (display != null) {
      builder.display(display);
    }
    if (stackTrace != null) {
      builder.addAllStackTrace(stackTrace);
    }
    if (framesInCommonWithCaused != null) {
      builder.framesInCommonWithCaused(framesInCommonWithCaused);
    }
    if (cause != null) {
      builder.cause(cause);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ThrowableInfoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ThrowableInfo instance
   */
  public static ThrowableInfo copyOf(ThrowableInfoBase instance) {
    if (instance instanceof ThrowableInfo) {
      return (ThrowableInfo) instance;
    }
    return ThrowableInfo.builder()
        .display(instance.display())
        .addAllStackTrace(instance.stackTrace())
        .framesInCommonWithCaused(instance.framesInCommonWithCaused())
        .cause(instance.cause())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.ThrowableInfo}.
   * @return new ThrowableInfo builder
   */
  public static ThrowableInfo.Builder builder() {
    return new ThrowableInfo.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.ThrowableInfo}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_DISPLAY = 0x1L;
    private static final long INITIALIZED_BIT_FRAMES_IN_COMMON_WITH_CAUSED = 0x2L;
    private static final long NONDEFAULT_BIT_CAUSE = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String display;
    private ImmutableList.Builder<StackTraceElement> stackTraceBuilder = ImmutableList.builder();
    private int framesInCommonWithCaused;
    private @Nullable ThrowableInfo cause;
    private Builder() {}
  
    /**
     * Initializes value for {@link ThrowableInfoBase#display() display}.
     * @param display value for display
     * @return {@code this} builder for chained invocation
     */
    public final Builder display(String display) {
      checkNotIsSet(displayIsSet(), "display");
      this.display = Preconditions.checkNotNull(display);
      initializedBitset |= INITIALIZED_BIT_DISPLAY;
      return this;
    }
  
    /**
     * Adds one element to {@link ThrowableInfoBase#stackTrace() stackTrace} list.
     * @param element stackTrace element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addStackTrace(StackTraceElement element) {
      stackTraceBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ThrowableInfoBase#stackTrace() stackTrace} list.
     * @param elements array of stackTrace elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addStackTrace(StackTraceElement... elements) {
      stackTraceBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link ThrowableInfoBase#stackTrace() stackTrace} list.
     * @param elements iterable of stackTrace elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllStackTrace(Iterable<? extends StackTraceElement> elements) {
      stackTraceBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link ThrowableInfoBase#framesInCommonWithCaused() framesInCommonWithCaused}.
     * @param framesInCommonWithCaused value for framesInCommonWithCaused
     * @return {@code this} builder for chained invocation
     */
    public final Builder framesInCommonWithCaused(int framesInCommonWithCaused) {
      checkNotIsSet(framesInCommonWithCausedIsSet(), "framesInCommonWithCaused");
      this.framesInCommonWithCaused = framesInCommonWithCaused;
      initializedBitset |= INITIALIZED_BIT_FRAMES_IN_COMMON_WITH_CAUSED;
      return this;
    }
  
    /**
     * Initializes value for {@link ThrowableInfoBase#cause() cause}.
     * @param cause value for cause, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder cause(@Nullable ThrowableInfo cause) {
      checkNotIsSet(causeIsSet(), "cause");
      this.cause = cause;
      nondefaultBitset |= NONDEFAULT_BIT_CAUSE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.ThrowableInfo}.
     * @return immutable instance of ThrowableInfo
     */
    public ThrowableInfo build() {
      checkRequiredAttributes();
      return new ThrowableInfo(display, stackTraceBuilder.build(), framesInCommonWithCaused, cause);
    }
  
    private boolean causeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_CAUSE) != 0;
    }
  
    private boolean displayIsSet() {
      return (initializedBitset & INITIALIZED_BIT_DISPLAY) != 0;
    }
  
    private boolean framesInCommonWithCausedIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FRAMES_IN_COMMON_WITH_CAUSED) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ThrowableInfo is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!displayIsSet()) {
        attributes.add("display");
      }
      if (!framesInCommonWithCausedIsSet()) {
        attributes.add("framesInCommonWithCaused");
      }
      return "Cannot build ThrowableInfo, some of required attributes are not set " + attributes;
    }
  }
}
