/*
 * Copyright 2013-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.glowroot.transaction;

import java.util.Collection;

import org.glowroot.transaction.model.Transaction;

public interface TransactionCollector {

    void onCompletedTransaction(Transaction transaction);

    void storePartialTrace(Transaction transaction);

    // this is only used by the user interface
    Collection<Transaction> getPendingTransactions();

    // this is only used by the user interface
    boolean shouldStoreSlow(Transaction transaction);

    // this is only used by the user interface
    boolean shouldStoreError(Transaction transaction);
}
