package org.glowroot.transaction.model;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GcInfoComponent.GcInfoBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GcInfo.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GcInfoComponent.GcInfoBase"})
@Immutable
public final class GcInfo extends GcInfoComponent.GcInfoBase {
  private final String name;
  private final long collectionCount;
  private final long collectionTime;

  private GcInfo(String name, long collectionCount, long collectionTime) {
    this.name = name;
    this.collectionCount = collectionCount;
    this.collectionTime = collectionTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code collectionCount} attribute
   */
  @JsonProperty("collectionCount")
  @Override
  public long collectionCount() {
    return collectionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code collectionTime} attribute
   */
  @JsonProperty("collectionTime")
  @Override
  public long collectionTime() {
    return collectionTime;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GcInfoComponent.GcInfoBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final GcInfo withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new GcInfo(newValue, this.collectionCount, this.collectionTime);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GcInfoComponent.GcInfoBase#collectionCount() collectionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for collectionCount
   * @return modified copy of the {@code this} object
   */
  public final GcInfo withCollectionCount(long value) {
    if (this.collectionCount == value) {
      return this;
    }
    long newValue = value;
    return new GcInfo(this.name, newValue, this.collectionTime);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GcInfoComponent.GcInfoBase#collectionTime() collectionTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for collectionTime
   * @return modified copy of the {@code this} object
   */
  public final GcInfo withCollectionTime(long value) {
    if (this.collectionTime == value) {
      return this;
    }
    long newValue = value;
    return new GcInfo(this.name, this.collectionCount, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GcInfo} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GcInfo && equalTo((GcInfo) another));
  }
  
  private boolean equalTo(GcInfo another) {
    return name.equals(another.name)
        && collectionCount == another.collectionCount
        && collectionTime == another.collectionTime;
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code collectionCount}, {@code collectionTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + Longs.hashCode(collectionCount);
    h = h * 17 + Longs.hashCode(collectionTime);
    return h;
  }
  
  /**
   * Prints immutable value {@code GcInfo{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GcInfo")
        .add("name", name)
        .add("collectionCount", collectionCount)
        .add("collectionTime", collectionTime)
        .toString();
  }
  
  @JsonCreator
  public static GcInfo fromAllAttributes(
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("collectionCount") @Nullable Long collectionCount,
      @JsonProperty("collectionTime") @Nullable Long collectionTime) {
    GcInfo.Builder builder = GcInfo.builder();
    if (name != null) {
      builder.name(name);
    }
    if (collectionCount != null) {
      builder.collectionCount(collectionCount);
    }
    if (collectionTime != null) {
      builder.collectionTime(collectionTime);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link GcInfoComponent.GcInfoBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable GcInfo instance
   */
  public static GcInfo copyOf(GcInfoComponent.GcInfoBase instance) {
    if (instance instanceof GcInfo) {
      return (GcInfo) instance;
    }
    return GcInfo.builder()
        .name(instance.name())
        .collectionCount(instance.collectionCount())
        .collectionTime(instance.collectionTime())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.model.GcInfo}.
   * @return new GcInfo builder
   */
  public static GcInfo.Builder builder() {
    return new GcInfo.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.model.GcInfo}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_COLLECTION_COUNT = 0x2L;
    private static final long INITIALIZED_BIT_COLLECTION_TIME = 0x4L;
    private long initializedBitset;
  
    private @Nullable String name;
    private long collectionCount;
    private long collectionTime;
    private Builder() {}
  
    /**
     * Initializes value for {@link GcInfoComponent.GcInfoBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link GcInfoComponent.GcInfoBase#collectionCount() collectionCount}.
     * @param collectionCount value for collectionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionCount(long collectionCount) {
      checkNotIsSet(collectionCountIsSet(), "collectionCount");
      this.collectionCount = collectionCount;
      initializedBitset |= INITIALIZED_BIT_COLLECTION_COUNT;
      return this;
    }
  
    /**
     * Initializes value for {@link GcInfoComponent.GcInfoBase#collectionTime() collectionTime}.
     * @param collectionTime value for collectionTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionTime(long collectionTime) {
      checkNotIsSet(collectionTimeIsSet(), "collectionTime");
      this.collectionTime = collectionTime;
      initializedBitset |= INITIALIZED_BIT_COLLECTION_TIME;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.model.GcInfo}.
     * @return immutable instance of GcInfo
     */
    public GcInfo build() {
      checkRequiredAttributes();
      return new GcInfo(name, collectionCount, collectionTime);
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean collectionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_COLLECTION_COUNT) != 0;
    }
  
    private boolean collectionTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_COLLECTION_TIME) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of GcInfo is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!collectionCountIsSet()) {
        attributes.add("collectionCount");
      }
      if (!collectionTimeIsSet()) {
        attributes.add("collectionTime");
      }
      return "Cannot build GcInfo, some of required attributes are not set " + attributes;
    }
  }
}
