package org.glowroot.transaction.model;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.primitives.Longs;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ThreadInfoComponent.ThreadInfoSnapshotBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ThreadInfoSnapshot.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ThreadInfoComponent.ThreadInfoSnapshotBase"})
@Immutable
final class ThreadInfoSnapshot
    extends ThreadInfoComponent.ThreadInfoSnapshotBase {
  private final long threadCpuTime;
  private final long threadBlockedTimeMillis;
  private final long threadWaitedTimeMillis;
  private final long threadAllocatedBytes;

  private ThreadInfoSnapshot(ThreadInfoSnapshot.Builder builder) {
    this.threadCpuTime = builder.threadCpuTimeIsSet()
        ? builder.threadCpuTime
        : super.threadCpuTime();
    this.threadBlockedTimeMillis = builder.threadBlockedTimeMillisIsSet()
        ? builder.threadBlockedTimeMillis
        : super.threadBlockedTimeMillis();
    this.threadWaitedTimeMillis = builder.threadWaitedTimeMillisIsSet()
        ? builder.threadWaitedTimeMillis
        : super.threadWaitedTimeMillis();
    this.threadAllocatedBytes = builder.threadAllocatedBytesIsSet()
        ? builder.threadAllocatedBytes
        : super.threadAllocatedBytes();
  }

  private ThreadInfoSnapshot(
      long threadCpuTime,
      long threadBlockedTimeMillis,
      long threadWaitedTimeMillis,
      long threadAllocatedBytes) {
    this.threadCpuTime = threadCpuTime;
    this.threadBlockedTimeMillis = threadBlockedTimeMillis;
    this.threadWaitedTimeMillis = threadWaitedTimeMillis;
    this.threadAllocatedBytes = threadAllocatedBytes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadCpuTime} attribute
   */
  @JsonProperty("threadCpuTime")
  @Override
  public long threadCpuTime() {
    return threadCpuTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadBlockedTimeMillis} attribute
   */
  @JsonProperty("threadBlockedTimeMillis")
  @Override
  public long threadBlockedTimeMillis() {
    return threadBlockedTimeMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadWaitedTimeMillis} attribute
   */
  @JsonProperty("threadWaitedTimeMillis")
  @Override
  public long threadWaitedTimeMillis() {
    return threadWaitedTimeMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code threadAllocatedBytes} attribute
   */
  @JsonProperty("threadAllocatedBytes")
  @Override
  public long threadAllocatedBytes() {
    return threadAllocatedBytes;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadCpuTime() threadCpuTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadCpuTime
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoSnapshot withThreadCpuTime(long value) {
    if (this.threadCpuTime == value) {
      return this;
    }
    long newValue = value;
    return new ThreadInfoSnapshot(newValue, this.threadBlockedTimeMillis, this.threadWaitedTimeMillis, this.threadAllocatedBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadBlockedTimeMillis() threadBlockedTimeMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadBlockedTimeMillis
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoSnapshot withThreadBlockedTimeMillis(long value) {
    if (this.threadBlockedTimeMillis == value) {
      return this;
    }
    long newValue = value;
    return new ThreadInfoSnapshot(this.threadCpuTime, newValue, this.threadWaitedTimeMillis, this.threadAllocatedBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadWaitedTimeMillis() threadWaitedTimeMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadWaitedTimeMillis
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoSnapshot withThreadWaitedTimeMillis(long value) {
    if (this.threadWaitedTimeMillis == value) {
      return this;
    }
    long newValue = value;
    return new ThreadInfoSnapshot(this.threadCpuTime, this.threadBlockedTimeMillis, newValue, this.threadAllocatedBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadAllocatedBytes() threadAllocatedBytes}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for threadAllocatedBytes
   * @return modified copy of the {@code this} object
   */
  public final ThreadInfoSnapshot withThreadAllocatedBytes(long value) {
    if (this.threadAllocatedBytes == value) {
      return this;
    }
    long newValue = value;
    return new ThreadInfoSnapshot(this.threadCpuTime, this.threadBlockedTimeMillis, this.threadWaitedTimeMillis, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ThreadInfoSnapshot} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ThreadInfoSnapshot && equalTo((ThreadInfoSnapshot) another));
  }
  
  private boolean equalTo(ThreadInfoSnapshot another) {
    return threadCpuTime == another.threadCpuTime
        && threadBlockedTimeMillis == another.threadBlockedTimeMillis
        && threadWaitedTimeMillis == another.threadWaitedTimeMillis
        && threadAllocatedBytes == another.threadAllocatedBytes;
  }
  
  /**
   * Computes hash code from attributes: {@code threadCpuTime}, {@code threadBlockedTimeMillis}, {@code threadWaitedTimeMillis}, {@code threadAllocatedBytes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(threadCpuTime);
    h = h * 17 + Longs.hashCode(threadBlockedTimeMillis);
    h = h * 17 + Longs.hashCode(threadWaitedTimeMillis);
    h = h * 17 + Longs.hashCode(threadAllocatedBytes);
    return h;
  }
  
  /**
   * Prints immutable value {@code ThreadInfoSnapshot{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThreadInfoSnapshot")
        .add("threadCpuTime", threadCpuTime)
        .add("threadBlockedTimeMillis", threadBlockedTimeMillis)
        .add("threadWaitedTimeMillis", threadWaitedTimeMillis)
        .add("threadAllocatedBytes", threadAllocatedBytes)
        .toString();
  }
  
  @JsonCreator
  public static ThreadInfoSnapshot fromAllAttributes(
      @JsonProperty("threadCpuTime") @Nullable Long threadCpuTime,
      @JsonProperty("threadBlockedTimeMillis") @Nullable Long threadBlockedTimeMillis,
      @JsonProperty("threadWaitedTimeMillis") @Nullable Long threadWaitedTimeMillis,
      @JsonProperty("threadAllocatedBytes") @Nullable Long threadAllocatedBytes) {
    ThreadInfoSnapshot.Builder builder = ThreadInfoSnapshot.builder();
    if (threadCpuTime != null) {
      builder.threadCpuTime(threadCpuTime);
    }
    if (threadBlockedTimeMillis != null) {
      builder.threadBlockedTimeMillis(threadBlockedTimeMillis);
    }
    if (threadWaitedTimeMillis != null) {
      builder.threadWaitedTimeMillis(threadWaitedTimeMillis);
    }
    if (threadAllocatedBytes != null) {
      builder.threadAllocatedBytes(threadAllocatedBytes);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ThreadInfoComponent.ThreadInfoSnapshotBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ThreadInfoSnapshot instance
   */
  static ThreadInfoSnapshot copyOf(ThreadInfoComponent.ThreadInfoSnapshotBase instance) {
    if (instance instanceof ThreadInfoSnapshot) {
      return (ThreadInfoSnapshot) instance;
    }
    return ThreadInfoSnapshot.builder()
        .threadCpuTime(instance.threadCpuTime())
        .threadBlockedTimeMillis(instance.threadBlockedTimeMillis())
        .threadWaitedTimeMillis(instance.threadWaitedTimeMillis())
        .threadAllocatedBytes(instance.threadAllocatedBytes())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.transaction.model.ThreadInfoSnapshot}.
   * @return new ThreadInfoSnapshot builder
   */
  static ThreadInfoSnapshot.Builder builder() {
    return new ThreadInfoSnapshot.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.transaction.model.ThreadInfoSnapshot}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long NONDEFAULT_BIT_THREAD_CPU_TIME = 0x1L;
    private static final long NONDEFAULT_BIT_THREAD_BLOCKED_TIME_MILLIS = 0x2L;
    private static final long NONDEFAULT_BIT_THREAD_WAITED_TIME_MILLIS = 0x4L;
    private static final long NONDEFAULT_BIT_THREAD_ALLOCATED_BYTES = 0x8L;
    private long nondefaultBitset;
  
    private long threadCpuTime;
    private long threadBlockedTimeMillis;
    private long threadWaitedTimeMillis;
    private long threadAllocatedBytes;
    private Builder() {}
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadCpuTime() threadCpuTime}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadCpuTime() threadCpuTime}.</em>
     * @param threadCpuTime value for threadCpuTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadCpuTime(long threadCpuTime) {
      checkNotIsSet(threadCpuTimeIsSet(), "threadCpuTime");
      this.threadCpuTime = threadCpuTime;
      nondefaultBitset |= NONDEFAULT_BIT_THREAD_CPU_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadBlockedTimeMillis() threadBlockedTimeMillis}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadBlockedTimeMillis() threadBlockedTimeMillis}.</em>
     * @param threadBlockedTimeMillis value for threadBlockedTimeMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadBlockedTimeMillis(long threadBlockedTimeMillis) {
      checkNotIsSet(threadBlockedTimeMillisIsSet(), "threadBlockedTimeMillis");
      this.threadBlockedTimeMillis = threadBlockedTimeMillis;
      nondefaultBitset |= NONDEFAULT_BIT_THREAD_BLOCKED_TIME_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadWaitedTimeMillis() threadWaitedTimeMillis}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadWaitedTimeMillis() threadWaitedTimeMillis}.</em>
     * @param threadWaitedTimeMillis value for threadWaitedTimeMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadWaitedTimeMillis(long threadWaitedTimeMillis) {
      checkNotIsSet(threadWaitedTimeMillisIsSet(), "threadWaitedTimeMillis");
      this.threadWaitedTimeMillis = threadWaitedTimeMillis;
      nondefaultBitset |= NONDEFAULT_BIT_THREAD_WAITED_TIME_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadAllocatedBytes() threadAllocatedBytes}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link ThreadInfoComponent.ThreadInfoSnapshotBase#threadAllocatedBytes() threadAllocatedBytes}.</em>
     * @param threadAllocatedBytes value for threadAllocatedBytes
     * @return {@code this} builder for chained invocation
     */
    public final Builder threadAllocatedBytes(long threadAllocatedBytes) {
      checkNotIsSet(threadAllocatedBytesIsSet(), "threadAllocatedBytes");
      this.threadAllocatedBytes = threadAllocatedBytes;
      nondefaultBitset |= NONDEFAULT_BIT_THREAD_ALLOCATED_BYTES;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.transaction.model.ThreadInfoSnapshot}.
     * @return immutable instance of ThreadInfoSnapshot
     */
    public org.glowroot.transaction.model.ThreadInfoSnapshot build() {
      return new ThreadInfoSnapshot(this);
    }
  
    private boolean threadCpuTimeIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_THREAD_CPU_TIME) != 0;
    }
  
    private boolean threadBlockedTimeMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_THREAD_BLOCKED_TIME_MILLIS) != 0;
    }
  
    private boolean threadWaitedTimeMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_THREAD_WAITED_TIME_MILLIS) != 0;
    }
  
    private boolean threadAllocatedBytesIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_THREAD_ALLOCATED_BYTES) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ThreadInfoSnapshot is strict, attribute is already set: ".concat(name));
      }
    }
  }
}
