package org.glowroot.weaving;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AnalyzedClassBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code AnalyzedClass.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AnalyzedClassBase"})
@Immutable
final class AnalyzedClass extends AnalyzedClassBase {
  private final int modifiers;
  private final String name;
  private final @Nullable String superName;
  private final ImmutableList<String> interfaceNames;
  private final ImmutableList<AnalyzedMethod> analyzedMethods;
  private final ImmutableList<ShimType> shimTypes;
  private final ImmutableList<MixinType> mixinTypes;

  private AnalyzedClass(
      int modifiers,
      String name,
      @Nullable String superName,
      ImmutableList<String> interfaceNames,
      ImmutableList<AnalyzedMethod> analyzedMethods,
      ImmutableList<ShimType> shimTypes,
      ImmutableList<MixinType> mixinTypes) {
    this.modifiers = modifiers;
    this.name = name;
    this.superName = superName;
    this.interfaceNames = interfaceNames;
    this.analyzedMethods = analyzedMethods;
    this.shimTypes = shimTypes;
    this.mixinTypes = mixinTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code modifiers} attribute
   */
  @JsonProperty("modifiers")
  @Override
  public int modifiers() {
    return modifiers;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code superName} attribute
   */
  @JsonProperty("superName")
  @Override
  public String superName() {
    return superName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code interfaceNames} attribute
   */
  @JsonProperty("interfaceNames")
  @Override
  public ImmutableList<String> interfaceNames() {
    return interfaceNames;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code analyzedMethods} attribute
   */
  @JsonProperty("analyzedMethods")
  @Override
  public ImmutableList<AnalyzedMethod> analyzedMethods() {
    return analyzedMethods;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code shimTypes} attribute
   */
  @JsonProperty("shimTypes")
  @Override
  public ImmutableList<ShimType> shimTypes() {
    return shimTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mixinTypes} attribute
   */
  @JsonProperty("mixinTypes")
  @Override
  public ImmutableList<MixinType> mixinTypes() {
    return mixinTypes;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AnalyzedClassBase#modifiers() modifiers}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for modifiers
   * @return modified copy of the {@code this} object
   */
  public final AnalyzedClass withModifiers(int value) {
    if (this.modifiers == value) {
      return this;
    }
    int newValue = value;
    return new AnalyzedClass(
        newValue,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.shimTypes,
        this.mixinTypes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AnalyzedClassBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final AnalyzedClass withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new AnalyzedClass(
        this.modifiers,
        newValue,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.shimTypes,
        this.mixinTypes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AnalyzedClassBase#superName() superName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for superName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final AnalyzedClass withSuperName(@Nullable String value) {
    if (this.superName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new AnalyzedClass(
        this.modifiers,
        this.name,
        newValue,
        this.interfaceNames,
        this.analyzedMethods,
        this.shimTypes,
        this.mixinTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedClassBase#interfaceNames() interfaceNames}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedClass withInterfaceNames(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        newValue,
        this.analyzedMethods,
        this.shimTypes,
        this.mixinTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedClassBase#interfaceNames() interfaceNames}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of interfaceNames elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedClass withInterfaceNames(Iterable<String> elements) {
    if (this.interfaceNames == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        newValue,
        this.analyzedMethods,
        this.shimTypes,
        this.mixinTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedClassBase#analyzedMethods() analyzedMethods}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedClass withAnalyzedMethods(AnalyzedMethod... elements) {
    ImmutableList<AnalyzedMethod> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        newValue,
        this.shimTypes,
        this.mixinTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedClassBase#analyzedMethods() analyzedMethods}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of analyzedMethods elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedClass withAnalyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
    if (this.analyzedMethods == elements) {
      return this;
    }
    ImmutableList<AnalyzedMethod> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        newValue,
        this.shimTypes,
        this.mixinTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedClassBase#shimTypes() shimTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedClass withShimTypes(ShimType... elements) {
    ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        newValue,
        this.mixinTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedClassBase#shimTypes() shimTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of shimTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedClass withShimTypes(Iterable<? extends ShimType> elements) {
    if (this.shimTypes == elements) {
      return this;
    }
    ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        newValue,
        this.mixinTypes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedClassBase#mixinTypes() mixinTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedClass withMixinTypes(MixinType... elements) {
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.shimTypes,
        newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AnalyzedClassBase#mixinTypes() mixinTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of mixinTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedClass withMixinTypes(Iterable<? extends MixinType> elements) {
    if (this.mixinTypes == elements) {
      return this;
    }
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedClass(
        this.modifiers,
        this.name,
        this.superName,
        this.interfaceNames,
        this.analyzedMethods,
        this.shimTypes,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code AnalyzedClass} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof AnalyzedClass && equalTo((AnalyzedClass) another));
  }
  
  private boolean equalTo(AnalyzedClass another) {
    return modifiers == another.modifiers
        && name.equals(another.name)
        && Objects.equal(superName, another.superName)
        && interfaceNames.equals(another.interfaceNames)
        && analyzedMethods.equals(another.analyzedMethods)
        && shimTypes.equals(another.shimTypes)
        && mixinTypes.equals(another.mixinTypes);
  }
  
  /**
   * Computes hash code from attributes: {@code modifiers}, {@code name}, {@code superName}, {@code interfaceNames}, {@code analyzedMethods}, {@code shimTypes}, {@code mixinTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + modifiers;
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(superName);
    h = h * 17 + interfaceNames.hashCode();
    h = h * 17 + analyzedMethods.hashCode();
    h = h * 17 + shimTypes.hashCode();
    h = h * 17 + mixinTypes.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code AnalyzedClass{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AnalyzedClass")
        .add("modifiers", modifiers)
        .add("name", name)
        .add("superName", superName)
        .add("interfaceNames", interfaceNames)
        .add("analyzedMethods", analyzedMethods)
        .add("shimTypes", shimTypes)
        .add("mixinTypes", mixinTypes)
        .toString();
  }
  
  @JsonCreator
  public static AnalyzedClass fromAllAttributes(
      @JsonProperty("modifiers") @Nullable Integer modifiers,
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("superName") @Nullable String superName,
      @JsonProperty("interfaceNames") @Nullable ImmutableList<String> interfaceNames,
      @JsonProperty("analyzedMethods") @Nullable ImmutableList<AnalyzedMethod> analyzedMethods,
      @JsonProperty("shimTypes") @Nullable ImmutableList<ShimType> shimTypes,
      @JsonProperty("mixinTypes") @Nullable ImmutableList<MixinType> mixinTypes) {
    AnalyzedClass.Builder builder = AnalyzedClass.builder();
    if (modifiers != null) {
      builder.modifiers(modifiers);
    }
    if (name != null) {
      builder.name(name);
    }
    if (superName != null) {
      builder.superName(superName);
    }
    if (interfaceNames != null) {
      builder.addAllInterfaceNames(interfaceNames);
    }
    if (analyzedMethods != null) {
      builder.addAllAnalyzedMethods(analyzedMethods);
    }
    if (shimTypes != null) {
      builder.addAllShimTypes(shimTypes);
    }
    if (mixinTypes != null) {
      builder.addAllMixinTypes(mixinTypes);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link AnalyzedClassBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable AnalyzedClass instance
   */
  static AnalyzedClass copyOf(AnalyzedClassBase instance) {
    if (instance instanceof AnalyzedClass) {
      return (AnalyzedClass) instance;
    }
    return AnalyzedClass.builder()
        .modifiers(instance.modifiers())
        .name(instance.name())
        .superName(instance.superName())
        .addAllInterfaceNames(instance.interfaceNames())
        .addAllAnalyzedMethods(instance.analyzedMethods())
        .addAllShimTypes(instance.shimTypes())
        .addAllMixinTypes(instance.mixinTypes())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.AnalyzedClass}.
   * @return new AnalyzedClass builder
   */
  static AnalyzedClass.Builder builder() {
    return new AnalyzedClass.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.AnalyzedClass}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_MODIFIERS = 0x1L;
    private static final long INITIALIZED_BIT_NAME = 0x2L;
    private static final long NONDEFAULT_BIT_SUPER_NAME = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private int modifiers;
    private @Nullable String name;
    private @Nullable String superName;
    private ImmutableList.Builder<String> interfaceNamesBuilder = ImmutableList.builder();
    private ImmutableList.Builder<AnalyzedMethod> analyzedMethodsBuilder = ImmutableList.builder();
    private ImmutableList.Builder<ShimType> shimTypesBuilder = ImmutableList.builder();
    private ImmutableList.Builder<MixinType> mixinTypesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link AnalyzedClassBase#modifiers() modifiers}.
     * @param modifiers value for modifiers
     * @return {@code this} builder for chained invocation
     */
    public final Builder modifiers(int modifiers) {
      checkNotIsSet(modifiersIsSet(), "modifiers");
      this.modifiers = modifiers;
      initializedBitset |= INITIALIZED_BIT_MODIFIERS;
      return this;
    }
  
    /**
     * Initializes value for {@link AnalyzedClassBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link AnalyzedClassBase#superName() superName}.
     * @param superName value for superName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder superName(@Nullable String superName) {
      checkNotIsSet(superNameIsSet(), "superName");
      this.superName = superName;
      nondefaultBitset |= NONDEFAULT_BIT_SUPER_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link AnalyzedClassBase#interfaceNames() interfaceNames} list.
     * @param element interfaceNames element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInterfaceNames(String element) {
      interfaceNamesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedClassBase#interfaceNames() interfaceNames} list.
     * @param elements array of interfaceNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInterfaceNames(String... elements) {
      interfaceNamesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedClassBase#interfaceNames() interfaceNames} list.
     * @param elements iterable of interfaceNames elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllInterfaceNames(Iterable<String> elements) {
      interfaceNamesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link AnalyzedClassBase#analyzedMethods() analyzedMethods} list.
     * @param element analyzedMethods element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAnalyzedMethods(AnalyzedMethod element) {
      analyzedMethodsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedClassBase#analyzedMethods() analyzedMethods} list.
     * @param elements array of analyzedMethods elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAnalyzedMethods(AnalyzedMethod... elements) {
      analyzedMethodsBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedClassBase#analyzedMethods() analyzedMethods} list.
     * @param elements iterable of analyzedMethods elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllAnalyzedMethods(Iterable<? extends AnalyzedMethod> elements) {
      analyzedMethodsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link AnalyzedClassBase#shimTypes() shimTypes} list.
     * @param element shimTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addShimTypes(ShimType element) {
      shimTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedClassBase#shimTypes() shimTypes} list.
     * @param elements array of shimTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addShimTypes(ShimType... elements) {
      shimTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedClassBase#shimTypes() shimTypes} list.
     * @param elements iterable of shimTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllShimTypes(Iterable<? extends ShimType> elements) {
      shimTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link AnalyzedClassBase#mixinTypes() mixinTypes} list.
     * @param element mixinTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMixinTypes(MixinType element) {
      mixinTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedClassBase#mixinTypes() mixinTypes} list.
     * @param elements array of mixinTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMixinTypes(MixinType... elements) {
      mixinTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link AnalyzedClassBase#mixinTypes() mixinTypes} list.
     * @param elements iterable of mixinTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMixinTypes(Iterable<? extends MixinType> elements) {
      mixinTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.AnalyzedClass}.
     * @return immutable instance of AnalyzedClass
     */
    public org.glowroot.weaving.AnalyzedClass build() {
      checkRequiredAttributes();
      return new AnalyzedClass(
        modifiers,
        name,
        superName,
        interfaceNamesBuilder.build(),
        analyzedMethodsBuilder.build(),
        shimTypesBuilder.build(),
        mixinTypesBuilder.build());
    }
  
    private boolean superNameIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_SUPER_NAME) != 0;
    }
  
    private boolean modifiersIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MODIFIERS) != 0;
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of AnalyzedClass is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!modifiersIsSet()) {
        attributes.add("modifiers");
      }
      if (!nameIsSet()) {
        attributes.add("name");
      }
      return "Cannot build AnalyzedClass, some of required attributes are not set " + attributes;
    }
  }
}
