package org.glowroot.weaving;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link WeavingClassVisitor.AnalyzedMethodKeyBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code AnalyzedMethodKey.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "WeavingClassVisitor.AnalyzedMethodKeyBase"})
@Immutable
final class AnalyzedMethodKey extends WeavingClassVisitor.AnalyzedMethodKeyBase {
  private final String name;
  private final ImmutableList<String> parameterTypes;
  private final AnalyzedMethod analyzedMethod;

  private AnalyzedMethodKey(
      String name,
      ImmutableList<String> parameterTypes,
      AnalyzedMethod analyzedMethod) {
    this.name = name;
    this.parameterTypes = parameterTypes;
    this.analyzedMethod = analyzedMethod;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code parameterTypes} attribute
   */
  @JsonProperty("parameterTypes")
  @Override
  public ImmutableList<String> parameterTypes() {
    return parameterTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code analyzedMethod} attribute
   */
  @JsonProperty("analyzedMethod")
  @Override
  public AnalyzedMethod analyzedMethod() {
    return analyzedMethod;
  }
  
  /**
   * Copy current immutable object by setting value for {@link WeavingClassVisitor.AnalyzedMethodKeyBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final AnalyzedMethodKey withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new AnalyzedMethodKey(newValue, this.parameterTypes, this.analyzedMethod);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link WeavingClassVisitor.AnalyzedMethodKeyBase#parameterTypes() parameterTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedMethodKey withParameterTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedMethodKey(this.name, newValue, this.analyzedMethod);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link WeavingClassVisitor.AnalyzedMethodKeyBase#parameterTypes() parameterTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of parameterTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final AnalyzedMethodKey withParameterTypes(Iterable<String> elements) {
    if (this.parameterTypes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AnalyzedMethodKey(this.name, newValue, this.analyzedMethod);
  }
  
  /**
   * Copy current immutable object by setting value for {@link WeavingClassVisitor.AnalyzedMethodKeyBase#analyzedMethod() analyzedMethod}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for analyzedMethod
   * @return modified copy of the {@code this} object
   */
  public final AnalyzedMethodKey withAnalyzedMethod(AnalyzedMethod value) {
    if (this.analyzedMethod == value) {
      return this;
    }
    AnalyzedMethod newValue = Preconditions.checkNotNull(value);
    return new AnalyzedMethodKey(this.name, this.parameterTypes, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code AnalyzedMethodKey} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof AnalyzedMethodKey && equalTo((AnalyzedMethodKey) another));
  }
  
  private boolean equalTo(AnalyzedMethodKey another) {
    return name.equals(another.name)
        && parameterTypes.equals(another.parameterTypes);
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code parameterTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + parameterTypes.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code AnalyzedMethodKey{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AnalyzedMethodKey")
        .add("name", name)
        .add("parameterTypes", parameterTypes)
        .toString();
  }
  
  @JsonCreator
  public static AnalyzedMethodKey fromAllAttributes(
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("parameterTypes") @Nullable ImmutableList<String> parameterTypes,
      @JsonProperty("analyzedMethod") @Nullable AnalyzedMethod analyzedMethod) {
    AnalyzedMethodKey.Builder builder = AnalyzedMethodKey.builder();
    if (name != null) {
      builder.name(name);
    }
    if (parameterTypes != null) {
      builder.addAllParameterTypes(parameterTypes);
    }
    if (analyzedMethod != null) {
      builder.analyzedMethod(analyzedMethod);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link WeavingClassVisitor.AnalyzedMethodKeyBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable AnalyzedMethodKey instance
   */
  static AnalyzedMethodKey copyOf(WeavingClassVisitor.AnalyzedMethodKeyBase instance) {
    if (instance instanceof AnalyzedMethodKey) {
      return (AnalyzedMethodKey) instance;
    }
    return AnalyzedMethodKey.builder()
        .name(instance.name())
        .addAllParameterTypes(instance.parameterTypes())
        .analyzedMethod(instance.analyzedMethod())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.AnalyzedMethodKey}.
   * @return new AnalyzedMethodKey builder
   */
  static AnalyzedMethodKey.Builder builder() {
    return new AnalyzedMethodKey.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.AnalyzedMethodKey}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_ANALYZED_METHOD = 0x2L;
    private long initializedBitset;
  
    private @Nullable String name;
    private ImmutableList.Builder<String> parameterTypesBuilder = ImmutableList.builder();
    private @Nullable AnalyzedMethod analyzedMethod;
    private Builder() {}
  
    /**
     * Initializes value for {@link WeavingClassVisitor.AnalyzedMethodKeyBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Adds one element to {@link WeavingClassVisitor.AnalyzedMethodKeyBase#parameterTypes() parameterTypes} list.
     * @param element parameterTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addParameterTypes(String element) {
      parameterTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link WeavingClassVisitor.AnalyzedMethodKeyBase#parameterTypes() parameterTypes} list.
     * @param elements array of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addParameterTypes(String... elements) {
      parameterTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link WeavingClassVisitor.AnalyzedMethodKeyBase#parameterTypes() parameterTypes} list.
     * @param elements iterable of parameterTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllParameterTypes(Iterable<String> elements) {
      parameterTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link WeavingClassVisitor.AnalyzedMethodKeyBase#analyzedMethod() analyzedMethod}.
     * @param analyzedMethod value for analyzedMethod
     * @return {@code this} builder for chained invocation
     */
    public final Builder analyzedMethod(AnalyzedMethod analyzedMethod) {
      checkNotIsSet(analyzedMethodIsSet(), "analyzedMethod");
      this.analyzedMethod = Preconditions.checkNotNull(analyzedMethod);
      initializedBitset |= INITIALIZED_BIT_ANALYZED_METHOD;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.AnalyzedMethodKey}.
     * @return immutable instance of AnalyzedMethodKey
     */
    public org.glowroot.weaving.AnalyzedMethodKey build() {
      checkRequiredAttributes();
      return new AnalyzedMethodKey(name, parameterTypesBuilder.build(), analyzedMethod);
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean analyzedMethodIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ANALYZED_METHOD) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of AnalyzedMethodKey is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!analyzedMethodIsSet()) {
        attributes.add("analyzedMethod");
      }
      return "Cannot build AnalyzedMethodKey, some of required attributes are not set " + attributes;
    }
  }
}
