package org.glowroot.weaving;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.objectweb.asm.Type;

/**
 * Immutable implementation of {@link LazyDefinedClassBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code LazyDefinedClass.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "LazyDefinedClassBase"})
@Immutable
public final class LazyDefinedClass extends LazyDefinedClassBase {
  private final Type type;
  private final byte[] bytes;
  private final ImmutableList<LazyDefinedClass> dependencies;

  private LazyDefinedClass(
      Type type,
      byte[] bytes,
      ImmutableList<LazyDefinedClass> dependencies) {
    this.type = type;
    this.bytes = bytes;
    this.dependencies = dependencies;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public Type type() {
    return type;
  }
  
  /**
   * {@inheritDoc}
   * @return cloned {@code bytes} array
   */
  @JsonProperty("bytes")
  @Override
  public byte[] bytes() {
    return bytes.clone();
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code dependencies} attribute
   */
  @JsonProperty("dependencies")
  @Override
  public ImmutableList<LazyDefinedClass> dependencies() {
    return dependencies;
  }
  
  /**
   * Copy current immutable object by setting value for {@link LazyDefinedClassBase#type() type}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for type
   * @return modified copy of the {@code this} object
   */
  public final LazyDefinedClass withType(Type value) {
    if (this.type == value) {
      return this;
    }
    Type newValue = Preconditions.checkNotNull(value);
    return new LazyDefinedClass(newValue, this.bytes, this.dependencies);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LazyDefinedClassBase#bytes() bytes}.
   * Array is cloned before saved as the attribute value.
   * @param elements elements for bytes, not null
   * @return modified copy of {@code this} object
   */
  public final LazyDefinedClass withBytes(byte... elements) {
    byte[] newValue = elements.clone();
    return new LazyDefinedClass(this.type, newValue, this.dependencies);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LazyDefinedClassBase#dependencies() dependencies}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final LazyDefinedClass withDependencies(LazyDefinedClass... elements) {
    ImmutableList<LazyDefinedClass> newValue = ImmutableList.copyOf(elements);
    return new LazyDefinedClass(this.type, this.bytes, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link LazyDefinedClassBase#dependencies() dependencies}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of dependencies elements to set
   * @return modified copy of {@code this} object
   */
  public final LazyDefinedClass withDependencies(Iterable<? extends LazyDefinedClass> elements) {
    if (this.dependencies == elements) {
      return this;
    }
    ImmutableList<LazyDefinedClass> newValue = ImmutableList.copyOf(elements);
    return new LazyDefinedClass(this.type, this.bytes, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code LazyDefinedClass} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof LazyDefinedClass && equalTo((LazyDefinedClass) another));
  }
  
  private boolean equalTo(LazyDefinedClass another) {
    return type.equals(another.type)
        && Arrays.equals(bytes, another.bytes)
        && dependencies.equals(another.dependencies);
  }
  
  /**
   * Computes hash code from attributes: {@code type}, {@code bytes}, {@code dependencies}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + Arrays.hashCode(bytes);
    h = h * 17 + dependencies.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code LazyDefinedClass{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LazyDefinedClass")
        .add("type", type)
        .add("bytes", Arrays.toString(bytes))
        .add("dependencies", dependencies)
        .toString();
  }
  
  @JsonCreator
  public static LazyDefinedClass fromAllAttributes(
      @JsonProperty("type") @Nullable Type type,
      @JsonProperty("bytes") @Nullable byte[] bytes,
      @JsonProperty("dependencies") @Nullable ImmutableList<LazyDefinedClass> dependencies) {
    LazyDefinedClass.Builder builder = LazyDefinedClass.builder();
    if (type != null) {
      builder.type(type);
    }
    if (bytes != null) {
      builder.bytes(bytes);
    }
    if (dependencies != null) {
      builder.addAllDependencies(dependencies);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link LazyDefinedClassBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable LazyDefinedClass instance
   */
  public static LazyDefinedClass copyOf(LazyDefinedClassBase instance) {
    if (instance instanceof LazyDefinedClass) {
      return (LazyDefinedClass) instance;
    }
    return LazyDefinedClass.builder()
        .type(instance.type())
        .bytes(instance.bytes())
        .addAllDependencies(instance.dependencies())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.LazyDefinedClass}.
   * @return new LazyDefinedClass builder
   */
  public static LazyDefinedClass.Builder builder() {
    return new LazyDefinedClass.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.LazyDefinedClass}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_TYPE = 0x1L;
    private static final long INITIALIZED_BIT_BYTES = 0x2L;
    private long initializedBitset;
  
    private @Nullable Type type;
    private @Nullable byte[] bytes;
    private ImmutableList.Builder<LazyDefinedClass> dependenciesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Initializes value for {@link LazyDefinedClassBase#type() type}.
     * @param type value for type
     * @return {@code this} builder for chained invocation
     */
    public final Builder type(Type type) {
      checkNotIsSet(typeIsSet(), "type");
      this.type = Preconditions.checkNotNull(type);
      initializedBitset |= INITIALIZED_BIT_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link LazyDefinedClassBase#bytes() bytes}.
     * @param elements elements for bytes
     * @return {@code this} builder for chained invocation
     */
    public final Builder bytes(byte... elements) {
      checkNotIsSet(bytesIsSet(), "bytes");
      this.bytes = elements.clone();
      initializedBitset |= INITIALIZED_BIT_BYTES;
      return this;
    }
  
    /**
     * Adds one element to {@link LazyDefinedClassBase#dependencies() dependencies} list.
     * @param element dependencies element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDependencies(LazyDefinedClass element) {
      dependenciesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link LazyDefinedClassBase#dependencies() dependencies} list.
     * @param elements array of dependencies elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addDependencies(LazyDefinedClass... elements) {
      dependenciesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link LazyDefinedClassBase#dependencies() dependencies} list.
     * @param elements iterable of dependencies elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllDependencies(Iterable<? extends LazyDefinedClass> elements) {
      dependenciesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.LazyDefinedClass}.
     * @return immutable instance of LazyDefinedClass
     */
    public LazyDefinedClass build() {
      checkRequiredAttributes();
      return new LazyDefinedClass(type, bytes, dependenciesBuilder.build());
    }
  
    private boolean typeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TYPE) != 0;
    }
  
    private boolean bytesIsSet() {
      return (initializedBitset & INITIALIZED_BIT_BYTES) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of LazyDefinedClass is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!typeIsSet()) {
        attributes.add("type");
      }
      if (!bytesIsSet()) {
        attributes.add("bytes");
      }
      return "Cannot build LazyDefinedClass, some of required attributes are not set " + attributes;
    }
  }
}
