package org.glowroot.weaving;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.objectweb.asm.Type;

/**
 * Immutable implementation of {@link MixinTypeBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MixinType.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "MixinTypeBase"})
@Immutable
public final class MixinType extends MixinTypeBase {
  private final Type implementation;
  private final ImmutableList<String> targets;
  private final ImmutableList<Type> interfaces;
  private final @Nullable String initMethodName;
  private final byte[] implementationBytes;

  private MixinType(
      Type implementation,
      ImmutableList<String> targets,
      ImmutableList<Type> interfaces,
      @Nullable String initMethodName,
      byte[] implementationBytes) {
    this.implementation = implementation;
    this.targets = targets;
    this.interfaces = interfaces;
    this.initMethodName = initMethodName;
    this.implementationBytes = implementationBytes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code implementation} attribute
   */
  @JsonProperty("implementation")
  @Override
  public Type implementation() {
    return implementation;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code targets} attribute
   */
  @JsonProperty("targets")
  @Override
  public ImmutableList<String> targets() {
    return targets;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code interfaces} attribute
   */
  @JsonProperty("interfaces")
  @Override
  public ImmutableList<Type> interfaces() {
    return interfaces;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code initMethodName} attribute
   */
  @JsonProperty("initMethodName")
  @Override
  public String initMethodName() {
    return initMethodName;
  }
  
  /**
   * {@inheritDoc}
   * @return cloned {@code implementationBytes} array
   */
  @JsonProperty("implementationBytes")
  @Override
  public byte[] implementationBytes() {
    return implementationBytes.clone();
  }
  
  /**
   * Copy current immutable object by setting value for {@link MixinTypeBase#implementation() implementation}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for implementation
   * @return modified copy of the {@code this} object
   */
  public final MixinType withImplementation(Type value) {
    if (this.implementation == value) {
      return this;
    }
    Type newValue = Preconditions.checkNotNull(value);
    return new MixinType(newValue, this.targets, this.interfaces, this.initMethodName, this.implementationBytes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link MixinTypeBase#targets() targets}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final MixinType withTargets(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MixinType(this.implementation, newValue, this.interfaces, this.initMethodName, this.implementationBytes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link MixinTypeBase#targets() targets}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of targets elements to set
   * @return modified copy of {@code this} object
   */
  public final MixinType withTargets(Iterable<String> elements) {
    if (this.targets == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MixinType(this.implementation, newValue, this.interfaces, this.initMethodName, this.implementationBytes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link MixinTypeBase#interfaces() interfaces}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final MixinType withInterfaces(Type... elements) {
    ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
    return new MixinType(this.implementation, this.targets, newValue, this.initMethodName, this.implementationBytes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link MixinTypeBase#interfaces() interfaces}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of interfaces elements to set
   * @return modified copy of {@code this} object
   */
  public final MixinType withInterfaces(Iterable<? extends Type> elements) {
    if (this.interfaces == elements) {
      return this;
    }
    ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
    return new MixinType(this.implementation, this.targets, newValue, this.initMethodName, this.implementationBytes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link MixinTypeBase#initMethodName() initMethodName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for initMethodName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final MixinType withInitMethodName(@Nullable String value) {
    if (this.initMethodName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new MixinType(this.implementation, this.targets, this.interfaces, newValue, this.implementationBytes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link MixinTypeBase#implementationBytes() implementationBytes}.
   * Array is cloned before saved as the attribute value.
   * @param elements elements for implementationBytes, not null
   * @return modified copy of {@code this} object
   */
  public final MixinType withImplementationBytes(byte... elements) {
    byte[] newValue = elements.clone();
    return new MixinType(this.implementation, this.targets, this.interfaces, this.initMethodName, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MixinType} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MixinType && equalTo((MixinType) another));
  }
  
  private boolean equalTo(MixinType another) {
    return implementation.equals(another.implementation)
        && targets.equals(another.targets)
        && interfaces.equals(another.interfaces)
        && Objects.equal(initMethodName, another.initMethodName)
        && Arrays.equals(implementationBytes, another.implementationBytes);
  }
  
  /**
   * Computes hash code from attributes: {@code implementation}, {@code targets}, {@code interfaces}, {@code initMethodName}, {@code implementationBytes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + implementation.hashCode();
    h = h * 17 + targets.hashCode();
    h = h * 17 + interfaces.hashCode();
    h = h * 17 + Objects.hashCode(initMethodName);
    h = h * 17 + Arrays.hashCode(implementationBytes);
    return h;
  }
  
  /**
   * Prints immutable value {@code MixinType{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MixinType")
        .add("implementation", implementation)
        .add("targets", targets)
        .add("interfaces", interfaces)
        .add("initMethodName", initMethodName)
        .add("implementationBytes", Arrays.toString(implementationBytes))
        .toString();
  }
  
  @JsonCreator
  public static MixinType fromAllAttributes(
      @JsonProperty("implementation") @Nullable Type implementation,
      @JsonProperty("targets") @Nullable ImmutableList<String> targets,
      @JsonProperty("interfaces") @Nullable ImmutableList<Type> interfaces,
      @JsonProperty("initMethodName") @Nullable String initMethodName,
      @JsonProperty("implementationBytes") @Nullable byte[] implementationBytes) {
    MixinType.Builder builder = MixinType.builder();
    if (implementation != null) {
      builder.implementation(implementation);
    }
    if (targets != null) {
      builder.addAllTargets(targets);
    }
    if (interfaces != null) {
      builder.addAllInterfaces(interfaces);
    }
    if (initMethodName != null) {
      builder.initMethodName(initMethodName);
    }
    if (implementationBytes != null) {
      builder.implementationBytes(implementationBytes);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link MixinTypeBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MixinType instance
   */
  public static MixinType copyOf(MixinTypeBase instance) {
    if (instance instanceof MixinType) {
      return (MixinType) instance;
    }
    return MixinType.builder()
        .implementation(instance.implementation())
        .addAllTargets(instance.targets())
        .addAllInterfaces(instance.interfaces())
        .initMethodName(instance.initMethodName())
        .implementationBytes(instance.implementationBytes())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.MixinType}.
   * @return new MixinType builder
   */
  public static MixinType.Builder builder() {
    return new MixinType.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.MixinType}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_IMPLEMENTATION = 0x1L;
    private static final long INITIALIZED_BIT_IMPLEMENTATION_BYTES = 0x2L;
    private static final long NONDEFAULT_BIT_INIT_METHOD_NAME = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable Type implementation;
    private ImmutableList.Builder<String> targetsBuilder = ImmutableList.builder();
    private ImmutableList.Builder<Type> interfacesBuilder = ImmutableList.builder();
    private @Nullable String initMethodName;
    private @Nullable byte[] implementationBytes;
    private Builder() {}
  
    /**
     * Initializes value for {@link MixinTypeBase#implementation() implementation}.
     * @param implementation value for implementation
     * @return {@code this} builder for chained invocation
     */
    public final Builder implementation(Type implementation) {
      checkNotIsSet(implementationIsSet(), "implementation");
      this.implementation = Preconditions.checkNotNull(implementation);
      initializedBitset |= INITIALIZED_BIT_IMPLEMENTATION;
      return this;
    }
  
    /**
     * Adds one element to {@link MixinTypeBase#targets() targets} list.
     * @param element targets element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTargets(String element) {
      targetsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link MixinTypeBase#targets() targets} list.
     * @param elements array of targets elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTargets(String... elements) {
      targetsBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link MixinTypeBase#targets() targets} list.
     * @param elements iterable of targets elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTargets(Iterable<String> elements) {
      targetsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link MixinTypeBase#interfaces() interfaces} list.
     * @param element interfaces element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInterfaces(Type element) {
      interfacesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link MixinTypeBase#interfaces() interfaces} list.
     * @param elements array of interfaces elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInterfaces(Type... elements) {
      interfacesBuilder.add(elements);
      return this;
    }
  
    /**
     * Adds elements to {@link MixinTypeBase#interfaces() interfaces} list.
     * @param elements iterable of interfaces elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllInterfaces(Iterable<? extends Type> elements) {
      interfacesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Initializes value for {@link MixinTypeBase#initMethodName() initMethodName}.
     * @param initMethodName value for initMethodName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder initMethodName(@Nullable String initMethodName) {
      checkNotIsSet(initMethodNameIsSet(), "initMethodName");
      this.initMethodName = initMethodName;
      nondefaultBitset |= NONDEFAULT_BIT_INIT_METHOD_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link MixinTypeBase#implementationBytes() implementationBytes}.
     * @param elements elements for implementationBytes
     * @return {@code this} builder for chained invocation
     */
    public final Builder implementationBytes(byte... elements) {
      checkNotIsSet(implementationBytesIsSet(), "implementationBytes");
      this.implementationBytes = elements.clone();
      initializedBitset |= INITIALIZED_BIT_IMPLEMENTATION_BYTES;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.MixinType}.
     * @return immutable instance of MixinType
     */
    public MixinType build() {
      checkRequiredAttributes();
      return new MixinType(
        implementation,
        targetsBuilder.build(),
        interfacesBuilder.build(),
        initMethodName,
        implementationBytes);
    }
  
    private boolean initMethodNameIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_INIT_METHOD_NAME) != 0;
    }
  
    private boolean implementationIsSet() {
      return (initializedBitset & INITIALIZED_BIT_IMPLEMENTATION) != 0;
    }
  
    private boolean implementationBytesIsSet() {
      return (initializedBitset & INITIALIZED_BIT_IMPLEMENTATION_BYTES) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of MixinType is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!implementationIsSet()) {
        attributes.add("implementation");
      }
      if (!implementationBytesIsSet()) {
        attributes.add("implementationBytes");
      }
      return "Cannot build MixinType, some of required attributes are not set " + attributes;
    }
  }
}
