package org.glowroot.weaving;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.security.CodeSource;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AnalyzedWorld.ParseContextBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ParseContext.builder()}.
 * Use static factory method to create immutable instances:
 * {@code ParseContext.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AnalyzedWorld.ParseContextBase"})
@Immutable
final class ParseContext extends AnalyzedWorld.ParseContextBase {
  private final String className;
  private final @Nullable CodeSource codeSource;

  private ParseContext(String className, @Nullable CodeSource codeSource) {
    this.className = className;
    this.codeSource = codeSource;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code className} attribute
   */
  @JsonProperty("className")
  @Override
  public String className() {
    return className;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code codeSource} attribute
   */
  @JsonProperty("codeSource")
  @Override
  public CodeSource codeSource() {
    return codeSource;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AnalyzedWorld.ParseContextBase#className() className}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for className
   * @return modified copy of the {@code this} object
   */
  public final ParseContext withClassName(String value) {
    if (this.className == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ParseContext(newValue, this.codeSource);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AnalyzedWorld.ParseContextBase#codeSource() codeSource}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for codeSource, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ParseContext withCodeSource(@Nullable CodeSource value) {
    if (this.codeSource == value) {
      return this;
    }
    @Nullable CodeSource newValue = value;
    return new ParseContext(this.className, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ParseContext} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ParseContext && equalTo((ParseContext) another));
  }
  
  private boolean equalTo(ParseContext another) {
    return className.equals(another.className)
        && Objects.equal(codeSource, another.codeSource);
  }
  
  /**
   * Computes hash code from attributes: {@code className}, {@code codeSource}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + className.hashCode();
    h = h * 17 + Objects.hashCode(codeSource);
    return h;
  }
  
  @JsonCreator
  public static ParseContext fromAllAttributes(
      @JsonProperty("className") @Nullable String className,
      @JsonProperty("codeSource") @Nullable CodeSource codeSource) {
    ParseContext.Builder builder = ParseContext.builder();
    if (className != null) {
      builder.className(className);
    }
    if (codeSource != null) {
      builder.codeSource(codeSource);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code ParseContext} instance.
   * @param className value for {@code className}
   * @param codeSource value for {@code codeSource}
   * @return immutable ParseContext instance
   */
  public static org.glowroot.weaving.ParseContext of(String className, @Nullable CodeSource codeSource) {
    return new ParseContext(className, codeSource);
  }
  
  /**
   * Creates immutable copy of {@link AnalyzedWorld.ParseContextBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ParseContext instance
   */
  static ParseContext copyOf(AnalyzedWorld.ParseContextBase instance) {
    if (instance instanceof ParseContext) {
      return (ParseContext) instance;
    }
    return ParseContext.builder()
        .className(instance.className())
        .codeSource(instance.codeSource())
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.weaving.ParseContext}.
   * @return new ParseContext builder
   */
  static ParseContext.Builder builder() {
    return new ParseContext.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.weaving.ParseContext}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_CLASS_NAME = 0x1L;
    private static final long NONDEFAULT_BIT_CODE_SOURCE = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String className;
    private @Nullable CodeSource codeSource;
    private Builder() {}
  
    /**
     * Initializes value for {@link AnalyzedWorld.ParseContextBase#className() className}.
     * @param className value for className
     * @return {@code this} builder for chained invocation
     */
    public final Builder className(String className) {
      checkNotIsSet(classNameIsSet(), "className");
      this.className = Preconditions.checkNotNull(className);
      initializedBitset |= INITIALIZED_BIT_CLASS_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link AnalyzedWorld.ParseContextBase#codeSource() codeSource}.
     * @param codeSource value for codeSource, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder codeSource(@Nullable CodeSource codeSource) {
      checkNotIsSet(codeSourceIsSet(), "codeSource");
      this.codeSource = codeSource;
      nondefaultBitset |= NONDEFAULT_BIT_CODE_SOURCE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.weaving.ParseContext}.
     * @return immutable instance of ParseContext
     */
    public org.glowroot.weaving.ParseContext build() {
      checkRequiredAttributes();
      return new ParseContext(className, codeSource);
    }
  
    private boolean codeSourceIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_CODE_SOURCE) != 0;
    }
  
    private boolean classNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CLASS_NAME) != 0;
    }
  
    private void checkNotIsSet(boolean isSet, String name) {
      if (isSet) {
        throw new IllegalStateException("Builder of ParseContext is strict, attribute is already set: ".concat(name));
      }
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!classNameIsSet()) {
        attributes.add("className");
      }
      return "Cannot build ParseContext, some of required attributes are not set " + attributes;
    }
  }
}
