/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot;

import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Strings;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

class BaseDir {
    private static final Logger logger = LoggerFactory.getLogger(BaseDir.class);

    private BaseDir() {
    }

    public static File getBaseDir(Map<String, String> properties, @Nullable File glowrootJarFile) {
        String baseDirPath = properties.get("base.dir");
        if (glowrootJarFile == null) {
            Preconditions.checkNotNull(baseDirPath, "Property base.dir is required when no glowroot jar file");
            return new File(baseDirPath);
        }
        if (Strings.isNullOrEmpty(baseDirPath)) {
            return BaseDir.getDefaultBaseDir(glowrootJarFile);
        }
        File baseDir = new File(baseDirPath);
        if (!baseDir.isAbsolute()) {
            return BaseDir.getRelativeBaseDir(baseDirPath, glowrootJarFile);
        }
        return BaseDir.getAbsoluteBaseDir(baseDir);
    }

    private static File getDefaultBaseDir(File glowrootJarFile) {
        File glowbaseDir = glowrootJarFile.getParentFile();
        if (glowbaseDir == null) {
            return new File(".");
        }
        return glowbaseDir;
    }

    private static File getRelativeBaseDir(String baseDirPath, File glowrootJarFile) {
        File baseDir = new File(glowrootJarFile.getParentFile(), baseDirPath);
        return BaseDir.getAbsoluteBaseDir(baseDir);
    }

    private static File getAbsoluteBaseDir(File baseDir) {
        baseDir.mkdirs();
        if (!baseDir.isDirectory()) {
            File processCurrDir = new File(".");
            logger.warn("error creating data directory: {} (using directory {} instead)", (Object)baseDir.getAbsolutePath(), (Object)processCurrDir.getAbsolutePath());
            return processCurrDir;
        }
        return baseDir;
    }
}

