/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.glowroot.container.Container;
import org.glowroot.container.SharedContainerRunListener;
import org.glowroot.container.impl.JavaagentContainer;
import org.glowroot.container.impl.LocalContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Containers {
    private static final Logger logger = LoggerFactory.getLogger(Containers.class);
    private static final String TEST_HARNESS_PROPERTY_NAME = "glowroot.test.harness";
    private static final Harness harness;

    private Containers() {
    }

    public static Container getSharedContainer() throws Exception {
        switch (harness) {
            case JAVAAGENT: {
                return Containers.getSharedJavaagentContainer();
            }
            case LOCAL: {
                return Containers.getSharedLocalContainer();
            }
        }
        throw new IllegalStateException("Unexpected harness enum value: " + (Object)((Object)harness));
    }

    public static Container getSharedJavaagentContainer() throws Exception {
        if (!SharedContainerRunListener.useSharedContainer()) {
            return JavaagentContainer.create();
        }
        JavaagentContainer container = (JavaagentContainer)SharedContainerRunListener.getSharedJavaagentContainer();
        if (container == null) {
            container = new JavaagentContainer(null, false, 0, true, false, false, (List<String>)ImmutableList.of());
            SharedContainerRunListener.setSharedJavaagentContainer(container);
        }
        return container;
    }

    public static Container getSharedLocalContainer() throws Exception {
        if (!SharedContainerRunListener.useSharedContainer()) {
            return new LocalContainer(null, false, 0, false, (Map<String, String>)ImmutableMap.of());
        }
        LocalContainer container = (LocalContainer)SharedContainerRunListener.getSharedLocalContainer();
        if (container == null) {
            container = new LocalContainer(null, false, 0, true, (Map<String, String>)ImmutableMap.of());
            SharedContainerRunListener.setSharedLocalContainer(container);
        } else {
            container.reopen();
        }
        return container;
    }

    public static Container createWithFileDb(File baseDir) throws Exception {
        return Containers.create(baseDir, true);
    }

    public static Container create(File baseDir, boolean useFileDb) throws Exception {
        return Containers.create(baseDir, useFileDb, false);
    }

    private static Container create(@Nullable File baseDir, boolean useFileDb, boolean shared) throws Exception {
        switch (harness) {
            case JAVAAGENT: {
                logger.debug("create(): using javaagent container");
                return new JavaagentContainer(baseDir, useFileDb, 0, shared, false, false, (List<String>)ImmutableList.of());
            }
            case LOCAL: {
                logger.debug("create(): using local container");
                return new LocalContainer(baseDir, useFileDb, 0, shared, (Map<String, String>)ImmutableMap.of());
            }
        }
        throw new IllegalStateException("Unexpected harness enum value: " + (Object)((Object)harness));
    }

    static {
        String value = System.getProperty(TEST_HARNESS_PROPERTY_NAME);
        if (value == null) {
            harness = Harness.LOCAL;
        } else if (value.equals("javaagent")) {
            harness = Harness.JAVAAGENT;
        } else if (value.equals("local")) {
            harness = Harness.LOCAL;
        } else {
            throw new IllegalStateException("Unexpected glowroot.test.harness value: " + value);
        }
    }

    private static enum Harness {
        JAVAAGENT,
        LOCAL;

    }
}

