/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.advicegen;

import javax.annotation.Nullable;
import org.glowroot.advicegen.MessageTemplate;
import org.glowroot.markers.UsedByGeneratedBytecode;
import org.glowroot.plugin.api.transaction.Message;
import org.glowroot.plugin.api.transaction.MessageSupplier;
import org.glowroot.plugin.api.transaction.TraceEntry;

@UsedByGeneratedBytecode
public class GenericMessageSupplier
extends MessageSupplier {
    private final MessageTemplate template;
    private final String[] resolvedReceiverPathParts;
    private final String[] resolvedArgPathParts;
    private volatile String[] resolvedReturnValuePathParts;
    private final String methodName;

    @UsedByGeneratedBytecode
    public static GenericMessageSupplier create(MessageTemplate template, Object receiver, String methodName, Object ... args) {
        String[] resolvedReceiverPathParts = new String[template.getThisPathParts().size()];
        int i = 0;
        for (MessageTemplate.ValuePathPart part : template.getThisPathParts()) {
            resolvedReceiverPathParts[i++] = part.evaluatePart(receiver);
        }
        String[] resolvedArgPathParts = new String[template.getArgPathParts().size()];
        i = 0;
        for (MessageTemplate.ArgPathPart part : template.getArgPathParts()) {
            if (part.getArgNumber() >= args.length) {
                resolvedArgPathParts[i++] = "<requested arg index out of bounds: " + part.getArgNumber() + ">";
                continue;
            }
            resolvedArgPathParts[i++] = part.evaluatePart(args[part.getArgNumber()]);
        }
        return new GenericMessageSupplier(template, resolvedReceiverPathParts, resolvedArgPathParts, methodName);
    }

    private GenericMessageSupplier(MessageTemplate template, String[] resolvedReceiverPathParts, String[] resolvedArgPathParts, String methodName) {
        this.template = template;
        this.resolvedReceiverPathParts = resolvedReceiverPathParts;
        this.resolvedArgPathParts = resolvedArgPathParts;
        this.methodName = methodName;
    }

    public void setReturnValue(@Nullable Object returnValue) {
        String[] parts = new String[this.template.getReturnPathParts().size()];
        int i = 0;
        for (MessageTemplate.ValuePathPart part : this.template.getReturnPathParts()) {
            parts[i++] = part.evaluatePart(returnValue);
        }
        this.resolvedReturnValuePathParts = parts;
    }

    @Override
    public Message get() {
        return Message.from(this.getMessageText());
    }

    @UsedByGeneratedBytecode
    public String getMessageText() {
        StringBuilder sb = new StringBuilder();
        int receiverPathPartIndex = 0;
        int argPathPartIndex = 0;
        int returnValuePathPartIndex = 0;
        block7: for (MessageTemplate.Part part : this.template.getAllParts()) {
            MessageTemplate.PartType partType = part.getType();
            switch (partType) {
                case CONSTANT: {
                    sb.append(((MessageTemplate.ConstantPart)part).getConstant());
                    continue block7;
                }
                case THIS_PATH: {
                    sb.append(this.resolvedReceiverPathParts[receiverPathPartIndex++]);
                    continue block7;
                }
                case ARG_PATH: {
                    sb.append(this.resolvedArgPathParts[argPathPartIndex++]);
                    continue block7;
                }
                case RETURN_PATH: {
                    if (this.resolvedReturnValuePathParts == null) continue block7;
                    sb.append(this.resolvedReturnValuePathParts[returnValuePathPartIndex++]);
                    continue block7;
                }
                case METHOD_NAME: {
                    sb.append(this.methodName);
                    continue block7;
                }
            }
            throw new AssertionError((Object)("Unknown PartType enum: " + (Object)((Object)partType)));
        }
        return sb.toString();
    }

    @UsedByGeneratedBytecode
    public static void updateWithReturnValue(TraceEntry traceEntry, @Nullable Object returnValue) {
        GenericMessageSupplier messageSupplier = (GenericMessageSupplier)traceEntry.getMessageSupplier();
        if (messageSupplier != null) {
            messageSupplier.setReturnValue(returnValue);
        }
    }
}

