/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.api;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.api.internal.GlowrootService;
import org.glowroot.api.internal.NopGlowrootService;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class Glowroot {
    private static final Logger logger;
    private static final GlowrootService glowrootService;

    public static void setTransactionType(@Nullable String transactionType) {
        glowrootService.setTransactionType(transactionType);
    }

    public static void setTransactionName(@Nullable String transactionName) {
        glowrootService.setTransactionName(transactionName);
    }

    public static void setTransactionError(Throwable t) {
        glowrootService.setTransactionError(t);
    }

    public static void setTransactionError(@Nullable String message) {
        glowrootService.setTransactionError(message);
    }

    public static void setTransactionError(@Nullable String message, Throwable t) {
        glowrootService.setTransactionError(message, t);
    }

    public static void setTransactionUser(@Nullable String user) {
        glowrootService.setTransactionUser(user);
    }

    public static void addTransactionCustomAttribute(String name, @Nullable String value) {
        glowrootService.addTransactionCustomAttribute(name, value);
    }

    public static void setTransactionSlowThreshold(long threshold, TimeUnit unit) {
        glowrootService.setTransactionSlowThreshold(threshold, unit);
    }

    static {
        GlowrootService service;
        logger = LoggerFactory.getLogger(Glowroot.class);
        try {
            Class<?> registryClass = Class.forName("org.glowroot.transaction.ServiceRegistryImpl");
            Method getInstanceMethod = registryClass.getMethod("getGlowrootService", new Class[0]);
            service = (GlowrootService)getInstanceMethod.invoke(null, new Object[0]);
            if (service == null) {
                service = NopGlowrootService.INSTANCE;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            service = NopGlowrootService.INSTANCE;
        }
        glowrootService = service;
    }
}

