/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.AggregateBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonRawValue;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class Aggregate
extends AggregateBase {
    private final String transactionType;
    @Nullable
    private final String transactionName;
    private final long captureTime;
    private final long totalMicros;
    private final long errorCount;
    private final long transactionCount;
    @Nullable
    private final Long totalCpuMicros;
    @Nullable
    private final Long totalBlockedMicros;
    @Nullable
    private final Long totalWaitedMicros;
    @Nullable
    private final Long totalAllocatedKBytes;
    private final byte[] histogram;
    private final String timers;
    @Nullable
    private final String queries;
    @Nullable
    private final String profile;

    private Aggregate(String transactionType, @Nullable String transactionName, long captureTime, long totalMicros, long errorCount, long transactionCount, @Nullable Long totalCpuMicros, @Nullable Long totalBlockedMicros, @Nullable Long totalWaitedMicros, @Nullable Long totalAllocatedKBytes, byte[] histogram, String timers, @Nullable String queries, @Nullable String profile) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.captureTime = captureTime;
        this.totalMicros = totalMicros;
        this.errorCount = errorCount;
        this.transactionCount = transactionCount;
        this.totalCpuMicros = totalCpuMicros;
        this.totalBlockedMicros = totalBlockedMicros;
        this.totalWaitedMicros = totalWaitedMicros;
        this.totalAllocatedKBytes = totalAllocatedKBytes;
        this.histogram = histogram;
        this.timers = timers;
        this.queries = queries;
        this.profile = profile;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="totalMicros")
    public long totalMicros() {
        return this.totalMicros;
    }

    @Override
    @JsonProperty(value="errorCount")
    public long errorCount() {
        return this.errorCount;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    @Override
    @JsonProperty(value="totalCpuMicros")
    public Long totalCpuMicros() {
        return this.totalCpuMicros;
    }

    @Override
    @JsonProperty(value="totalBlockedMicros")
    public Long totalBlockedMicros() {
        return this.totalBlockedMicros;
    }

    @Override
    @JsonProperty(value="totalWaitedMicros")
    public Long totalWaitedMicros() {
        return this.totalWaitedMicros;
    }

    @Override
    @JsonProperty(value="totalAllocatedKBytes")
    public Long totalAllocatedKBytes() {
        return this.totalAllocatedKBytes;
    }

    @Override
    @JsonProperty(value="histogram")
    public byte[] histogram() {
        return (byte[])this.histogram.clone();
    }

    @Override
    @JsonRawValue
    @JsonProperty(value="timers")
    public String timers() {
        return this.timers;
    }

    @Override
    @JsonRawValue
    @JsonProperty(value="queries")
    public String queries() {
        return this.queries;
    }

    @Override
    @JsonRawValue
    @JsonProperty(value="profile")
    public String profile() {
        return this.profile;
    }

    public final Aggregate withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Aggregate(newValue, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new Aggregate(this.transactionType, newValue, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        long newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, newValue, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withTotalMicros(long value) {
        if (this.totalMicros == value) {
            return this;
        }
        long newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, newValue, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withErrorCount(long value) {
        if (this.errorCount == value) {
            return this;
        }
        long newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, newValue, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        long newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, newValue, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withTotalCpuMicros(@Nullable Long value) {
        if (this.totalCpuMicros == value) {
            return this;
        }
        Long newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, newValue, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withTotalBlockedMicros(@Nullable Long value) {
        if (this.totalBlockedMicros == value) {
            return this;
        }
        Long newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, newValue, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withTotalWaitedMicros(@Nullable Long value) {
        if (this.totalWaitedMicros == value) {
            return this;
        }
        Long newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, newValue, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withTotalAllocatedKBytes(@Nullable Long value) {
        if (this.totalAllocatedKBytes == value) {
            return this;
        }
        Long newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, newValue, this.histogram, this.timers, this.queries, this.profile);
    }

    public final Aggregate withHistogram(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, newValue, this.timers, this.queries, this.profile);
    }

    public final Aggregate withTimers(String value) {
        if (this.timers == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, newValue, this.queries, this.profile);
    }

    public final Aggregate withQueries(@Nullable String value) {
        if (this.queries == value) {
            return this;
        }
        String newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, newValue, this.profile);
    }

    public final Aggregate withProfile(@Nullable String value) {
        if (this.profile == value) {
            return this;
        }
        String newValue = value;
        return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof Aggregate && this.equalTo((Aggregate)another);
    }

    private boolean equalTo(Aggregate another) {
        return this.transactionType.equals(another.transactionType) && Objects.equal(this.transactionName, another.transactionName) && this.captureTime == another.captureTime && this.totalMicros == another.totalMicros && this.errorCount == another.errorCount && this.transactionCount == another.transactionCount && Objects.equal(this.totalCpuMicros, another.totalCpuMicros) && Objects.equal(this.totalBlockedMicros, another.totalBlockedMicros) && Objects.equal(this.totalWaitedMicros, another.totalWaitedMicros) && Objects.equal(this.totalAllocatedKBytes, another.totalAllocatedKBytes) && Arrays.equals(this.histogram, another.histogram) && this.timers.equals(another.timers) && Objects.equal(this.queries, another.queries) && Objects.equal(this.profile, another.profile);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + Objects.hashCode(this.transactionName);
        h = h * 17 + Longs.hashCode(this.captureTime);
        h = h * 17 + Longs.hashCode(this.totalMicros);
        h = h * 17 + Longs.hashCode(this.errorCount);
        h = h * 17 + Longs.hashCode(this.transactionCount);
        h = h * 17 + Objects.hashCode(this.totalCpuMicros);
        h = h * 17 + Objects.hashCode(this.totalBlockedMicros);
        h = h * 17 + Objects.hashCode(this.totalWaitedMicros);
        h = h * 17 + Objects.hashCode(this.totalAllocatedKBytes);
        h = h * 17 + Arrays.hashCode(this.histogram);
        h = h * 17 + this.timers.hashCode();
        h = h * 17 + Objects.hashCode(this.queries);
        h = h * 17 + Objects.hashCode(this.profile);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Aggregate").add("transactionType", this.transactionType).add("transactionName", this.transactionName).add("captureTime", this.captureTime).add("totalMicros", this.totalMicros).add("errorCount", this.errorCount).add("transactionCount", this.transactionCount).add("totalCpuMicros", this.totalCpuMicros).add("totalBlockedMicros", this.totalBlockedMicros).add("totalWaitedMicros", this.totalWaitedMicros).add("totalAllocatedKBytes", this.totalAllocatedKBytes).add("histogram", Arrays.toString(this.histogram)).add("timers", this.timers).add("queries", this.queries).add("profile", this.profile).toString();
    }

    @JsonCreator
    public static Aggregate fromAllAttributes(@JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionName") @Nullable String transactionName, @JsonProperty(value="captureTime") @Nullable Long captureTime, @JsonProperty(value="totalMicros") @Nullable Long totalMicros, @JsonProperty(value="errorCount") @Nullable Long errorCount, @JsonProperty(value="transactionCount") @Nullable Long transactionCount, @JsonProperty(value="totalCpuMicros") @Nullable Long totalCpuMicros, @JsonProperty(value="totalBlockedMicros") @Nullable Long totalBlockedMicros, @JsonProperty(value="totalWaitedMicros") @Nullable Long totalWaitedMicros, @JsonProperty(value="totalAllocatedKBytes") @Nullable Long totalAllocatedKBytes, @JsonProperty(value="histogram") @Nullable byte[] histogram, @JsonProperty(value="timers") @Nullable String timers, @JsonProperty(value="queries") @Nullable String queries, @JsonProperty(value="profile") @Nullable String profile) {
        Builder builder = Aggregate.builder();
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionName != null) {
            builder.transactionName(transactionName);
        }
        if (captureTime != null) {
            builder.captureTime(captureTime);
        }
        if (totalMicros != null) {
            builder.totalMicros(totalMicros);
        }
        if (errorCount != null) {
            builder.errorCount(errorCount);
        }
        if (transactionCount != null) {
            builder.transactionCount(transactionCount);
        }
        if (totalCpuMicros != null) {
            builder.totalCpuMicros(totalCpuMicros);
        }
        if (totalBlockedMicros != null) {
            builder.totalBlockedMicros(totalBlockedMicros);
        }
        if (totalWaitedMicros != null) {
            builder.totalWaitedMicros(totalWaitedMicros);
        }
        if (totalAllocatedKBytes != null) {
            builder.totalAllocatedKBytes(totalAllocatedKBytes);
        }
        if (histogram != null) {
            builder.histogram(histogram);
        }
        if (timers != null) {
            builder.timers(timers);
        }
        if (queries != null) {
            builder.queries(queries);
        }
        if (profile != null) {
            builder.profile(profile);
        }
        return builder.build();
    }

    public static Aggregate copyOf(AggregateBase instance) {
        if (instance instanceof Aggregate) {
            return (Aggregate)instance;
        }
        return Aggregate.builder().transactionType(instance.transactionType()).transactionName(instance.transactionName()).captureTime(instance.captureTime()).totalMicros(instance.totalMicros()).errorCount(instance.errorCount()).transactionCount(instance.transactionCount()).totalCpuMicros(instance.totalCpuMicros()).totalBlockedMicros(instance.totalBlockedMicros()).totalWaitedMicros(instance.totalWaitedMicros()).totalAllocatedKBytes(instance.totalAllocatedKBytes()).histogram(instance.histogram()).timers(instance.timers()).queries(instance.queries()).profile(instance.profile()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 127L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 1L;
        private static final long INITIALIZED_BIT_CAPTURE_TIME = 2L;
        private static final long INITIALIZED_BIT_TOTAL_MICROS = 4L;
        private static final long INITIALIZED_BIT_ERROR_COUNT = 8L;
        private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 16L;
        private static final long INITIALIZED_BIT_HISTOGRAM = 32L;
        private static final long INITIALIZED_BIT_TIMERS = 64L;
        private static final long NONDEFAULT_BIT_TRANSACTION_NAME = 1L;
        private static final long NONDEFAULT_BIT_TOTAL_CPU_MICROS = 2L;
        private static final long NONDEFAULT_BIT_TOTAL_BLOCKED_MICROS = 4L;
        private static final long NONDEFAULT_BIT_TOTAL_WAITED_MICROS = 8L;
        private static final long NONDEFAULT_BIT_TOTAL_ALLOCATED_K_BYTES = 16L;
        private static final long NONDEFAULT_BIT_QUERIES = 32L;
        private static final long NONDEFAULT_BIT_PROFILE = 64L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionName;
        private long captureTime;
        private long totalMicros;
        private long errorCount;
        private long transactionCount;
        @Nullable
        private Long totalCpuMicros;
        @Nullable
        private Long totalBlockedMicros;
        @Nullable
        private Long totalWaitedMicros;
        @Nullable
        private Long totalAllocatedKBytes;
        @Nullable
        private byte[] histogram;
        @Nullable
        private String timers;
        @Nullable
        private String queries;
        @Nullable
        private String profile;

        private Builder() {
        }

        public final Builder transactionType(String transactionType) {
            this.checkNotIsSet(this.transactionTypeIsSet(), "transactionType");
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.checkNotIsSet(this.transactionNameIsSet(), "transactionName");
            this.transactionName = transactionName;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder captureTime(long captureTime) {
            this.checkNotIsSet(this.captureTimeIsSet(), "captureTime");
            this.captureTime = captureTime;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder totalMicros(long totalMicros) {
            this.checkNotIsSet(this.totalMicrosIsSet(), "totalMicros");
            this.totalMicros = totalMicros;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder errorCount(long errorCount) {
            this.checkNotIsSet(this.errorCountIsSet(), "errorCount");
            this.errorCount = errorCount;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.checkNotIsSet(this.transactionCountIsSet(), "transactionCount");
            this.transactionCount = transactionCount;
            this.initializedBitset |= 0x10L;
            return this;
        }

        public final Builder totalCpuMicros(@Nullable Long totalCpuMicros) {
            this.checkNotIsSet(this.totalCpuMicrosIsSet(), "totalCpuMicros");
            this.totalCpuMicros = totalCpuMicros;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder totalBlockedMicros(@Nullable Long totalBlockedMicros) {
            this.checkNotIsSet(this.totalBlockedMicrosIsSet(), "totalBlockedMicros");
            this.totalBlockedMicros = totalBlockedMicros;
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder totalWaitedMicros(@Nullable Long totalWaitedMicros) {
            this.checkNotIsSet(this.totalWaitedMicrosIsSet(), "totalWaitedMicros");
            this.totalWaitedMicros = totalWaitedMicros;
            this.nondefaultBitset |= 8L;
            return this;
        }

        public final Builder totalAllocatedKBytes(@Nullable Long totalAllocatedKBytes) {
            this.checkNotIsSet(this.totalAllocatedKBytesIsSet(), "totalAllocatedKBytes");
            this.totalAllocatedKBytes = totalAllocatedKBytes;
            this.nondefaultBitset |= 0x10L;
            return this;
        }

        public final Builder histogram(byte ... elements) {
            this.checkNotIsSet(this.histogramIsSet(), "histogram");
            this.histogram = (byte[])elements.clone();
            this.initializedBitset |= 0x20L;
            return this;
        }

        public final Builder timers(String timers) {
            this.checkNotIsSet(this.timersIsSet(), "timers");
            this.timers = Preconditions.checkNotNull(timers);
            this.initializedBitset |= 0x40L;
            return this;
        }

        public final Builder queries(@Nullable String queries) {
            this.checkNotIsSet(this.queriesIsSet(), "queries");
            this.queries = queries;
            this.nondefaultBitset |= 0x20L;
            return this;
        }

        public final Builder profile(@Nullable String profile) {
            this.checkNotIsSet(this.profileIsSet(), "profile");
            this.profile = profile;
            this.nondefaultBitset |= 0x40L;
            return this;
        }

        public Aggregate build() {
            this.checkRequiredAttributes();
            return new Aggregate(this.transactionType, this.transactionName, this.captureTime, this.totalMicros, this.errorCount, this.transactionCount, this.totalCpuMicros, this.totalBlockedMicros, this.totalWaitedMicros, this.totalAllocatedKBytes, this.histogram, this.timers, this.queries, this.profile);
        }

        private boolean transactionNameIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean totalCpuMicrosIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean totalBlockedMicrosIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean totalWaitedMicrosIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private boolean totalAllocatedKBytesIsSet() {
            return (this.nondefaultBitset & 0x10L) != 0L;
        }

        private boolean queriesIsSet() {
            return (this.nondefaultBitset & 0x20L) != 0L;
        }

        private boolean profileIsSet() {
            return (this.nondefaultBitset & 0x40L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean captureTimeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean totalMicrosIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean errorCountIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean transactionCountIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private boolean histogramIsSet() {
            return (this.initializedBitset & 0x20L) != 0L;
        }

        private boolean timersIsSet() {
            return (this.initializedBitset & 0x40L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Aggregate is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 127L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            if (!this.captureTimeIsSet()) {
                attributes.add("captureTime");
            }
            if (!this.totalMicrosIsSet()) {
                attributes.add("totalMicros");
            }
            if (!this.errorCountIsSet()) {
                attributes.add("errorCount");
            }
            if (!this.transactionCountIsSet()) {
                attributes.add("transactionCount");
            }
            if (!this.histogramIsSet()) {
                attributes.add("histogram");
            }
            if (!this.timersIsSet()) {
                attributes.add("timers");
            }
            return "Cannot build Aggregate, some of required attributes are not set " + attributes;
        }
    }
}

