/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.collector.Aggregate;
import org.glowroot.collector.AggregateProfileBuilder;
import org.glowroot.collector.AggregateTimer;
import org.glowroot.collector.ErrorPoint;
import org.glowroot.collector.ErrorSummary;
import org.glowroot.collector.LazyHistogram;
import org.glowroot.collector.QueryComponent;
import org.glowroot.collector.TransactionSummary;
import org.glowroot.common.ObjectMappers;
import org.glowroot.common.ScratchBuffer;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.transaction.model.Profile;
import org.glowroot.transaction.model.ProfileNode;
import org.glowroot.transaction.model.QueryData;
import org.glowroot.transaction.model.ThreadInfoData;
import org.glowroot.transaction.model.TimerImpl;
import org.glowroot.transaction.model.Transaction;

class AggregateBuilder {
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final String transactionType;
    @Nullable
    private final String transactionName;
    private long totalMicros;
    private long errorCount;
    private long transactionCount;
    @Nullable
    private Long totalCpuTime;
    @Nullable
    private Long totalBlockedTime;
    @Nullable
    private Long totalWaitedTime;
    @Nullable
    private Long totalAllocatedBytes;
    private final LazyHistogram lazyHistogram = new LazyHistogram();
    private final AggregateTimer syntheticRootTimer = AggregateTimer.createSyntheticRootTimer();
    private final QueryComponent queryComponent;
    private final AggregateProfileBuilder aggregateProfile = new AggregateProfileBuilder();

    AggregateBuilder(String transactionType, @Nullable String transactionName, int maxAggregateQueriesPerQueryType) {
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        int hardLimitMultiplierWhileBuilding = transactionName == null ? 10 : 2;
        this.queryComponent = new QueryComponent(maxAggregateQueriesPerQueryType, hardLimitMultiplierWhileBuilding);
    }

    void add(Transaction transaction) {
        long durationMicros = TimeUnit.NANOSECONDS.toMicros(transaction.getDuration());
        this.totalMicros += durationMicros;
        if (transaction.getErrorMessage() != null) {
            ++this.errorCount;
        }
        ++this.transactionCount;
        ThreadInfoData threadInfo = transaction.getThreadInfo();
        if (threadInfo != null) {
            this.totalCpuTime = AggregateBuilder.nullAwareAdd(this.totalCpuTime, threadInfo.threadCpuTime());
            this.totalBlockedTime = AggregateBuilder.nullAwareAdd(this.totalBlockedTime, threadInfo.threadBlockedTime());
            this.totalWaitedTime = AggregateBuilder.nullAwareAdd(this.totalWaitedTime, threadInfo.threadWaitedTime());
            this.totalAllocatedBytes = AggregateBuilder.nullAwareAdd(this.totalAllocatedBytes, threadInfo.threadAllocatedBytes());
        }
        this.lazyHistogram.add(durationMicros);
    }

    void addToTimers(TimerImpl rootTimer) {
        this.syntheticRootTimer.mergeAsChildTimer(rootTimer);
    }

    void addToQueries(Iterable<QueryData> queries) {
        for (QueryData query : queries) {
            this.queryComponent.mergeQuery(query);
        }
    }

    void addToProfile(Profile profile) {
        this.aggregateProfile.addProfile(profile);
    }

    Aggregate build(long captureTime, ScratchBuffer scratchBuffer) throws IOException {
        ByteBuffer buffer = scratchBuffer.getBuffer(this.lazyHistogram.getNeededByteBufferCapacity());
        buffer.clear();
        byte[] histogram = this.lazyHistogram.encodeUsingTempByteBuffer(buffer);
        return Aggregate.builder().transactionType(this.transactionType).transactionName(this.transactionName).captureTime(captureTime).totalMicros(this.totalMicros).errorCount(this.errorCount).transactionCount(this.transactionCount).totalCpuMicros(AggregateBuilder.nullAwareNanosToMicros(this.totalCpuTime)).totalBlockedMicros(AggregateBuilder.nullAwareNanosToMicros(this.totalBlockedTime)).totalWaitedMicros(AggregateBuilder.nullAwareNanosToMicros(this.totalWaitedTime)).totalAllocatedKBytes(AggregateBuilder.nullAwareBytesToKBytes(this.totalAllocatedBytes)).histogram(histogram).timers(mapper.writeValueAsString(this.syntheticRootTimer)).queries(this.getQueriesJson()).profile(this.getProfileJson()).build();
    }

    TransactionSummary getLiveTransactionSummary() {
        return TransactionSummary.builder().transactionName(this.transactionName).totalMicros(this.totalMicros).transactionCount(this.transactionCount).build();
    }

    ErrorSummary getLiveErrorSummary() {
        return ErrorSummary.builder().transactionName(this.transactionName).errorCount(this.errorCount).transactionCount(this.transactionCount).build();
    }

    @Nullable
    ErrorPoint buildErrorPoint(long captureTime) {
        if (this.errorCount == 0L) {
            return null;
        }
        return ErrorPoint.builder().captureTime(captureTime).errorCount(this.errorCount).transactionCount(this.transactionCount).build();
    }

    @Nullable
    String getQueriesJson() throws IOException {
        Map<String, List<QueryComponent.AggregateQuery>> queries = this.queryComponent.getOrderedAndTruncatedQueries();
        if (queries.isEmpty()) {
            return null;
        }
        return mapper.writeValueAsString(queries);
    }

    @Nullable
    String getProfileJson() throws IOException {
        ProfileNode syntheticRootNode = this.aggregateProfile.getSyntheticRootNode();
        if (syntheticRootNode.isChildNodesEmpty()) {
            return null;
        }
        return mapper.writeValueAsString(syntheticRootNode);
    }

    @Nullable
    private static Long nullAwareNanosToMicros(@Nullable Long nanoseconds) {
        if (nanoseconds == null) {
            return null;
        }
        return TimeUnit.NANOSECONDS.toMicros(nanoseconds);
    }

    @Nullable
    private static Long nullAwareBytesToKBytes(@Nullable Long bytes) {
        if (bytes == null) {
            return null;
        }
        return bytes / 1024L;
    }

    @Nullable
    private static Long nullAwareAdd(@Nullable Long x, @Nullable Long y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        return x + y;
    }
}

