/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.transaction.model.Profile;
import org.glowroot.transaction.model.ProfileNode;

class AggregateProfileBuilder {
    private final ProfileNode syntheticRootNode = ProfileNode.createSyntheticRoot();

    AggregateProfileBuilder() {
    }

    ProfileNode getSyntheticRootNode() {
        return this.syntheticRootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProfile(Profile profile) {
        Object object = profile.getLock();
        synchronized (object) {
            this.mergeNode(this.syntheticRootNode, profile.getSyntheticRootNode(), profile.mayHaveSyntheticTimerMethods());
        }
    }

    private void mergeNode(ProfileNode node, ProfileNode toBeMergedNode, boolean mayHaveSyntheticTimerMethods) {
        ImmutableList<String> timerNames;
        node.incrementSampleCount(toBeMergedNode.getSampleCount());
        if (mayHaveSyntheticTimerMethods && (timerNames = toBeMergedNode.getTimerNames()).size() > node.getTimerNames().size()) {
            node.setTimerNames(timerNames);
        }
        for (ProfileNode toBeMergedChildNode : toBeMergedNode.getChildNodes()) {
            ProfileNode foundMatchingChildNode = null;
            for (ProfileNode childNode : node.getChildNodes()) {
                if (!ProfileNode.matches(toBeMergedChildNode, childNode)) continue;
                foundMatchingChildNode = childNode;
                break;
            }
            if (foundMatchingChildNode == null) {
                Object stackTraceElement = toBeMergedChildNode.getStackTraceElementObj();
                Preconditions.checkNotNull(stackTraceElement);
                foundMatchingChildNode = ProfileNode.create(stackTraceElement, toBeMergedChildNode.getLeafThreadState());
                node.addChildNode(foundMatchingChildNode);
            }
            this.mergeNode(foundMatchingChildNode, toBeMergedChildNode, mayHaveSyntheticTimerMethods);
        }
    }
}

