/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.collector.AggregateCollector;
import org.glowroot.collector.AggregateRepository;
import org.glowroot.collector.GaugeCollector;
import org.glowroot.collector.GaugePointRepository;
import org.glowroot.collector.StackTraceCollector;
import org.glowroot.collector.TraceRepository;
import org.glowroot.collector.TransactionCollectorImpl;
import org.glowroot.common.Clock;
import org.glowroot.config.ConfigModule;
import org.glowroot.config.ConfigService;
import org.glowroot.config.RollupConfig;
import org.glowroot.jvm.JvmModule;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.transaction.TransactionCollector;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.model.Transaction;

public class CollectorModule {
    private static final long GAUGE_COLLECTION_INTERVAL_MILLIS = Long.getLong("glowroot.internal.gaugeCollectionIntervalMillis", 5000L);
    private final TransactionCollector transactionCollector;
    @Nullable
    private final AggregateCollector aggregateCollector;
    @Nullable
    private final GaugeCollector gaugeCollector;
    @Nullable
    private final StackTraceCollector stackTraceCollector;

    public CollectorModule(Clock clock, Ticker ticker, JvmModule jvmModule, ConfigModule configModule, TraceRepository traceRepository, AggregateRepository aggregateRepository, GaugePointRepository gaugePointRepository, TransactionRegistry transactionRegistry, ScheduledExecutorService scheduledExecutor, boolean viewerModeEnabled) {
        ConfigService configService = configModule.getConfigService();
        if (viewerModeEnabled) {
            this.aggregateCollector = null;
            this.gaugeCollector = null;
            this.stackTraceCollector = null;
            this.transactionCollector = new NopTransactionCollector();
        } else {
            this.aggregateCollector = new AggregateCollector(scheduledExecutor, aggregateRepository, configModule.getConfigService(), ((RollupConfig)configService.getRollupConfigs().get(0)).intervalMillis(), clock);
            this.gaugeCollector = new GaugeCollector(configService, gaugePointRepository, jvmModule.getLazyPlatformMBeanServer(), scheduledExecutor, clock, null);
            long initialDelay = GAUGE_COLLECTION_INTERVAL_MILLIS - clock.currentTimeMillis() % GAUGE_COLLECTION_INTERVAL_MILLIS;
            this.gaugeCollector.scheduleAtFixedRate(initialDelay, GAUGE_COLLECTION_INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
            this.stackTraceCollector = StackTraceCollector.create(transactionRegistry, configService, scheduledExecutor);
            this.transactionCollector = new TransactionCollectorImpl(scheduledExecutor, configService, traceRepository, this.aggregateCollector, clock, ticker);
        }
    }

    public TransactionCollector getTransactionCollector() {
        return this.transactionCollector;
    }

    @Nullable
    public AggregateCollector getAggregateCollector() {
        return this.aggregateCollector;
    }

    public long getGaugeCollectionIntervalMillis() {
        return GAUGE_COLLECTION_INTERVAL_MILLIS;
    }

    @OnlyUsedByTests
    public void close() {
        if (this.aggregateCollector != null) {
            this.aggregateCollector.close();
        }
        if (this.gaugeCollector != null) {
            this.gaugeCollector.close();
        }
        if (this.stackTraceCollector != null) {
            this.stackTraceCollector.close();
        }
    }

    private static class NopTransactionCollector
    implements TransactionCollector {
        private NopTransactionCollector() {
        }

        @Override
        public void onCompletedTransaction(Transaction transaction) {
        }

        @Override
        public void storePartialTrace(Transaction transaction) {
        }

        @Override
        public Collection<Transaction> getPendingTransactions() {
            return ImmutableList.of();
        }

        @Override
        public boolean shouldStoreSlow(Transaction transaction) {
            return false;
        }

        @Override
        public boolean shouldStoreError(Transaction transaction) {
            return false;
        }
    }
}

