/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.ErrorPointBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class ErrorPoint
extends ErrorPointBase {
    private final long captureTime;
    private final long errorCount;
    private final long transactionCount;

    private ErrorPoint(long captureTime, long errorCount, long transactionCount) {
        this.captureTime = captureTime;
        this.errorCount = errorCount;
        this.transactionCount = transactionCount;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="errorCount")
    public long errorCount() {
        return this.errorCount;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    public final ErrorPoint withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        long newValue = value;
        return new ErrorPoint(newValue, this.errorCount, this.transactionCount);
    }

    public final ErrorPoint withErrorCount(long value) {
        if (this.errorCount == value) {
            return this;
        }
        long newValue = value;
        return new ErrorPoint(this.captureTime, newValue, this.transactionCount);
    }

    public final ErrorPoint withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        long newValue = value;
        return new ErrorPoint(this.captureTime, this.errorCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ErrorPoint && this.equalTo((ErrorPoint)another);
    }

    private boolean equalTo(ErrorPoint another) {
        return this.captureTime == another.captureTime && this.errorCount == another.errorCount && this.transactionCount == another.transactionCount;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.captureTime);
        h = h * 17 + Longs.hashCode(this.errorCount);
        h = h * 17 + Longs.hashCode(this.transactionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ErrorPoint").add("captureTime", this.captureTime).add("errorCount", this.errorCount).add("transactionCount", this.transactionCount).toString();
    }

    @JsonCreator
    public static ErrorPoint fromAllAttributes(@JsonProperty(value="captureTime") @Nullable Long captureTime, @JsonProperty(value="errorCount") @Nullable Long errorCount, @JsonProperty(value="transactionCount") @Nullable Long transactionCount) {
        Builder builder = ErrorPoint.builder();
        if (captureTime != null) {
            builder.captureTime(captureTime);
        }
        if (errorCount != null) {
            builder.errorCount(errorCount);
        }
        if (transactionCount != null) {
            builder.transactionCount(transactionCount);
        }
        return builder.build();
    }

    public static ErrorPoint of(long captureTime, long errorCount, long transactionCount) {
        return new ErrorPoint(captureTime, errorCount, transactionCount);
    }

    public static ErrorPoint copyOf(ErrorPointBase instance) {
        if (instance instanceof ErrorPoint) {
            return (ErrorPoint)instance;
        }
        return ErrorPoint.builder().captureTime(instance.captureTime()).errorCount(instance.errorCount()).transactionCount(instance.transactionCount()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_CAPTURE_TIME = 1L;
        private static final long INITIALIZED_BIT_ERROR_COUNT = 2L;
        private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 4L;
        private long initializedBitset;
        private long captureTime;
        private long errorCount;
        private long transactionCount;

        private Builder() {
        }

        public final Builder captureTime(long captureTime) {
            this.checkNotIsSet(this.captureTimeIsSet(), "captureTime");
            this.captureTime = captureTime;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder errorCount(long errorCount) {
            this.checkNotIsSet(this.errorCountIsSet(), "errorCount");
            this.errorCount = errorCount;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.checkNotIsSet(this.transactionCountIsSet(), "transactionCount");
            this.transactionCount = transactionCount;
            this.initializedBitset |= 4L;
            return this;
        }

        public ErrorPoint build() {
            this.checkRequiredAttributes();
            return new ErrorPoint(this.captureTime, this.errorCount, this.transactionCount);
        }

        private boolean captureTimeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean errorCountIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean transactionCountIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ErrorPoint is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.captureTimeIsSet()) {
                attributes.add("captureTime");
            }
            if (!this.errorCountIsSet()) {
                attributes.add("errorCount");
            }
            if (!this.transactionCountIsSet()) {
                attributes.add("transactionCount");
            }
            return "Cannot build ErrorPoint, some of required attributes are not set " + attributes;
        }
    }
}

