/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.ErrorSummaryBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class ErrorSummary
extends ErrorSummaryBase {
    @Nullable
    private final String transactionName;
    private final long errorCount;
    private final long transactionCount;

    private ErrorSummary(@Nullable String transactionName, long errorCount, long transactionCount) {
        this.transactionName = transactionName;
        this.errorCount = errorCount;
        this.transactionCount = transactionCount;
    }

    @Override
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="errorCount")
    public long errorCount() {
        return this.errorCount;
    }

    @Override
    @JsonProperty(value="transactionCount")
    public long transactionCount() {
        return this.transactionCount;
    }

    public final ErrorSummary withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new ErrorSummary(newValue, this.errorCount, this.transactionCount);
    }

    public final ErrorSummary withErrorCount(long value) {
        if (this.errorCount == value) {
            return this;
        }
        long newValue = value;
        return new ErrorSummary(this.transactionName, newValue, this.transactionCount);
    }

    public final ErrorSummary withTransactionCount(long value) {
        if (this.transactionCount == value) {
            return this;
        }
        long newValue = value;
        return new ErrorSummary(this.transactionName, this.errorCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ErrorSummary && this.equalTo((ErrorSummary)another);
    }

    private boolean equalTo(ErrorSummary another) {
        return Objects.equal(this.transactionName, another.transactionName) && this.errorCount == another.errorCount && this.transactionCount == another.transactionCount;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.transactionName);
        h = h * 17 + Longs.hashCode(this.errorCount);
        h = h * 17 + Longs.hashCode(this.transactionCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ErrorSummary").add("transactionName", this.transactionName).add("errorCount", this.errorCount).add("transactionCount", this.transactionCount).toString();
    }

    @JsonCreator
    public static ErrorSummary fromAllAttributes(@JsonProperty(value="transactionName") @Nullable String transactionName, @JsonProperty(value="errorCount") @Nullable Long errorCount, @JsonProperty(value="transactionCount") @Nullable Long transactionCount) {
        Builder builder = ErrorSummary.builder();
        if (transactionName != null) {
            builder.transactionName(transactionName);
        }
        if (errorCount != null) {
            builder.errorCount(errorCount);
        }
        if (transactionCount != null) {
            builder.transactionCount(transactionCount);
        }
        return builder.build();
    }

    public static ErrorSummary copyOf(ErrorSummaryBase instance) {
        if (instance instanceof ErrorSummary) {
            return (ErrorSummary)instance;
        }
        return ErrorSummary.builder().transactionName(instance.transactionName()).errorCount(instance.errorCount()).transactionCount(instance.transactionCount()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_ERROR_COUNT = 1L;
        private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 2L;
        private static final long NONDEFAULT_BIT_TRANSACTION_NAME = 1L;
        private long initializedBitset;
        private long nondefaultBitset;
        @Nullable
        private String transactionName;
        private long errorCount;
        private long transactionCount;

        private Builder() {
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.checkNotIsSet(this.transactionNameIsSet(), "transactionName");
            this.transactionName = transactionName;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder errorCount(long errorCount) {
            this.checkNotIsSet(this.errorCountIsSet(), "errorCount");
            this.errorCount = errorCount;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder transactionCount(long transactionCount) {
            this.checkNotIsSet(this.transactionCountIsSet(), "transactionCount");
            this.transactionCount = transactionCount;
            this.initializedBitset |= 2L;
            return this;
        }

        public ErrorSummary build() {
            this.checkRequiredAttributes();
            return new ErrorSummary(this.transactionName, this.errorCount, this.transactionCount);
        }

        private boolean transactionNameIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean errorCountIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean transactionCountIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ErrorSummary is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.errorCountIsSet()) {
                attributes.add("errorCount");
            }
            if (!this.transactionCountIsSet()) {
                attributes.add("transactionCount");
            }
            return "Cannot build ErrorSummary, some of required attributes are not set " + attributes;
        }
    }
}

