/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import javax.annotation.Nullable;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ErrorSummaryBase {
    public static final Ordering<ErrorSummaryBase> orderingByErrorCountDesc = new Ordering<ErrorSummaryBase>(){

        @Override
        public int compare(@Nullable ErrorSummaryBase left, @Nullable ErrorSummaryBase right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            return Longs.compare(right.errorCount(), left.errorCount());
        }
    };
    public static final Ordering<ErrorSummaryBase> orderingByErrorRateDesc = new Ordering<ErrorSummaryBase>(){

        @Override
        public int compare(@Nullable ErrorSummaryBase left, @Nullable ErrorSummaryBase right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            return Doubles.compare((double)right.errorCount() / (double)right.transactionCount(), (double)left.errorCount() / (double)left.transactionCount());
        }
    };

    @Nullable
    public abstract String transactionName();

    public abstract long errorCount();

    public abstract long transactionCount();
}

