/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.collector;

import javax.annotation.Nullable;
import org.glowroot.collector.TransactionSummary;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TransactionSummaryBase {
    public static final Ordering<TransactionSummary> orderingByTotalTimeDesc = new Ordering<TransactionSummary>(){

        @Override
        public int compare(@Nullable TransactionSummary left, @Nullable TransactionSummary right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            return Longs.compare(right.totalMicros(), left.totalMicros());
        }
    };
    public static final Ordering<TransactionSummary> orderingByAverageTimeDesc = new Ordering<TransactionSummary>(){

        @Override
        public int compare(@Nullable TransactionSummary left, @Nullable TransactionSummary right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            return Doubles.compare((double)right.totalMicros() / (double)right.transactionCount(), (double)left.totalMicros() / (double)left.transactionCount());
        }
    };
    public static final Ordering<TransactionSummary> orderingByTransactionCountDesc = new Ordering<TransactionSummary>(){

        @Override
        public int compare(@Nullable TransactionSummary left, @Nullable TransactionSummary right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            return Longs.compare(right.transactionCount(), left.transactionCount());
        }
    };

    @Nullable
    public abstract String transactionName();

    public abstract long totalMicros();

    public abstract long transactionCount();
}

