/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;

public class ClassNames {
    private ClassNames() {
    }

    @PolyNull
    public static String fromInternalName(@PolyNull String internalName) {
        if (internalName == null) {
            return null;
        }
        return internalName.replace('/', '.');
    }

    public static String toInternalName(String className) {
        return className.replace('.', '/');
    }

    public static ImmutableList<String> fromInternalNames(String[] internalNames) {
        if (internalNames == null) {
            return ImmutableList.of();
        }
        ArrayList<String> classNames = Lists.newArrayList();
        for (String internalName : internalNames) {
            classNames.add(internalName.replace('/', '.'));
        }
        return ImmutableList.copyOf(classNames);
    }
}

