/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public abstract class ScheduledRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledRunnable.class);
    @MonotonicNonNull
    private volatile ScheduledFuture<?> future;

    public void scheduleWithFixedDelay(ScheduledExecutorService scheduledExecutor, long initialDelay, long period, TimeUnit unit) {
        if (this.future != null) {
            logger.error("command has already been scheduled: {}", (Object)this);
            return;
        }
        this.future = scheduledExecutor.scheduleWithFixedDelay(this, initialDelay, period, unit);
    }

    public void scheduleAtFixedRate(ScheduledExecutorService scheduledExecutor, long initialDelay, long period, TimeUnit unit) {
        if (this.future != null) {
            logger.error("command has already been scheduled: {}", (Object)this);
            return;
        }
        this.future = scheduledExecutor.scheduleAtFixedRate(this, initialDelay, period, unit);
    }

    @Override
    public void run() {
        try {
            this.runInternal();
        }
        catch (TerminateSubsequentExecutionsException e) {
            logger.debug(e.getMessage(), e);
            throw e;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    protected abstract void runInternal() throws Exception;

    public static class TerminateSubsequentExecutionsException
    extends RuntimeException {
    }
}

