/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.common;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.glowroot.shaded.google.common.collect.Lists;

public abstract class Traverser<T, E extends Exception> {
    private static final Object ALREADY_TRAVERSED_MARKER = new Object();
    private final Deque<Object> stack = new ArrayDeque<Object>();

    public Traverser(T root) {
        this.stack.push(root);
    }

    public void traverse() throws E {
        while (!this.stack.isEmpty()) {
            Object popped = this.stack.pop();
            if (popped == ALREADY_TRAVERSED_MARKER) {
                this.revisitAfterChildren(this.stack.pop());
                continue;
            }
            Object unprocessed = popped;
            List<Object> childNodes = this.visit(unprocessed);
            if (childNodes.isEmpty()) {
                this.revisitAfterChildren(unprocessed);
                continue;
            }
            this.stack.push(unprocessed);
            this.stack.push(ALREADY_TRAVERSED_MARKER);
            for (Object childNode : Lists.reverse(childNodes)) {
                this.stack.push(childNode);
            }
        }
    }

    public abstract List<T> visit(T var1) throws E;

    public abstract void revisitAfterChildren(T var1) throws E;
}

