/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.AlertConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;

@ParametersAreNonnullByDefault
@Immutable
public final class AlertConfig
extends AlertConfigBase {
    private final String transactionType;
    private final double percentile;
    private final int timePeriodMinutes;
    private final int thresholdMillis;
    private final int minTransactionCount;
    private final ImmutableList<String> emailAddresses;
    private final String version;

    private AlertConfig(String transactionType, double percentile, int timePeriodMinutes, int thresholdMillis, int minTransactionCount, ImmutableList<String> emailAddresses) {
        this.transactionType = transactionType;
        this.percentile = percentile;
        this.timePeriodMinutes = timePeriodMinutes;
        this.thresholdMillis = thresholdMillis;
        this.minTransactionCount = minTransactionCount;
        this.emailAddresses = emailAddresses;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @JsonProperty(value="percentile")
    public double percentile() {
        return this.percentile;
    }

    @Override
    @JsonProperty(value="timePeriodMinutes")
    public int timePeriodMinutes() {
        return this.timePeriodMinutes;
    }

    @Override
    @JsonProperty(value="thresholdMillis")
    public int thresholdMillis() {
        return this.thresholdMillis;
    }

    @Override
    @JsonProperty(value="minTransactionCount")
    public int minTransactionCount() {
        return this.minTransactionCount;
    }

    @Override
    @JsonProperty(value="emailAddresses")
    public ImmutableList<String> emailAddresses() {
        return this.emailAddresses;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final AlertConfig withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new AlertConfig(newValue, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, this.emailAddresses);
    }

    public final AlertConfig withPercentile(double value) {
        double newValue = value;
        return new AlertConfig(this.transactionType, newValue, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, this.emailAddresses);
    }

    public final AlertConfig withTimePeriodMinutes(int value) {
        if (this.timePeriodMinutes == value) {
            return this;
        }
        int newValue = value;
        return new AlertConfig(this.transactionType, this.percentile, newValue, this.thresholdMillis, this.minTransactionCount, this.emailAddresses);
    }

    public final AlertConfig withThresholdMillis(int value) {
        if (this.thresholdMillis == value) {
            return this;
        }
        int newValue = value;
        return new AlertConfig(this.transactionType, this.percentile, this.timePeriodMinutes, newValue, this.minTransactionCount, this.emailAddresses);
    }

    public final AlertConfig withMinTransactionCount(int value) {
        if (this.minTransactionCount == value) {
            return this;
        }
        int newValue = value;
        return new AlertConfig(this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, newValue, this.emailAddresses);
    }

    public final AlertConfig withEmailAddresses(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AlertConfig(this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, newValue);
    }

    public final AlertConfig withEmailAddresses(Iterable<String> elements) {
        if (this.emailAddresses == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new AlertConfig(this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AlertConfig && this.equalTo((AlertConfig)another);
    }

    private boolean equalTo(AlertConfig another) {
        return this.transactionType.equals(another.transactionType) && Double.doubleToLongBits(this.percentile) == Double.doubleToLongBits(another.percentile) && this.timePeriodMinutes == another.timePeriodMinutes && this.thresholdMillis == another.thresholdMillis && this.minTransactionCount == another.minTransactionCount && this.emailAddresses.equals(another.emailAddresses) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + Doubles.hashCode(this.percentile);
        h = h * 17 + this.timePeriodMinutes;
        h = h * 17 + this.thresholdMillis;
        h = h * 17 + this.minTransactionCount;
        h = h * 17 + this.emailAddresses.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AlertConfig").add("transactionType", this.transactionType).add("percentile", this.percentile).add("timePeriodMinutes", this.timePeriodMinutes).add("thresholdMillis", this.thresholdMillis).add("minTransactionCount", this.minTransactionCount).add("emailAddresses", this.emailAddresses).add("version", this.version).toString();
    }

    @JsonCreator
    public static AlertConfig fromAllAttributes(@JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="percentile") @Nullable Double percentile, @JsonProperty(value="timePeriodMinutes") @Nullable Integer timePeriodMinutes, @JsonProperty(value="thresholdMillis") @Nullable Integer thresholdMillis, @JsonProperty(value="minTransactionCount") @Nullable Integer minTransactionCount, @JsonProperty(value="emailAddresses") @Nullable ImmutableList<String> emailAddresses) {
        Builder builder = AlertConfig.builder();
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (percentile != null) {
            builder.percentile(percentile);
        }
        if (timePeriodMinutes != null) {
            builder.timePeriodMinutes(timePeriodMinutes);
        }
        if (thresholdMillis != null) {
            builder.thresholdMillis(thresholdMillis);
        }
        if (minTransactionCount != null) {
            builder.minTransactionCount(minTransactionCount);
        }
        if (emailAddresses != null) {
            builder.addAllEmailAddresses(emailAddresses);
        }
        return builder.build();
    }

    public static AlertConfig copyOf(AlertConfigBase instance) {
        if (instance instanceof AlertConfig) {
            return (AlertConfig)instance;
        }
        return AlertConfig.builder().transactionType(instance.transactionType()).percentile(instance.percentile()).timePeriodMinutes(instance.timePeriodMinutes()).thresholdMillis(instance.thresholdMillis()).minTransactionCount(instance.minTransactionCount()).addAllEmailAddresses(instance.emailAddresses()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 31L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 1L;
        private static final long INITIALIZED_BIT_PERCENTILE = 2L;
        private static final long INITIALIZED_BIT_TIME_PERIOD_MINUTES = 4L;
        private static final long INITIALIZED_BIT_THRESHOLD_MILLIS = 8L;
        private static final long INITIALIZED_BIT_MIN_TRANSACTION_COUNT = 16L;
        private long initializedBitset;
        @Nullable
        private String transactionType;
        private double percentile;
        private int timePeriodMinutes;
        private int thresholdMillis;
        private int minTransactionCount;
        private ImmutableList.Builder<String> emailAddressesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder transactionType(String transactionType) {
            this.checkNotIsSet(this.transactionTypeIsSet(), "transactionType");
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder percentile(double percentile) {
            this.checkNotIsSet(this.percentileIsSet(), "percentile");
            this.percentile = percentile;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder timePeriodMinutes(int timePeriodMinutes) {
            this.checkNotIsSet(this.timePeriodMinutesIsSet(), "timePeriodMinutes");
            this.timePeriodMinutes = timePeriodMinutes;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder thresholdMillis(int thresholdMillis) {
            this.checkNotIsSet(this.thresholdMillisIsSet(), "thresholdMillis");
            this.thresholdMillis = thresholdMillis;
            this.initializedBitset |= 8L;
            return this;
        }

        public final Builder minTransactionCount(int minTransactionCount) {
            this.checkNotIsSet(this.minTransactionCountIsSet(), "minTransactionCount");
            this.minTransactionCount = minTransactionCount;
            this.initializedBitset |= 0x10L;
            return this;
        }

        public final Builder addEmailAddresses(String element) {
            this.emailAddressesBuilder.add((Object)element);
            return this;
        }

        public final Builder addEmailAddresses(String ... elements) {
            this.emailAddressesBuilder.add(elements);
            return this;
        }

        public final Builder addAllEmailAddresses(Iterable<String> elements) {
            this.emailAddressesBuilder.addAll((Iterable)elements);
            return this;
        }

        public AlertConfig build() {
            this.checkRequiredAttributes();
            return new AlertConfig(this.transactionType, this.percentile, this.timePeriodMinutes, this.thresholdMillis, this.minTransactionCount, (ImmutableList)this.emailAddressesBuilder.build());
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean percentileIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean timePeriodMinutesIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean thresholdMillisIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private boolean minTransactionCountIsSet() {
            return (this.initializedBitset & 0x10L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of AlertConfig is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 31L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            if (!this.percentileIsSet()) {
                attributes.add("percentile");
            }
            if (!this.timePeriodMinutesIsSet()) {
                attributes.add("timePeriodMinutes");
            }
            if (!this.thresholdMillisIsSet()) {
                attributes.add("thresholdMillis");
            }
            if (!this.minTransactionCountIsSet()) {
                attributes.add("minTransactionCount");
            }
            return "Cannot build AlertConfig, some of required attributes are not set " + attributes;
        }
    }
}

