/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.common.Encryption;
import org.glowroot.common.ObjectMappers;
import org.glowroot.config.AdvancedConfig;
import org.glowroot.config.AlertConfig;
import org.glowroot.config.Config;
import org.glowroot.config.ConfigFile;
import org.glowroot.config.GaugeConfig;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.config.PluginConfig;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.config.RollupConfig;
import org.glowroot.config.SmtpConfig;
import org.glowroot.config.StorageConfig;
import org.glowroot.config.TransactionConfig;
import org.glowroot.config.UserInterfaceConfig;
import org.glowroot.config.UserRecordingConfig;
import org.glowroot.markers.OnlyUsedByTests;
import org.glowroot.plugin.api.config.ConfigListener;
import org.glowroot.shaded.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.shaded.google.common.base.Joiner;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ArrayListMultimap;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Multimap;
import org.glowroot.shaded.google.common.collect.Multimaps;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.google.common.io.Files;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class ConfigService {
    private static final long ROLLUP_0_INTERVAL_MILLIS = Long.getLong("glowroot.internal.rollup.0.intervalMillis", 60000L);
    private static final long ROLLUP_1_INTERVAL_MILLIS = Long.getLong("glowroot.internal.rollup.1.intervalMillis", 300000L);
    private static final long ROLLUP_2_INTERVAL_MILLIS = Long.getLong("glowroot.internal.rollup.2.intervalMillis", 1800000L);
    private static final Logger logger = LoggerFactory.getLogger(ConfigService.class);
    private final ConfigFile configFile;
    private final ImmutableList<PluginDescriptor> pluginDescriptors;
    private final File secretFile;
    private final Object writeLock = new Object();
    private final Set<ConfigListener> configListeners = Sets.newCopyOnWriteArraySet();
    private final Multimap<String, ConfigListener> pluginConfigListeners = Multimaps.synchronizedMultimap(ArrayListMultimap.create());
    private final ImmutableList<RollupConfig> rollupConfigs;
    private volatile Config config;
    @MonotonicNonNull
    private SecretKey secretKey;
    private volatile boolean memoryBarrier;

    ConfigService(File baseDir, List<PluginDescriptor> pluginDescriptors) {
        this.configFile = new ConfigFile(new File(baseDir, "config.json"), pluginDescriptors);
        this.pluginDescriptors = ImmutableList.copyOf(pluginDescriptors);
        this.secretFile = new File(baseDir, "secret");
        this.rollupConfigs = ImmutableList.of(RollupConfig.of(ROLLUP_0_INTERVAL_MILLIS, ROLLUP_0_INTERVAL_MILLIS * 15L), RollupConfig.of(ROLLUP_1_INTERVAL_MILLIS, ROLLUP_1_INTERVAL_MILLIS * 12L), RollupConfig.of(ROLLUP_2_INTERVAL_MILLIS, ROLLUP_2_INTERVAL_MILLIS * 16L));
        try {
            this.config = this.configFile.loadConfig();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            this.config = this.configFile.getDefaultConfig();
        }
        for (InstrumentationConfig instrumentationConfig : this.config.instrumentationConfigs()) {
            ImmutableList<String> errors = instrumentationConfig.validationErrors();
            if (errors.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid instrumentation config: ");
            sb.append(Joiner.on(", ").join(errors));
            sb.append(" ");
            try {
                sb.append(ObjectMappers.create().writeValueAsString(instrumentationConfig));
            }
            catch (JsonProcessingException e) {
                logger.error(e.getMessage(), e);
            }
            logger.error(sb.toString());
        }
    }

    public TransactionConfig getTransactionConfig() {
        return this.config.transactionConfig();
    }

    public UserInterfaceConfig getUserInterfaceConfig() {
        return this.config.userInterfaceConfig();
    }

    public StorageConfig getStorageConfig() {
        return this.config.storageConfig();
    }

    public SmtpConfig getSmtpConfig() {
        return this.config.smtpConfig();
    }

    public UserRecordingConfig getUserRecordingConfig() {
        return this.config.userRecordingConfig();
    }

    public AdvancedConfig getAdvancedConfig() {
        return this.config.advancedConfig();
    }

    @Nullable
    public PluginConfig getPluginConfig(String pluginId) {
        for (PluginConfig pluginConfig : this.config.pluginConfigs()) {
            if (!pluginId.equals(pluginConfig.id())) continue;
            return pluginConfig;
        }
        return null;
    }

    public List<InstrumentationConfig> getInstrumentationConfigs() {
        return this.config.instrumentationConfigs();
    }

    @Nullable
    public InstrumentationConfig getInstrumentationConfig(String version) {
        for (InstrumentationConfig instrumentationConfig : this.config.instrumentationConfigs()) {
            if (!instrumentationConfig.version().equals(version)) continue;
            return instrumentationConfig;
        }
        return null;
    }

    public List<GaugeConfig> getGaugeConfigs() {
        return this.config.gaugeConfigs();
    }

    @Nullable
    public GaugeConfig getGaugeConfig(String version) {
        for (GaugeConfig gaugeConfig : this.config.gaugeConfigs()) {
            if (!gaugeConfig.version().equals(version)) continue;
            return gaugeConfig;
        }
        return null;
    }

    public List<AlertConfig> getAlertConfigs() {
        return this.config.alertConfigs();
    }

    @Nullable
    public AlertConfig getAlertConfig(String version) {
        for (AlertConfig alertConfig : this.config.alertConfigs()) {
            if (!alertConfig.version().equals(version)) continue;
            return alertConfig;
        }
        return null;
    }

    public ImmutableList<RollupConfig> getRollupConfigs() {
        return this.rollupConfigs;
    }

    public void addConfigListener(ConfigListener listener) {
        this.configListeners.add(listener);
        listener.onChange();
    }

    public void addPluginConfigListener(String pluginId, ConfigListener listener) {
        this.pluginConfigListeners.put(pluginId, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateTransactionConfig(TransactionConfig transactionConfig, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            this.checkVersionsEqual(this.config.transactionConfig().version(), priorVersion);
            Config updatedConfig = this.config.withTransactionConfig(transactionConfig);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return transactionConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateUserInterfaceConfig(UserInterfaceConfig userInterfaceConfig, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            this.checkVersionsEqual(this.config.userInterfaceConfig().version(), priorVersion);
            Config updatedConfig = this.config.withUserInterfaceConfig(userInterfaceConfig);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return userInterfaceConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateStorageConfig(StorageConfig storageConfig, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            this.checkVersionsEqual(this.config.storageConfig().version(), priorVersion);
            Config updatedConfig = this.config.withStorageConfig(storageConfig);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return storageConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateSmtpConfig(SmtpConfig smtpConfig, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            this.checkVersionsEqual(this.config.smtpConfig().version(), priorVersion);
            Config updatedConfig = this.config.withSmtpConfig(smtpConfig);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return smtpConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateUserRecordingConfig(UserRecordingConfig userRecordingConfig, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            this.checkVersionsEqual(this.config.userRecordingConfig().version(), priorVersion);
            Config updatedConfig = this.config.withUserRecordingConfig(userRecordingConfig);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return userRecordingConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateAdvancedConfig(AdvancedConfig advancedConfig, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            this.checkVersionsEqual(this.config.advancedConfig().version(), priorVersion);
            Config updatedConfig = this.config.withAdvancedConfig(advancedConfig);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return advancedConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updatePluginConfig(PluginConfig pluginConfig, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<PluginConfig> pluginConfigs = Lists.newArrayList(this.config.pluginConfigs());
            boolean found = false;
            ListIterator<PluginConfig> i = pluginConfigs.listIterator();
            while (i.hasNext()) {
                PluginConfig loopPluginConfig = (PluginConfig)i.next();
                if (!pluginConfig.id().equals(loopPluginConfig.id())) continue;
                this.checkVersionsEqual(loopPluginConfig.version(), priorVersion);
                i.set(pluginConfig);
                found = true;
                break;
            }
            Preconditions.checkState(found, "Plugin config not found: %s", pluginConfig.id());
            Config updatedConfig = this.config.withPluginConfigs(pluginConfigs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyPluginConfigListeners(pluginConfig.id());
        return pluginConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertInstrumentationConfig(InstrumentationConfig instrumentationConfig) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<InstrumentationConfig> configs = Lists.newArrayList(this.config.instrumentationConfigs());
            configs.add(instrumentationConfig);
            Config updatedConfig = this.config.withInstrumentationConfigs(configs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return instrumentationConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateInstrumentationConfig(InstrumentationConfig instrumentationConfig, String priorVersion) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<InstrumentationConfig> configs = Lists.newArrayList(this.config.instrumentationConfigs());
            boolean found = false;
            ListIterator<InstrumentationConfig> i = configs.listIterator();
            while (i.hasNext()) {
                if (!priorVersion.equals(((InstrumentationConfig)i.next()).version())) continue;
                i.set(instrumentationConfig);
                found = true;
                break;
            }
            Preconditions.checkState(found, "Instrumentation config not found: %s", priorVersion);
            Config updatedConfig = this.config.withInstrumentationConfigs(configs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return instrumentationConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInstrumentationConfig(String version) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<InstrumentationConfig> configs = Lists.newArrayList(this.config.instrumentationConfigs());
            boolean found = false;
            ListIterator i = configs.listIterator();
            while (i.hasNext()) {
                if (!version.equals(((InstrumentationConfig)i.next()).version())) continue;
                i.remove();
                found = true;
                break;
            }
            Preconditions.checkState(found, "Instrumentation config not found: %s", version);
            Config updatedConfig = this.config.withInstrumentationConfigs(configs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertGaugeConfig(GaugeConfig gaugeConfig) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<GaugeConfig> gaugeConfigs = Lists.newArrayList(this.config.gaugeConfigs());
            for (GaugeConfig loopConfig : gaugeConfigs) {
                if (!loopConfig.mbeanObjectName().equals(gaugeConfig.mbeanObjectName())) continue;
                throw new DuplicateMBeanObjectNameException();
            }
            gaugeConfigs.add(gaugeConfig);
            Config updatedConfig = this.config.withGaugeConfigs(gaugeConfigs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return gaugeConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateGaugeConfig(GaugeConfig gaugeConfig, String priorVersion) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<GaugeConfig> gaugeConfigs = Lists.newArrayList(this.config.gaugeConfigs());
            boolean found = false;
            ListIterator<GaugeConfig> i = gaugeConfigs.listIterator();
            while (i.hasNext()) {
                GaugeConfig loopConfig = (GaugeConfig)i.next();
                if (priorVersion.equals(loopConfig.version())) {
                    i.set(gaugeConfig);
                    found = true;
                    break;
                }
                if (!loopConfig.mbeanObjectName().equals(gaugeConfig.mbeanObjectName())) continue;
                throw new DuplicateMBeanObjectNameException();
            }
            Preconditions.checkState(found, "Gauge config not found: %s", priorVersion);
            Config updatedConfig = this.config.withGaugeConfigs(gaugeConfigs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return gaugeConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGaugeConfig(String version) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<GaugeConfig> gaugeConfigs = Lists.newArrayList(this.config.gaugeConfigs());
            boolean found = false;
            ListIterator i = gaugeConfigs.listIterator();
            while (i.hasNext()) {
                if (!version.equals(((GaugeConfig)i.next()).version())) continue;
                i.remove();
                found = true;
                break;
            }
            Preconditions.checkState(found, "Gauge config not found: %s", version);
            Config updatedConfig = this.config.withGaugeConfigs(gaugeConfigs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String insertAlertConfig(AlertConfig alertConfig) throws Exception {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<AlertConfig> alertConfigs = Lists.newArrayList(this.config.alertConfigs());
            alertConfigs.add(alertConfig);
            Config updatedConfig = this.config.withAlertConfigs(alertConfigs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return alertConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateAlertConfig(AlertConfig alertConfig, String priorVersion) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<AlertConfig> alertConfigs = Lists.newArrayList(this.config.alertConfigs());
            boolean found = false;
            ListIterator<AlertConfig> i = alertConfigs.listIterator();
            while (i.hasNext()) {
                if (!priorVersion.equals(((AlertConfig)i.next()).version())) continue;
                i.set(alertConfig);
                found = true;
                break;
            }
            Preconditions.checkState(found, "Alert config not found: %s", priorVersion);
            Config updatedConfig = this.config.withAlertConfigs(alertConfigs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
        return alertConfig.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAlertConfig(String version) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            ArrayList<AlertConfig> alertConfigs = Lists.newArrayList(this.config.alertConfigs());
            boolean found = false;
            ListIterator i = alertConfigs.listIterator();
            while (i.hasNext()) {
                if (!version.equals(((AlertConfig)i.next()).version())) continue;
                i.remove();
                found = true;
                break;
            }
            Preconditions.checkState(found, "Alert config not found: %s", version);
            Config updatedConfig = this.config.withAlertConfigs(alertConfigs);
            this.configFile.write(updatedConfig);
            this.config = updatedConfig;
        }
        this.notifyConfigListeners();
    }

    public String getDefaultDisplayedTransactionType() {
        String defaultDisplayedTransactionType = this.config.transactionConfig().defaultDisplayedTransactionType();
        if (!defaultDisplayedTransactionType.isEmpty()) {
            return defaultDisplayedTransactionType;
        }
        return this.configFile.getDefaultDisplayedTransactionType(this.config.instrumentationConfigs());
    }

    public ImmutableList<String> getAllTransactionTypes() {
        LinkedHashSet<String> transactionTypes = Sets.newLinkedHashSet();
        for (PluginDescriptor pluginDescriptor : this.pluginDescriptors) {
            PluginConfig pluginConfig = this.getPluginConfig(pluginDescriptor.id());
            if (pluginConfig == null || !pluginConfig.enabled()) continue;
            transactionTypes.addAll(pluginDescriptor.transactionTypes());
            ConfigService.addInstrumentationTransactionTypes(pluginDescriptor.instrumentationConfigs(), transactionTypes, pluginConfig);
        }
        ConfigService.addInstrumentationTransactionTypes(this.getInstrumentationConfigs(), transactionTypes, null);
        return ImmutableList.copyOf(transactionTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKey getSecretKey() throws Exception {
        File file = this.secretFile;
        synchronized (file) {
            if (this.secretKey == null) {
                if (this.secretFile.exists()) {
                    this.secretKey = Encryption.loadKey(this.secretFile);
                } else {
                    this.secretKey = Encryption.generateNewKey();
                    Files.write(this.secretKey.getEncoded(), this.secretFile);
                }
            }
            return this.secretKey;
        }
    }

    public boolean readMemoryBarrier() {
        return this.memoryBarrier;
    }

    public void writeMemoryBarrier() {
        this.memoryBarrier = true;
    }

    private void checkVersionsEqual(String version, String priorVersion) throws OptimisticLockException {
        if (!version.equals(priorVersion)) {
            throw new OptimisticLockException();
        }
    }

    private void notifyConfigListeners() {
        for (ConfigListener configListener : this.configListeners) {
            configListener.onChange();
        }
    }

    private void notifyPluginConfigListeners(String pluginId) {
        ImmutableList<ConfigListener> listeners = ImmutableList.copyOf(this.pluginConfigListeners.get(pluginId));
        for (ConfigListener listener : listeners) {
            listener.onChange();
        }
    }

    private void notifyAllPluginConfigListeners() {
        ImmutableList<ConfigListener> listeners = ImmutableList.copyOf(this.pluginConfigListeners.values());
        for (ConfigListener configListener : listeners) {
            configListener.onChange();
        }
    }

    @OnlyUsedByTests
    public void resetAllConfig() throws IOException {
        this.configFile.delete();
        this.config = this.configFile.loadConfig();
        this.notifyConfigListeners();
        this.notifyAllPluginConfigListeners();
    }

    private static void addInstrumentationTransactionTypes(List<InstrumentationConfig> configs, Set<String> transactionTypes, @Nullable PluginConfig pluginConfig) {
        for (InstrumentationConfig config : configs) {
            String transactionType = config.transactionType();
            if (transactionType.isEmpty() || pluginConfig != null && !ConfigService.isEnabled(config, pluginConfig)) continue;
            transactionTypes.add(transactionType);
        }
    }

    private static boolean isEnabled(InstrumentationConfig config, PluginConfig pluginConfig) {
        return ConfigService.isEnabled(config.enabledProperty(), pluginConfig) && ConfigService.isEnabled(config.traceEntryEnabledProperty(), pluginConfig);
    }

    private static boolean isEnabled(String propertyName, PluginConfig pluginConfig) {
        return propertyName.isEmpty() || pluginConfig.getBooleanProperty(propertyName);
    }

    public static class DuplicateMBeanObjectNameException
    extends Exception {
    }

    public static class OptimisticLockException
    extends Exception {
    }
}

