/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.Locale;
import javax.annotation.Nullable;
import org.glowroot.config.InstrumentationConfig;
import org.glowroot.config.PluginDescriptor;
import org.glowroot.config.PropertyDescriptor;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Ordering;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PluginDescriptorBase {
    static final Ordering<PluginDescriptor> specialOrderingByName = new Ordering<PluginDescriptor>(){

        @Override
        public int compare(@Nullable PluginDescriptor left, @Nullable PluginDescriptor right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            String leftName = PluginDescriptorBase.stripEndingIgnoreCase(left.name(), " Plugin");
            String rightName = PluginDescriptorBase.stripEndingIgnoreCase(right.name(), " Plugin");
            return leftName.compareToIgnoreCase(rightName);
        }
    };
    static final Ordering<PluginDescriptor> orderingById = new Ordering<PluginDescriptor>(){

        @Override
        public int compare(@Nullable PluginDescriptor left, @Nullable PluginDescriptor right) {
            Preconditions.checkNotNull(left);
            Preconditions.checkNotNull(right);
            return left.id().compareToIgnoreCase(right.id());
        }
    };

    public abstract String name();

    public abstract String id();

    public abstract ImmutableList<String> transactionTypes();

    public abstract ImmutableList<String> transactionCustomAttributes();

    public abstract ImmutableList<PropertyDescriptor> properties();

    @JsonProperty(value="instrumentation")
    public abstract ImmutableList<InstrumentationConfig> instrumentationConfigs();

    public abstract ImmutableList<String> aspects();

    private static String stripEndingIgnoreCase(String original, String ending) {
        if (original.toUpperCase(Locale.ENGLISH).endsWith(ending.toUpperCase(Locale.ENGLISH))) {
            return original.substring(0, original.length() - ending.length());
        }
        return original;
    }
}

