/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import org.glowroot.config.PropertyType;
import org.glowroot.config.PropertyValue;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PropertyDescriptorBase {
    private static final Logger logger = LoggerFactory.getLogger(PropertyDescriptorBase.class);

    public abstract String name();

    public abstract PropertyType type();

    @JsonProperty(value="default")
    @Nullable
    abstract PropertyValue defaultValue();

    public boolean hidden() {
        return false;
    }

    public abstract String label();

    public String checkboxLabel() {
        return "";
    }

    public String description() {
        return "";
    }

    PropertyValue getValidatedNonNullDefaultValue() {
        PropertyValue defaultValue = this.defaultValue();
        if (defaultValue == null) {
            return PropertyValue.getDefaultValue(this.type());
        }
        Object value = defaultValue.value();
        if (value == null) {
            return PropertyValue.getDefaultValue(this.type());
        }
        if (PropertyDescriptorBase.isValidType(value, this.type())) {
            return new PropertyValue(value);
        }
        logger.warn("invalid default value for plugin property: {}", (Object)this.name());
        return PropertyValue.getDefaultValue(this.type());
    }

    static boolean isValidType(Object value, PropertyType type) {
        switch (type) {
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case STRING: {
                return value instanceof String;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
        }
        throw new AssertionError((Object)("Unexpected property type: " + (Object)((Object)type)));
    }
}

