/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.io.IOException;
import org.glowroot.config.PropertyValue;
import org.glowroot.shaded.fasterxml.jackson.core.JsonParser;
import org.glowroot.shaded.fasterxml.jackson.core.JsonToken;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonDeserializer;

class PropertyValueDeserializer
extends JsonDeserializer<PropertyValue> {
    PropertyValueDeserializer() {
    }

    @Override
    public PropertyValue deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonToken token = parser.getCurrentToken();
        switch (token) {
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return new PropertyValue(parser.getBooleanValue());
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return new PropertyValue(parser.getDoubleValue());
            }
            case VALUE_STRING: {
                return new PropertyValue(parser.getText());
            }
        }
        throw new AssertionError((Object)("Unexpected json type: " + (Object)((Object)token)));
    }

    @Override
    public PropertyValue getNullValue(DeserializationContext ctxt) {
        return new PropertyValue(null);
    }
}

