/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.RollupConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
public final class RollupConfig
extends RollupConfigBase {
    private final long intervalMillis;
    private final long viewThresholdMillis;

    private RollupConfig(long intervalMillis, long viewThresholdMillis) {
        this.intervalMillis = intervalMillis;
        this.viewThresholdMillis = viewThresholdMillis;
    }

    @Override
    @JsonProperty(value="intervalMillis")
    public long intervalMillis() {
        return this.intervalMillis;
    }

    @Override
    @JsonProperty(value="viewThresholdMillis")
    public long viewThresholdMillis() {
        return this.viewThresholdMillis;
    }

    public final RollupConfig withIntervalMillis(long value) {
        if (this.intervalMillis == value) {
            return this;
        }
        long newValue = value;
        return new RollupConfig(newValue, this.viewThresholdMillis);
    }

    public final RollupConfig withViewThresholdMillis(long value) {
        if (this.viewThresholdMillis == value) {
            return this;
        }
        long newValue = value;
        return new RollupConfig(this.intervalMillis, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof RollupConfig && this.equalTo((RollupConfig)another);
    }

    private boolean equalTo(RollupConfig another) {
        return this.intervalMillis == another.intervalMillis && this.viewThresholdMillis == another.viewThresholdMillis;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.intervalMillis);
        h = h * 17 + Longs.hashCode(this.viewThresholdMillis);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("RollupConfig").add("intervalMillis", this.intervalMillis).add("viewThresholdMillis", this.viewThresholdMillis).toString();
    }

    @JsonCreator
    public static RollupConfig fromAllAttributes(@JsonProperty(value="intervalMillis") @Nullable Long intervalMillis, @JsonProperty(value="viewThresholdMillis") @Nullable Long viewThresholdMillis) {
        Builder builder = RollupConfig.builder();
        if (intervalMillis != null) {
            builder.intervalMillis(intervalMillis);
        }
        if (viewThresholdMillis != null) {
            builder.viewThresholdMillis(viewThresholdMillis);
        }
        return builder.build();
    }

    public static RollupConfig of(long intervalMillis, long viewThresholdMillis) {
        return new RollupConfig(intervalMillis, viewThresholdMillis);
    }

    public static RollupConfig copyOf(RollupConfigBase instance) {
        if (instance instanceof RollupConfig) {
            return (RollupConfig)instance;
        }
        return RollupConfig.builder().intervalMillis(instance.intervalMillis()).viewThresholdMillis(instance.viewThresholdMillis()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_INTERVAL_MILLIS = 1L;
        private static final long INITIALIZED_BIT_VIEW_THRESHOLD_MILLIS = 2L;
        private long initializedBitset;
        private long intervalMillis;
        private long viewThresholdMillis;

        private Builder() {
        }

        public final Builder intervalMillis(long intervalMillis) {
            this.checkNotIsSet(this.intervalMillisIsSet(), "intervalMillis");
            this.intervalMillis = intervalMillis;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder viewThresholdMillis(long viewThresholdMillis) {
            this.checkNotIsSet(this.viewThresholdMillisIsSet(), "viewThresholdMillis");
            this.viewThresholdMillis = viewThresholdMillis;
            this.initializedBitset |= 2L;
            return this;
        }

        public RollupConfig build() {
            this.checkRequiredAttributes();
            return new RollupConfig(this.intervalMillis, this.viewThresholdMillis);
        }

        private boolean intervalMillisIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean viewThresholdMillisIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RollupConfig is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.intervalMillisIsSet()) {
                attributes.add("intervalMillis");
            }
            if (!this.viewThresholdMillisIsSet()) {
                attributes.add("viewThresholdMillis");
            }
            return "Cannot build RollupConfig, some of required attributes are not set " + attributes;
        }
    }
}

