/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.StorageConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;

@ParametersAreNonnullByDefault
@Immutable
public final class StorageConfig
extends StorageConfigBase {
    private final ImmutableList<Integer> rollupExpirationHours;
    private final int traceExpirationHours;
    private final ImmutableList<Integer> rollupCappedDatabaseSizesMb;
    private final int traceCappedDatabaseSizeMb;
    private final String version;

    private StorageConfig(Builder builder) {
        this.rollupExpirationHours = builder.rollupExpirationHours != null ? builder.rollupExpirationHours : Preconditions.checkNotNull(super.rollupExpirationHours());
        this.traceExpirationHours = builder.traceExpirationHoursIsSet() ? builder.traceExpirationHours : super.traceExpirationHours();
        this.rollupCappedDatabaseSizesMb = builder.rollupCappedDatabaseSizesMb != null ? builder.rollupCappedDatabaseSizesMb : Preconditions.checkNotNull(super.rollupCappedDatabaseSizesMb());
        this.traceCappedDatabaseSizeMb = builder.traceCappedDatabaseSizeMbIsSet() ? builder.traceCappedDatabaseSizeMb : super.traceCappedDatabaseSizeMb();
        this.version = Preconditions.checkNotNull(super.version());
    }

    private StorageConfig(ImmutableList<Integer> rollupExpirationHours, int traceExpirationHours, ImmutableList<Integer> rollupCappedDatabaseSizesMb, int traceCappedDatabaseSizeMb) {
        this.rollupExpirationHours = rollupExpirationHours;
        this.traceExpirationHours = traceExpirationHours;
        this.rollupCappedDatabaseSizesMb = rollupCappedDatabaseSizesMb;
        this.traceCappedDatabaseSizeMb = traceCappedDatabaseSizeMb;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="rollupExpirationHours")
    public ImmutableList<Integer> rollupExpirationHours() {
        return this.rollupExpirationHours;
    }

    @Override
    @JsonProperty(value="traceExpirationHours")
    public int traceExpirationHours() {
        return this.traceExpirationHours;
    }

    @Override
    @JsonProperty(value="rollupCappedDatabaseSizesMb")
    public ImmutableList<Integer> rollupCappedDatabaseSizesMb() {
        return this.rollupCappedDatabaseSizesMb;
    }

    @Override
    @JsonProperty(value="traceCappedDatabaseSizeMb")
    public int traceCappedDatabaseSizeMb() {
        return this.traceCappedDatabaseSizeMb;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final StorageConfig withRollupExpirationHours(ImmutableList<Integer> value) {
        if (this.rollupExpirationHours == value) {
            return this;
        }
        ImmutableList<Integer> newValue = Preconditions.checkNotNull(value);
        return new StorageConfig(newValue, this.traceExpirationHours, this.rollupCappedDatabaseSizesMb, this.traceCappedDatabaseSizeMb);
    }

    public final StorageConfig withTraceExpirationHours(int value) {
        if (this.traceExpirationHours == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfig(this.rollupExpirationHours, newValue, this.rollupCappedDatabaseSizesMb, this.traceCappedDatabaseSizeMb);
    }

    public final StorageConfig withRollupCappedDatabaseSizesMb(ImmutableList<Integer> value) {
        if (this.rollupCappedDatabaseSizesMb == value) {
            return this;
        }
        ImmutableList<Integer> newValue = Preconditions.checkNotNull(value);
        return new StorageConfig(this.rollupExpirationHours, this.traceExpirationHours, newValue, this.traceCappedDatabaseSizeMb);
    }

    public final StorageConfig withTraceCappedDatabaseSizeMb(int value) {
        if (this.traceCappedDatabaseSizeMb == value) {
            return this;
        }
        int newValue = value;
        return new StorageConfig(this.rollupExpirationHours, this.traceExpirationHours, this.rollupCappedDatabaseSizesMb, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof StorageConfig && this.equalTo((StorageConfig)another);
    }

    private boolean equalTo(StorageConfig another) {
        return this.rollupExpirationHours.equals(another.rollupExpirationHours) && this.traceExpirationHours == another.traceExpirationHours && this.rollupCappedDatabaseSizesMb.equals(another.rollupCappedDatabaseSizesMb) && this.traceCappedDatabaseSizeMb == another.traceCappedDatabaseSizeMb && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.rollupExpirationHours.hashCode();
        h = h * 17 + this.traceExpirationHours;
        h = h * 17 + this.rollupCappedDatabaseSizesMb.hashCode();
        h = h * 17 + this.traceCappedDatabaseSizeMb;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StorageConfig").add("rollupExpirationHours", this.rollupExpirationHours).add("traceExpirationHours", this.traceExpirationHours).add("rollupCappedDatabaseSizesMb", this.rollupCappedDatabaseSizesMb).add("traceCappedDatabaseSizeMb", this.traceCappedDatabaseSizeMb).add("version", this.version).toString();
    }

    @JsonCreator
    public static StorageConfig fromAllAttributes(@JsonProperty(value="rollupExpirationHours") @Nullable ImmutableList<Integer> rollupExpirationHours, @JsonProperty(value="traceExpirationHours") @Nullable Integer traceExpirationHours, @JsonProperty(value="rollupCappedDatabaseSizesMb") @Nullable ImmutableList<Integer> rollupCappedDatabaseSizesMb, @JsonProperty(value="traceCappedDatabaseSizeMb") @Nullable Integer traceCappedDatabaseSizeMb) {
        Builder builder = StorageConfig.builder();
        if (rollupExpirationHours != null) {
            builder.rollupExpirationHours(rollupExpirationHours);
        }
        if (traceExpirationHours != null) {
            builder.traceExpirationHours(traceExpirationHours);
        }
        if (rollupCappedDatabaseSizesMb != null) {
            builder.rollupCappedDatabaseSizesMb(rollupCappedDatabaseSizesMb);
        }
        if (traceCappedDatabaseSizeMb != null) {
            builder.traceCappedDatabaseSizeMb(traceCappedDatabaseSizeMb);
        }
        return builder.build();
    }

    public static StorageConfig copyOf(StorageConfigBase instance) {
        if (instance instanceof StorageConfig) {
            return (StorageConfig)instance;
        }
        return StorageConfig.builder().rollupExpirationHours(instance.rollupExpirationHours()).traceExpirationHours(instance.traceExpirationHours()).rollupCappedDatabaseSizesMb(instance.rollupCappedDatabaseSizesMb()).traceCappedDatabaseSizeMb(instance.traceCappedDatabaseSizeMb()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_ROLLUP_EXPIRATION_HOURS = 1L;
        private static final long NONDEFAULT_BIT_TRACE_EXPIRATION_HOURS = 2L;
        private static final long NONDEFAULT_BIT_ROLLUP_CAPPED_DATABASE_SIZES_MB = 4L;
        private static final long NONDEFAULT_BIT_TRACE_CAPPED_DATABASE_SIZE_MB = 8L;
        private long nondefaultBitset;
        @Nullable
        private ImmutableList<Integer> rollupExpirationHours;
        private int traceExpirationHours;
        @Nullable
        private ImmutableList<Integer> rollupCappedDatabaseSizesMb;
        private int traceCappedDatabaseSizeMb;

        private Builder() {
        }

        public final Builder rollupExpirationHours(ImmutableList<Integer> rollupExpirationHours) {
            this.checkNotIsSet(this.rollupExpirationHoursIsSet(), "rollupExpirationHours");
            this.rollupExpirationHours = Preconditions.checkNotNull(rollupExpirationHours);
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder traceExpirationHours(int traceExpirationHours) {
            this.checkNotIsSet(this.traceExpirationHoursIsSet(), "traceExpirationHours");
            this.traceExpirationHours = traceExpirationHours;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder rollupCappedDatabaseSizesMb(ImmutableList<Integer> rollupCappedDatabaseSizesMb) {
            this.checkNotIsSet(this.rollupCappedDatabaseSizesMbIsSet(), "rollupCappedDatabaseSizesMb");
            this.rollupCappedDatabaseSizesMb = Preconditions.checkNotNull(rollupCappedDatabaseSizesMb);
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder traceCappedDatabaseSizeMb(int traceCappedDatabaseSizeMb) {
            this.checkNotIsSet(this.traceCappedDatabaseSizeMbIsSet(), "traceCappedDatabaseSizeMb");
            this.traceCappedDatabaseSizeMb = traceCappedDatabaseSizeMb;
            this.nondefaultBitset |= 8L;
            return this;
        }

        public StorageConfig build() {
            return new StorageConfig(this);
        }

        private boolean rollupExpirationHoursIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean traceExpirationHoursIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean rollupCappedDatabaseSizesMbIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean traceCappedDatabaseSizeMbIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of StorageConfig is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

