/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.config.StorageConfig;
import org.glowroot.config.Versions;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.immutables.value.Value;

@JsonIgnoreProperties(value={"aggregateExpirationHours", "gaugeExpirationHours"})
@Value.Immutable
public abstract class StorageConfigBase {
    private static final ImmutableList<Integer> DEFAULT_ROLLUP_EXPIRATION_HOURS = ImmutableList.of(Integer.valueOf(48), Integer.valueOf(336), Integer.valueOf(1440));
    private static final ImmutableList<Integer> DEFAULT_CAPPED_DATABASE_SIZES_MB = ImmutableList.of(Integer.valueOf(500), Integer.valueOf(500), Integer.valueOf(500));

    public ImmutableList<Integer> rollupExpirationHours() {
        return DEFAULT_ROLLUP_EXPIRATION_HOURS;
    }

    public int traceExpirationHours() {
        return 168;
    }

    public ImmutableList<Integer> rollupCappedDatabaseSizesMb() {
        return DEFAULT_CAPPED_DATABASE_SIZES_MB;
    }

    public int traceCappedDatabaseSizeMb() {
        return 500;
    }

    @JsonIgnore
    public String version() {
        return Versions.getVersion(this);
    }

    boolean hasListIssues() {
        return this.rollupExpirationHours().size() != DEFAULT_ROLLUP_EXPIRATION_HOURS.size() || this.rollupCappedDatabaseSizesMb().size() != DEFAULT_CAPPED_DATABASE_SIZES_MB.size();
    }

    StorageConfig withCorrectedLists() {
        StorageConfig thisConfig = (StorageConfig)this;
        StorageConfig defaultConfig = StorageConfig.builder().build();
        ImmutableList<Integer> rollupExpirationHours = this.fix(this.rollupExpirationHours(), defaultConfig.rollupExpirationHours());
        ImmutableList<Integer> rollupCappedDatabaseSizesMb = this.fix(this.rollupCappedDatabaseSizesMb(), defaultConfig.rollupCappedDatabaseSizesMb());
        return thisConfig.withRollupExpirationHours(rollupExpirationHours).withRollupCappedDatabaseSizesMb(rollupCappedDatabaseSizesMb);
    }

    private ImmutableList<Integer> fix(ImmutableList<Integer> thisList, List<Integer> defaultList) {
        if (thisList.size() >= defaultList.size()) {
            return thisList.subList(0, defaultList.size());
        }
        ArrayList<Integer> correctedList = Lists.newArrayList(thisList);
        for (int i = thisList.size(); i < defaultList.size(); ++i) {
            correctedList.add(defaultList.get(i));
        }
        return ImmutableList.copyOf(correctedList);
    }
}

