/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.config;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.config.TransactionConfigBase;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;

@ParametersAreNonnullByDefault
@Immutable
public final class TransactionConfig
extends TransactionConfigBase {
    private final int profilingIntervalMillis;
    private final int slowThresholdMillis;
    private final String defaultDisplayedTransactionType;
    private final ImmutableList<Double> defaultDisplayedPercentiles;
    private final String version;

    private TransactionConfig(Builder builder) {
        this.profilingIntervalMillis = builder.profilingIntervalMillisIsSet() ? builder.profilingIntervalMillis : super.profilingIntervalMillis();
        this.slowThresholdMillis = builder.slowThresholdMillisIsSet() ? builder.slowThresholdMillis : super.slowThresholdMillis();
        this.defaultDisplayedTransactionType = builder.defaultDisplayedTransactionType != null ? builder.defaultDisplayedTransactionType : Preconditions.checkNotNull(super.defaultDisplayedTransactionType());
        this.defaultDisplayedPercentiles = builder.defaultDisplayedPercentiles != null ? builder.defaultDisplayedPercentiles : Preconditions.checkNotNull(super.defaultDisplayedPercentiles());
        this.version = Preconditions.checkNotNull(super.version());
    }

    private TransactionConfig(int profilingIntervalMillis, int slowThresholdMillis, String defaultDisplayedTransactionType, ImmutableList<Double> defaultDisplayedPercentiles) {
        this.profilingIntervalMillis = profilingIntervalMillis;
        this.slowThresholdMillis = slowThresholdMillis;
        this.defaultDisplayedTransactionType = defaultDisplayedTransactionType;
        this.defaultDisplayedPercentiles = defaultDisplayedPercentiles;
        this.version = Preconditions.checkNotNull(super.version());
    }

    @Override
    @JsonProperty(value="profilingIntervalMillis")
    public int profilingIntervalMillis() {
        return this.profilingIntervalMillis;
    }

    @Override
    @JsonProperty(value="slowThresholdMillis")
    public int slowThresholdMillis() {
        return this.slowThresholdMillis;
    }

    @Override
    @JsonProperty(value="defaultDisplayedTransactionType")
    public String defaultDisplayedTransactionType() {
        return this.defaultDisplayedTransactionType;
    }

    @Override
    @JsonProperty(value="defaultDisplayedPercentiles")
    public ImmutableList<Double> defaultDisplayedPercentiles() {
        return this.defaultDisplayedPercentiles;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final TransactionConfig withProfilingIntervalMillis(int value) {
        if (this.profilingIntervalMillis == value) {
            return this;
        }
        int newValue = value;
        return new TransactionConfig(newValue, this.slowThresholdMillis, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles);
    }

    public final TransactionConfig withSlowThresholdMillis(int value) {
        if (this.slowThresholdMillis == value) {
            return this;
        }
        int newValue = value;
        return new TransactionConfig(this.profilingIntervalMillis, newValue, this.defaultDisplayedTransactionType, this.defaultDisplayedPercentiles);
    }

    public final TransactionConfig withDefaultDisplayedTransactionType(String value) {
        if (this.defaultDisplayedTransactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TransactionConfig(this.profilingIntervalMillis, this.slowThresholdMillis, newValue, this.defaultDisplayedPercentiles);
    }

    public final TransactionConfig withDefaultDisplayedPercentiles(ImmutableList<Double> value) {
        if (this.defaultDisplayedPercentiles == value) {
            return this;
        }
        ImmutableList<Double> newValue = Preconditions.checkNotNull(value);
        return new TransactionConfig(this.profilingIntervalMillis, this.slowThresholdMillis, this.defaultDisplayedTransactionType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TransactionConfig && this.equalTo((TransactionConfig)another);
    }

    private boolean equalTo(TransactionConfig another) {
        return this.profilingIntervalMillis == another.profilingIntervalMillis && this.slowThresholdMillis == another.slowThresholdMillis && this.defaultDisplayedTransactionType.equals(another.defaultDisplayedTransactionType) && this.defaultDisplayedPercentiles.equals(another.defaultDisplayedPercentiles) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.profilingIntervalMillis;
        h = h * 17 + this.slowThresholdMillis;
        h = h * 17 + this.defaultDisplayedTransactionType.hashCode();
        h = h * 17 + this.defaultDisplayedPercentiles.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionConfig").add("profilingIntervalMillis", this.profilingIntervalMillis).add("slowThresholdMillis", this.slowThresholdMillis).add("defaultDisplayedTransactionType", this.defaultDisplayedTransactionType).add("defaultDisplayedPercentiles", this.defaultDisplayedPercentiles).add("version", this.version).toString();
    }

    @JsonCreator
    public static TransactionConfig fromAllAttributes(@JsonProperty(value="profilingIntervalMillis") @Nullable Integer profilingIntervalMillis, @JsonProperty(value="slowThresholdMillis") @Nullable Integer slowThresholdMillis, @JsonProperty(value="defaultDisplayedTransactionType") @Nullable String defaultDisplayedTransactionType, @JsonProperty(value="defaultDisplayedPercentiles") @Nullable ImmutableList<Double> defaultDisplayedPercentiles) {
        Builder builder = TransactionConfig.builder();
        if (profilingIntervalMillis != null) {
            builder.profilingIntervalMillis(profilingIntervalMillis);
        }
        if (slowThresholdMillis != null) {
            builder.slowThresholdMillis(slowThresholdMillis);
        }
        if (defaultDisplayedTransactionType != null) {
            builder.defaultDisplayedTransactionType(defaultDisplayedTransactionType);
        }
        if (defaultDisplayedPercentiles != null) {
            builder.defaultDisplayedPercentiles(defaultDisplayedPercentiles);
        }
        return builder.build();
    }

    public static TransactionConfig copyOf(TransactionConfigBase instance) {
        if (instance instanceof TransactionConfig) {
            return (TransactionConfig)instance;
        }
        return TransactionConfig.builder().profilingIntervalMillis(instance.profilingIntervalMillis()).slowThresholdMillis(instance.slowThresholdMillis()).defaultDisplayedTransactionType(instance.defaultDisplayedTransactionType()).defaultDisplayedPercentiles(instance.defaultDisplayedPercentiles()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long NONDEFAULT_BIT_PROFILING_INTERVAL_MILLIS = 1L;
        private static final long NONDEFAULT_BIT_SLOW_THRESHOLD_MILLIS = 2L;
        private static final long NONDEFAULT_BIT_DEFAULT_DISPLAYED_TRANSACTION_TYPE = 4L;
        private static final long NONDEFAULT_BIT_DEFAULT_DISPLAYED_PERCENTILES = 8L;
        private long nondefaultBitset;
        private int profilingIntervalMillis;
        private int slowThresholdMillis;
        @Nullable
        private String defaultDisplayedTransactionType;
        @Nullable
        private ImmutableList<Double> defaultDisplayedPercentiles;

        private Builder() {
        }

        public final Builder profilingIntervalMillis(int profilingIntervalMillis) {
            this.checkNotIsSet(this.profilingIntervalMillisIsSet(), "profilingIntervalMillis");
            this.profilingIntervalMillis = profilingIntervalMillis;
            this.nondefaultBitset |= 1L;
            return this;
        }

        public final Builder slowThresholdMillis(int slowThresholdMillis) {
            this.checkNotIsSet(this.slowThresholdMillisIsSet(), "slowThresholdMillis");
            this.slowThresholdMillis = slowThresholdMillis;
            this.nondefaultBitset |= 2L;
            return this;
        }

        public final Builder defaultDisplayedTransactionType(String defaultDisplayedTransactionType) {
            this.checkNotIsSet(this.defaultDisplayedTransactionTypeIsSet(), "defaultDisplayedTransactionType");
            this.defaultDisplayedTransactionType = Preconditions.checkNotNull(defaultDisplayedTransactionType);
            this.nondefaultBitset |= 4L;
            return this;
        }

        public final Builder defaultDisplayedPercentiles(ImmutableList<Double> defaultDisplayedPercentiles) {
            this.checkNotIsSet(this.defaultDisplayedPercentilesIsSet(), "defaultDisplayedPercentiles");
            this.defaultDisplayedPercentiles = Preconditions.checkNotNull(defaultDisplayedPercentiles);
            this.nondefaultBitset |= 8L;
            return this;
        }

        public TransactionConfig build() {
            return new TransactionConfig(this);
        }

        private boolean profilingIntervalMillisIsSet() {
            return (this.nondefaultBitset & 1L) != 0L;
        }

        private boolean slowThresholdMillisIsSet() {
            return (this.nondefaultBitset & 2L) != 0L;
        }

        private boolean defaultDisplayedTransactionTypeIsSet() {
            return (this.nondefaultBitset & 4L) != 0L;
        }

        private boolean defaultDisplayedPercentilesIsSet() {
            return (this.nondefaultBitset & 8L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of TransactionConfig is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

